/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.flow.spring;

import com.cloudera.com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactoryFactory;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowDefinitionFactoryFactory;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowImplementationFactory;
import com.cloudera.com.amazonaws.services.simpleworkflow.flow.spring.WorkflowScope;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpringWorkflowDefinitionFactoryFactory
extends WorkflowDefinitionFactoryFactory {
    private final POJOWorkflowDefinitionFactoryFactory impl = new POJOWorkflowDefinitionFactoryFactory(){

        @Override
        protected POJOWorkflowImplementationFactory getImplementationFactory(Class<?> workflowImplementationType, Class<?> workflowInteface, WorkflowType workflowType) {
            final Object instanceProxy = SpringWorkflowDefinitionFactoryFactory.this.workflowImplementations.get(workflowImplementationType);
            if (instanceProxy == null) {
                throw new IllegalArgumentException("unknown workflowImplementationType: " + workflowImplementationType);
            }
            return new POJOWorkflowImplementationFactory(){

                public Object newInstance(DecisionContext decisionContext) throws Exception {
                    WorkflowScope.setDecisionContext(decisionContext);
                    return instanceProxy;
                }

                public void deleteInstance(Object instance) {
                    WorkflowScope.removeDecisionContext();
                }
            };
        }
    };
    private final Map<Class<?>, Object> workflowImplementations = new HashMap();

    SpringWorkflowDefinitionFactoryFactory() {
    }

    @Override
    public WorkflowDefinitionFactory getWorkflowDefinitionFactory(WorkflowType workflowType) {
        return this.impl.getWorkflowDefinitionFactory(workflowType);
    }

    @Override
    public Iterable<WorkflowType> getWorkflowTypesToRegister() {
        return this.impl.getWorkflowTypesToRegister();
    }

    public void setWorkflowImplementations(Iterable<Object> workflowImplementations) throws InstantiationException, IllegalAccessException {
        for (Object workflowImplementation : workflowImplementations) {
            this.addWorkflowImplementation(workflowImplementation);
        }
    }

    public Iterable<Object> getWorkflowImplementations() {
        return this.workflowImplementations.values();
    }

    public void addWorkflowImplementation(Object workflowImplementation) throws InstantiationException, IllegalAccessException {
        Class<?> implementationClass = workflowImplementation.getClass();
        this.workflowImplementations.put(implementationClass, workflowImplementation);
        this.impl.addWorkflowImplementationType(implementationClass);
    }

    public DataConverter getDataConverter() {
        return this.impl.getDataConverter();
    }

    public void setDataConverter(DataConverter converter) {
        this.impl.setDataConverter(converter);
    }
}

