/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.simpleworkflow.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.http.HttpMethodName;
import com.cloudera.com.amazonaws.services.simpleworkflow.model.ListWorkflowTypesRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringInputStream;
import com.cloudera.com.amazonaws.util.StringUtils;
import com.cloudera.com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListWorkflowTypesRequestMarshaller
implements Marshaller<Request<ListWorkflowTypesRequest>, ListWorkflowTypesRequest> {
    @Override
    public Request<ListWorkflowTypesRequest> marshall(ListWorkflowTypesRequest listWorkflowTypesRequest) {
        if (listWorkflowTypesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListWorkflowTypesRequest> request = new DefaultRequest<ListWorkflowTypesRequest>(listWorkflowTypesRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.ListWorkflowTypes";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listWorkflowTypesRequest.getDomain() != null) {
                jsonWriter.key("domain").value(listWorkflowTypesRequest.getDomain());
            }
            if (listWorkflowTypesRequest.getName() != null) {
                jsonWriter.key("name").value(listWorkflowTypesRequest.getName());
            }
            if (listWorkflowTypesRequest.getRegistrationStatus() != null) {
                jsonWriter.key("registrationStatus").value(listWorkflowTypesRequest.getRegistrationStatus());
            }
            if (listWorkflowTypesRequest.getNextPageToken() != null) {
                jsonWriter.key("nextPageToken").value(listWorkflowTypesRequest.getNextPageToken());
            }
            if (listWorkflowTypesRequest.getMaximumPageSize() != null) {
                jsonWriter.key("maximumPageSize").value(listWorkflowTypesRequest.getMaximumPageSize());
            }
            if (listWorkflowTypesRequest.isReverseOrder() != null) {
                jsonWriter.key("reverseOrder").value(listWorkflowTypesRequest.isReverseOrder());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

