/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.sns.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.sns.model.CreatePlatformApplicationRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePlatformApplicationRequestMarshaller
implements Marshaller<Request<CreatePlatformApplicationRequest>, CreatePlatformApplicationRequest> {
    @Override
    public Request<CreatePlatformApplicationRequest> marshall(CreatePlatformApplicationRequest createPlatformApplicationRequest) {
        if (createPlatformApplicationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePlatformApplicationRequest> request = new DefaultRequest<CreatePlatformApplicationRequest>(createPlatformApplicationRequest, "AmazonSNS");
        request.addParameter("Action", "CreatePlatformApplication");
        request.addParameter("Version", "2010-03-31");
        if (createPlatformApplicationRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(createPlatformApplicationRequest.getName()));
        }
        if (createPlatformApplicationRequest.getPlatform() != null) {
            request.addParameter("Platform", StringUtils.fromString(createPlatformApplicationRequest.getPlatform()));
        }
        if (createPlatformApplicationRequest != null && createPlatformApplicationRequest.getAttributes() != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> attributesListValue : createPlatformApplicationRequest.getAttributes().entrySet()) {
                if (attributesListValue.getKey() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".key", StringUtils.fromString(attributesListValue.getKey()));
                }
                if (attributesListValue.getValue() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".value", StringUtils.fromString(attributesListValue.getValue()));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

