/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.sns.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.sns.model.SubscribeRequest;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscribeRequestMarshaller
implements Marshaller<Request<SubscribeRequest>, SubscribeRequest> {
    @Override
    public Request<SubscribeRequest> marshall(SubscribeRequest subscribeRequest) {
        if (subscribeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SubscribeRequest> request = new DefaultRequest<SubscribeRequest>(subscribeRequest, "AmazonSNS");
        request.addParameter("Action", "Subscribe");
        request.addParameter("Version", "2010-03-31");
        if (subscribeRequest.getTopicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString(subscribeRequest.getTopicArn()));
        }
        if (subscribeRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString(subscribeRequest.getProtocol()));
        }
        if (subscribeRequest.getEndpoint() != null) {
            request.addParameter("Endpoint", StringUtils.fromString(subscribeRequest.getEndpoint()));
        }
        return request;
    }
}

