/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.services.sqs.model.transform;

import com.cloudera.com.amazonaws.AmazonClientException;
import com.cloudera.com.amazonaws.DefaultRequest;
import com.cloudera.com.amazonaws.Request;
import com.cloudera.com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.cloudera.com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.cloudera.com.amazonaws.transform.Marshaller;
import com.cloudera.com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteMessageBatchRequestMarshaller
implements Marshaller<Request<DeleteMessageBatchRequest>, DeleteMessageBatchRequest> {
    @Override
    public Request<DeleteMessageBatchRequest> marshall(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        if (deleteMessageBatchRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteMessageBatchRequest> request = new DefaultRequest<DeleteMessageBatchRequest>(deleteMessageBatchRequest, "AmazonSQS");
        request.addParameter("Action", "DeleteMessageBatch");
        request.addParameter("Version", "2012-11-05");
        if (deleteMessageBatchRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(deleteMessageBatchRequest.getQueueUrl()));
        }
        List<DeleteMessageBatchRequestEntry> entriesList = deleteMessageBatchRequest.getEntries();
        int entriesListIndex = 1;
        for (DeleteMessageBatchRequestEntry entriesListValue : entriesList) {
            DeleteMessageBatchRequestEntry deleteMessageBatchRequestEntryMember = entriesListValue;
            if (deleteMessageBatchRequestEntryMember != null) {
                if (deleteMessageBatchRequestEntryMember.getId() != null) {
                    request.addParameter("DeleteMessageBatchRequestEntry." + entriesListIndex + ".Id", StringUtils.fromString(deleteMessageBatchRequestEntryMember.getId()));
                }
                if (deleteMessageBatchRequestEntryMember.getReceiptHandle() != null) {
                    request.addParameter("DeleteMessageBatchRequestEntry." + entriesListIndex + ".ReceiptHandle", StringUtils.fromString(deleteMessageBatchRequestEntryMember.getReceiptHandle()));
                }
            }
            ++entriesListIndex;
        }
        return request;
    }
}

