/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.transform;

import com.cloudera.com.amazonaws.AmazonServiceException;
import com.cloudera.com.amazonaws.transform.AbstractErrorUnmarshaller;
import com.cloudera.com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardErrorUnmarshaller
extends AbstractErrorUnmarshaller<Node> {
    public StandardErrorUnmarshaller() {
    }

    protected StandardErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass) {
        super(exceptionClass);
    }

    @Override
    public AmazonServiceException unmarshall(Node in) throws Exception {
        String errorCode = this.parseErrorCode(in);
        String errorType = XpathUtils.asString("ErrorResponse/Error/Type", in);
        String requestId = XpathUtils.asString("ErrorResponse/RequestId", in);
        String message = XpathUtils.asString("ErrorResponse/Error/Message", in);
        AmazonServiceException ase = this.newException(message);
        ase.setErrorCode(errorCode);
        ase.setRequestId(requestId);
        if (errorType == null) {
            ase.setErrorType(AmazonServiceException.ErrorType.Unknown);
        } else if (errorType.equalsIgnoreCase("Receiver")) {
            ase.setErrorType(AmazonServiceException.ErrorType.Service);
        } else if (errorType.equalsIgnoreCase("Sender")) {
            ase.setErrorType(AmazonServiceException.ErrorType.Client);
        }
        return ase;
    }

    public String parseErrorCode(Node in) throws Exception {
        return XpathUtils.asString("ErrorResponse/Error/Code", in);
    }

    public String getErrorPropertyPath(String property) {
        return "ErrorResponse/Error/" + property;
    }
}

