/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.fasterxml.jackson.databind.cfg;

import com.cloudera.com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.cloudera.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.cloudera.com.fasterxml.jackson.databind.deser.Deserializers;
import com.cloudera.com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.cloudera.com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.cloudera.com.fasterxml.jackson.databind.deser.std.StdKeyDeserializers;
import com.cloudera.com.fasterxml.jackson.databind.util.ArrayBuilders;
import java.io.Serializable;

public class DeserializerFactoryConfig
implements Serializable {
    private static final long serialVersionUID = 3683541151102256824L;
    protected static final Deserializers[] NO_DESERIALIZERS = new Deserializers[0];
    protected static final BeanDeserializerModifier[] NO_MODIFIERS = new BeanDeserializerModifier[0];
    protected static final AbstractTypeResolver[] NO_ABSTRACT_TYPE_RESOLVERS = new AbstractTypeResolver[0];
    protected static final ValueInstantiators[] NO_VALUE_INSTANTIATORS = new ValueInstantiators[0];
    protected static final KeyDeserializers[] DEFAULT_KEY_DESERIALIZERS = new KeyDeserializers[]{new StdKeyDeserializers()};
    protected final Deserializers[] _additionalDeserializers;
    protected final KeyDeserializers[] _additionalKeyDeserializers;
    protected final BeanDeserializerModifier[] _modifiers;
    protected final AbstractTypeResolver[] _abstractTypeResolvers;
    protected final ValueInstantiators[] _valueInstantiators;

    public DeserializerFactoryConfig() {
        this(null, null, null, null, null);
    }

    protected DeserializerFactoryConfig(Deserializers[] deserializersArray, KeyDeserializers[] keyDeserializersArray, BeanDeserializerModifier[] beanDeserializerModifierArray, AbstractTypeResolver[] abstractTypeResolverArray, ValueInstantiators[] valueInstantiatorsArray) {
        this._additionalDeserializers = deserializersArray == null ? NO_DESERIALIZERS : deserializersArray;
        this._additionalKeyDeserializers = keyDeserializersArray == null ? DEFAULT_KEY_DESERIALIZERS : keyDeserializersArray;
        this._modifiers = beanDeserializerModifierArray == null ? NO_MODIFIERS : beanDeserializerModifierArray;
        this._abstractTypeResolvers = abstractTypeResolverArray == null ? NO_ABSTRACT_TYPE_RESOLVERS : abstractTypeResolverArray;
        this._valueInstantiators = valueInstantiatorsArray == null ? NO_VALUE_INSTANTIATORS : valueInstantiatorsArray;
    }

    public DeserializerFactoryConfig withAdditionalDeserializers(Deserializers deserializers) {
        if (deserializers == null) {
            throw new IllegalArgumentException("Can not pass null Deserializers");
        }
        Deserializers[] deserializersArray = ArrayBuilders.insertInListNoDup(this._additionalDeserializers, deserializers);
        return new DeserializerFactoryConfig(deserializersArray, this._additionalKeyDeserializers, this._modifiers, this._abstractTypeResolvers, this._valueInstantiators);
    }

    public DeserializerFactoryConfig withAdditionalKeyDeserializers(KeyDeserializers keyDeserializers) {
        if (keyDeserializers == null) {
            throw new IllegalArgumentException("Can not pass null KeyDeserializers");
        }
        KeyDeserializers[] keyDeserializersArray = ArrayBuilders.insertInListNoDup(this._additionalKeyDeserializers, keyDeserializers);
        return new DeserializerFactoryConfig(this._additionalDeserializers, keyDeserializersArray, this._modifiers, this._abstractTypeResolvers, this._valueInstantiators);
    }

    public DeserializerFactoryConfig withDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
        if (beanDeserializerModifier == null) {
            throw new IllegalArgumentException("Can not pass null modifier");
        }
        BeanDeserializerModifier[] beanDeserializerModifierArray = ArrayBuilders.insertInListNoDup(this._modifiers, beanDeserializerModifier);
        return new DeserializerFactoryConfig(this._additionalDeserializers, this._additionalKeyDeserializers, beanDeserializerModifierArray, this._abstractTypeResolvers, this._valueInstantiators);
    }

    public DeserializerFactoryConfig withAbstractTypeResolver(AbstractTypeResolver abstractTypeResolver) {
        if (abstractTypeResolver == null) {
            throw new IllegalArgumentException("Can not pass null resolver");
        }
        AbstractTypeResolver[] abstractTypeResolverArray = ArrayBuilders.insertInListNoDup(this._abstractTypeResolvers, abstractTypeResolver);
        return new DeserializerFactoryConfig(this._additionalDeserializers, this._additionalKeyDeserializers, this._modifiers, abstractTypeResolverArray, this._valueInstantiators);
    }

    public DeserializerFactoryConfig withValueInstantiators(ValueInstantiators valueInstantiators) {
        if (valueInstantiators == null) {
            throw new IllegalArgumentException("Can not pass null resolver");
        }
        ValueInstantiators[] valueInstantiatorsArray = ArrayBuilders.insertInListNoDup(this._valueInstantiators, valueInstantiators);
        return new DeserializerFactoryConfig(this._additionalDeserializers, this._additionalKeyDeserializers, this._modifiers, this._abstractTypeResolvers, valueInstantiatorsArray);
    }

    public boolean hasDeserializers() {
        return this._additionalDeserializers.length > 0;
    }

    public boolean hasKeyDeserializers() {
        return this._additionalKeyDeserializers.length > 0;
    }

    public boolean hasDeserializerModifiers() {
        return this._modifiers.length > 0;
    }

    public boolean hasAbstractTypeResolvers() {
        return this._abstractTypeResolvers.length > 0;
    }

    public boolean hasValueInstantiators() {
        return this._valueInstantiators.length > 0;
    }

    public Iterable<Deserializers> deserializers() {
        return ArrayBuilders.arrayAsIterable(this._additionalDeserializers);
    }

    public Iterable<KeyDeserializers> keyDeserializers() {
        return ArrayBuilders.arrayAsIterable(this._additionalKeyDeserializers);
    }

    public Iterable<BeanDeserializerModifier> deserializerModifiers() {
        return ArrayBuilders.arrayAsIterable(this._modifiers);
    }

    public Iterable<AbstractTypeResolver> abstractTypeResolvers() {
        return ArrayBuilders.arrayAsIterable(this._abstractTypeResolvers);
    }

    public Iterable<ValueInstantiators> valueInstantiators() {
        return ArrayBuilders.arrayAsIterable(this._valueInstantiators);
    }
}

