/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.cloudera.com.amazonaws.services.s3.AmazonS3Client;
import com.cloudera.com.amazonaws.services.s3.model.GetObjectRequest;
import com.cloudera.com.amazonaws.services.s3.model.S3Object;
import com.cloudera.com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.slf4j.Logger;

public class S3AInputStream
extends FSInputStream {
    private long pos;
    private boolean closed;
    private S3ObjectInputStream wrappedStream;
    private S3Object wrappedObject;
    private FileSystem.Statistics stats;
    private AmazonS3Client client;
    private String bucket;
    private String key;
    private long contentLength;
    public static final Logger LOG = S3AFileSystem.LOG;

    public S3AInputStream(String bucket, String key, long contentLength, AmazonS3Client client, FileSystem.Statistics stats) {
        this.bucket = bucket;
        this.key = key;
        this.contentLength = contentLength;
        this.client = client;
        this.stats = stats;
        this.pos = 0L;
        this.closed = false;
        this.wrappedObject = null;
        this.wrappedStream = null;
    }

    private void openIfNeeded() throws IOException {
        if (this.wrappedObject == null) {
            this.reopen(0L);
        }
    }

    private synchronized void reopen(long pos) throws IOException {
        if (this.wrappedStream != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborting old stream to open at pos " + pos);
            }
            this.wrappedStream.abort();
        }
        if (pos < 0L) {
            throw new EOFException("Cannot seek to a negative offset " + pos);
        }
        if (this.contentLength > 0L && pos > this.contentLength - 1L) {
            throw new EOFException("Attempted to seek or read past the end of the file " + pos);
        }
        LOG.debug("Actually opening file " + this.key + " at pos " + pos);
        GetObjectRequest request = new GetObjectRequest(this.bucket, this.key);
        request.setRange(pos, this.contentLength - 1L);
        this.wrappedObject = this.client.getObject(request);
        this.wrappedStream = this.wrappedObject.getObjectContent();
        if (this.wrappedStream == null) {
            throw new IOException("Null IO stream");
        }
        this.pos = pos;
    }

    public synchronized long getPos() throws IOException {
        return this.pos;
    }

    public synchronized void seek(long pos) throws IOException {
        this.checkNotClosed();
        if (this.pos == pos) {
            return;
        }
        LOG.debug("Reopening " + this.key + " to seek to new offset " + (pos - this.pos));
        this.reopen(pos);
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    public synchronized int read() throws IOException {
        int byteRead;
        this.checkNotClosed();
        this.openIfNeeded();
        try {
            byteRead = this.wrappedStream.read();
        }
        catch (SocketTimeoutException e) {
            LOG.info("Got timeout while trying to read from stream, trying to recover " + e);
            this.reopen(this.pos);
            byteRead = this.wrappedStream.read();
        }
        catch (SocketException e) {
            LOG.info("Got socket exception while trying to read from stream, trying to recover " + e);
            this.reopen(this.pos);
            byteRead = this.wrappedStream.read();
        }
        if (byteRead >= 0) {
            ++this.pos;
        }
        if (this.stats != null && byteRead >= 0) {
            this.stats.incrementBytesRead(1L);
        }
        return byteRead;
    }

    public synchronized int read(byte[] buf, int off, int len) throws IOException {
        int byteRead;
        this.checkNotClosed();
        this.openIfNeeded();
        try {
            byteRead = this.wrappedStream.read(buf, off, len);
        }
        catch (SocketTimeoutException e) {
            LOG.info("Got timeout while trying to read from stream, trying to recover " + e);
            this.reopen(this.pos);
            byteRead = this.wrappedStream.read(buf, off, len);
        }
        catch (SocketException e) {
            LOG.info("Got socket exception while trying to read from stream, trying to recover " + e);
            this.reopen(this.pos);
            byteRead = this.wrappedStream.read(buf, off, len);
        }
        if (byteRead > 0) {
            this.pos += (long)byteRead;
        }
        if (this.stats != null && byteRead > 0) {
            this.stats.incrementBytesRead((long)byteRead);
        }
        return byteRead;
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed!");
        }
    }

    public synchronized void close() throws IOException {
        super.close();
        this.closed = true;
        if (this.wrappedObject != null) {
            this.wrappedObject.close();
        }
    }

    public synchronized int available() throws IOException {
        this.checkNotClosed();
        long remaining = this.contentLength - this.pos;
        if (remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remaining;
    }

    public boolean markSupported() {
        return false;
    }
}

