/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutAttributesRequest
extends AmazonWebServiceRequest {
    private String domainName;
    private String itemName;
    private List<ReplaceableAttribute> attributes;
    private UpdateCondition expected;

    public PutAttributesRequest() {
    }

    public PutAttributesRequest(String domainName, String itemName, List<ReplaceableAttribute> attributes) {
        this.domainName = domainName;
        this.itemName = itemName;
        this.attributes = attributes;
    }

    public PutAttributesRequest(String domainName, String itemName, List<ReplaceableAttribute> attributes, UpdateCondition expected) {
        this.domainName = domainName;
        this.itemName = itemName;
        this.attributes = attributes;
        this.expected = expected;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public PutAttributesRequest withDomainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public PutAttributesRequest withItemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    public List<ReplaceableAttribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<ReplaceableAttribute>();
        }
        return this.attributes;
    }

    public void setAttributes(Collection<ReplaceableAttribute> attributes) {
        ArrayList<ReplaceableAttribute> attributesCopy = new ArrayList<ReplaceableAttribute>();
        if (attributes != null) {
            attributesCopy.addAll(attributes);
        }
        this.attributes = attributesCopy;
    }

    public PutAttributesRequest withAttributes(ReplaceableAttribute ... attributes) {
        for (ReplaceableAttribute value : attributes) {
            this.getAttributes().add(value);
        }
        return this;
    }

    public PutAttributesRequest withAttributes(Collection<ReplaceableAttribute> attributes) {
        ArrayList<ReplaceableAttribute> attributesCopy = new ArrayList<ReplaceableAttribute>();
        if (attributes != null) {
            attributesCopy.addAll(attributes);
        }
        this.attributes = attributesCopy;
        return this;
    }

    public UpdateCondition getExpected() {
        return this.expected;
    }

    public void setExpected(UpdateCondition expected) {
        this.expected = expected;
    }

    public PutAttributesRequest withExpected(UpdateCondition expected) {
        this.expected = expected;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("DomainName: " + this.domainName + ", ");
        sb.append("ItemName: " + this.itemName + ", ");
        sb.append("Attributes: " + this.attributes + ", ");
        sb.append("Expected: " + this.expected + ", ");
        sb.append("}");
        return sb.toString();
    }
}

