/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.exceptions.InternalJDBCError;
import com.sap.dbtech.jdbc.exceptions.NotImplemented;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.StreamIOException;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.packet.PartNotFound;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public abstract class AbstractGetval {
    private ConnectionSapDB connection;
    protected byte[] descriptor;
    protected StructuredMem streamBuffer;
    protected int itemsInBuffer;
    protected int itemSize;
    protected boolean atEnd;
    protected boolean firstChunk = true;
    protected long longPosition = 0L;
    protected long longSize = -1L;

    public AbstractGetval(ConnectionSapDB connectionSapDB, byte[] byArray, StructuredMem structuredMem, int n) {
        this.connection = connectionSapDB;
        this.atEnd = false;
        this.itemSize = n;
        this.setupStreamBuffer(byArray, structuredMem);
    }

    protected boolean nextChunk() throws StreamIOException {
        try {
            ReplyPacket replyPacket;
            byte by = this.descriptor[27];
            if (by == 2 || by == 1) {
                this.atEnd = true;
                return false;
            }
            this.firstChunk = false;
            RequestPacket requestPacket = this.connection.getRequestPacket();
            DataPart dataPart = requestPacket.initGetval(this.connection.getAutoCommit());
            dataPart.putInt1(0, 0);
            dataPart.putBytes(this.descriptor, 1);
            int n = 0x7FFFFFFE;
            dataPart.putInt4(n, 37);
            dataPart.addArg(1, 40);
            dataPart.close();
            try {
                replyPacket = this.connection.execute(requestPacket, this, false);
            }
            catch (SQLExceptionSapDB sQLExceptionSapDB) {
                throw new StreamIOException(sQLExceptionSapDB);
            }
            replyPacket.findPart(18);
            int n2 = replyPacket.getPartDataPos();
            this.descriptor = replyPacket.getDataBytes(n2, 41);
            this.setupStreamBuffer(this.descriptor, replyPacket.getPointer(n2));
            return true;
        }
        catch (SQLException sQLException) {
            throw new StreamIOException((SQLExceptionSapDB)sQLException);
        }
        catch (PartNotFound partNotFound) {
            throw new StreamIOException(new InternalJDBCError(MessageTranslator.translate("error.longdata.expected")));
        }
    }

    protected ReplyPacket executeGetval(byte[] byArray) throws SQLException {
        RequestPacket requestPacket = this.connection.getRequestPacket();
        DataPart dataPart = requestPacket.initGetval(this.connection.getAutoCommit());
        dataPart.putInt1(0, 0);
        dataPart.putBytes(byArray, 1);
        dataPart.putInt4(0x7FFFFFFE, 37);
        dataPart.addArg(1, 40);
        dataPart.close();
        ReplyPacket replyPacket = this.connection.execute(requestPacket, this, false);
        return replyPacket;
    }

    private void setupStreamBuffer(byte[] byArray, StructuredMem structuredMem) {
        StructuredBytes structuredBytes = new StructuredBytes(byArray);
        int n = ((StructuredMem)structuredBytes).getInt4(32) - 1;
        this.itemsInBuffer = ((StructuredMem)structuredBytes).getInt4(36) / this.itemSize;
        this.streamBuffer = structuredMem.getPointer(n);
        this.descriptor = byArray;
    }

    public long lengthInBytes() throws SQLException {
        if (this.longSize > -1L) {
            return this.longSize;
        }
        StructuredBytes structuredBytes = new StructuredBytes(this.descriptor);
        this.longSize = ((StructuredMem)structuredBytes).getInt4(16);
        if (this.longSize > 0L) {
            return this.longSize;
        }
        this.longSize = this.longSizeRequest();
        return this.longSize;
    }

    protected long longSizeRequest() throws SQLException {
        byte[] byArray = new byte[this.descriptor.length];
        System.arraycopy(this.descriptor, 0, byArray, 0, this.descriptor.length);
        byArray[27] = 6;
        ReplyPacket replyPacket = this.executeGetval(byArray);
        try {
            replyPacket.findPart(18);
        }
        catch (PartNotFound partNotFound) {
            throw new InternalJDBCError(MessageTranslator.translate("error.longdata.expected"));
        }
        int n = replyPacket.getPartDataPos();
        byte[] byArray2 = replyPacket.getDataBytes(n, 41);
        StructuredBytes structuredBytes = new StructuredBytes(byArray2);
        long l = structuredBytes.getInt4(16);
        return l;
    }

    abstract InputStream getAsciiStream() throws SQLException;

    abstract InputStream getBinaryStream() throws SQLException;

    abstract Reader getCharacterStream() throws SQLException;

    public final long position(String string, long l) throws SQLException {
        throw new NotImplemented(MessageTranslator.translate("error.position.notimplemented"));
    }

    public final int setBytes(long l, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setbytes.notimplemented"));
    }

    public final int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setbytes.notimplemented"));
    }

    public final OutputStream setBinaryStream(long l) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setbinarystream.notimplemented"));
    }

    public final void truncate(long l) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.truncate.notimplemented"));
    }

    public final int setString(long l, String string) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setstring.notimplemented"));
    }

    public final int setString(long l, String string, int n, int n2) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setstring.notimplemented"));
    }

    public final OutputStream setAsciiStream(long l) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setasciistream.notimplemented"));
    }

    public final Writer setCharacterStream(long l) throws SQLException {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.setcharacterstream.notimplemented"));
    }

    public final long position(Clob clob, long l) throws SQLException {
        throw new NotImplemented(MessageTranslator.translate("error.position.notimplemented"));
    }
}

