/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.procserver;

import com.sap.dbtech.procserver.Command;
import com.sap.dbtech.procserver.Log;
import com.sap.dbtech.procserver.ProcServerSession;
import com.sap.dbtech.procserver.SocketComm;
import com.sap.dbtech.rte.comm.RTEException;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;

public class ProcServer {
    private boolean isRunning;
    private Dictionary commandTable;

    public ProcServer() {
        this.installCommands();
    }

    protected void installCommands() {
        this.commandTable = new Hashtable();
        Command command = new Command(){

            public String run(String[] stringArray) {
                return "";
            }
        };
        this.commandTable.put("ping", command);
        Command command2 = new Command(){

            public String run(String[] stringArray) {
                ProcServer.this.isRunning = false;
                return "";
            }
        };
        this.commandTable.put("stop", command2);
        Command command3 = new Command(){

            public String run(String[] stringArray) throws ProcServerSession.Exception {
                new ProcServerSession(stringArray[1]).run();
                return "";
            }
        };
        this.commandTable.put("newsession", command3);
    }

    void run(int n) throws RTEException, IOException {
        SocketComm socketComm = new SocketComm(n, 8192);
        this.isRunning = true;
        while (this.isRunning) {
            String string = socketComm.recvString();
            String[] stringArray = this.parseCommand(string);
            Log.log("cmd: " + string);
            Command command = (Command)this.commandTable.get(stringArray[0]);
            if (command == null) {
                Log.logErr("command " + stringArray[0] + " not defined");
                socketComm.sendString("ERR unknown command");
                continue;
            }
            try {
                String string2 = command.run(stringArray);
                Log.log(" ==> '" + string2 + "'");
                socketComm.sendString("OK  " + string2);
            }
            catch (Throwable throwable) {
                Log.traceException(throwable);
                socketComm.sendString("ERR Exception " + throwable.toString());
            }
        }
    }

    protected String[] parseCommand(String string) {
        String string2;
        Vector<String> vector = new Vector<String>(10);
        int n = 0;
        int n2 = string.length();
        char[] cArray = string.toCharArray();
        char c = '\u0000';
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        char[] cArray2 = new char[cArray.length];
        while (n < n2) {
            char c2 = cArray[n];
            if (Character.isWhitespace(c2)) {
                switch (n3) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (bl) {
                            cArray2[n4] = c2;
                            ++n4;
                            break;
                        }
                        string2 = String.copyValueOf(cArray2, 0, n4);
                        vector.addElement(string2);
                        n4 = 0;
                    }
                }
            } else {
                switch (c2) {
                    case '\"': 
                    case '\'': {
                        if (bl) {
                            if (c == c2) {
                                bl = false;
                                break;
                            }
                            cArray2[n4] = c2;
                            ++n4;
                            break;
                        }
                        bl = true;
                        c = c2;
                        n3 = 1;
                        break;
                    }
                    case '\\': {
                        cArray2[n4] = c2 = cArray[++n];
                        ++n4;
                        n3 = 1;
                        break;
                    }
                    default: {
                        cArray2[n4] = c2;
                        ++n4;
                        n3 = 1;
                    }
                }
            }
            ++n;
        }
        if (n3 == 1) {
            string2 = String.copyValueOf(cArray2, 0, n4);
            vector.addElement(string2);
        }
        String[] stringArray = new String[vector.size()];
        int n5 = 0;
        while (n5 < stringArray.length) {
            stringArray[n5] = (String)vector.elementAt(n5);
            ++n5;
        }
        return stringArray;
    }

    public static void main(String[] stringArray) throws IOException {
        Log.open();
        try {
            int n = Integer.parseInt(stringArray[0]);
            Log.log("connecting to port " + n);
            Class.forName("com.sap.dbtech.jdbc.DriverSapDB");
            new ProcServer().run(n);
        }
        catch (Throwable throwable) {
            Log.traceException(throwable);
        }
        Log.close();
    }
}

