/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils;

import java.util.List;
import org.pentaho.di.baserver.utils.GetSessionVariableData;
import org.pentaho.di.baserver.utils.GetSessionVariableMeta;
import org.pentaho.di.baserver.utils.SessionHelper;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;

public class GetSessionVariableStep
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = GetSessionVariableMeta.class;
    private GetSessionVariableMeta meta;
    private GetSessionVariableData data;

    public GetSessionVariableStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetSessionVariableMeta)smi;
        this.data = (GetSessionVariableData)sdi;
        if (super.init(smi, sdi)) {
            this.data.readsRows = this.getStepMeta().getRemoteInputSteps().size() > 0;
            List previous = this.getTransMeta().findPreviousSteps(this.getStepMeta());
            if (previous != null && previous.size() > 0) {
                this.data.readsRows = true;
            }
            return true;
        }
        return false;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (GetSessionVariableMeta)smi;
        this.data = (GetSessionVariableData)sdi;
        if (!this.data.readsRows) {
            Object[] rowData = RowDataUtil.allocateRowData((int)0);
            this.incrementLinesRead();
            this.data.inputRowMeta = new RowMeta();
            this.getSessionVariablesData();
            rowData = RowDataUtil.addRowData((Object[])rowData, (int)this.data.inputRowMeta.size(), (Object[])this.data.extraData);
            this.putRow(this.data.outputRowMeta, rowData);
            this.setOutputDone();
            return false;
        }
        Object[] rowData = this.getRow();
        if (rowData != null) {
            if (this.first) {
                this.first = false;
                this.data.inputRowMeta = this.getInputRowMeta();
                this.getSessionVariablesData();
            }
            rowData = RowDataUtil.addRowData((Object[])rowData, (int)this.data.inputRowMeta.size(), (Object[])this.data.extraData);
            this.putRow(this.data.outputRowMeta, rowData);
            return true;
        }
        this.setOutputDone();
        return false;
    }

    private void getSessionVariablesData() throws KettleException {
        this.data.outputRowMeta = this.data.inputRowMeta.clone();
        this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
        this.data.conversionMeta = this.data.outputRowMeta.cloneToType(2);
        this.data.extraData = new Object[this.meta.getFieldName().length];
        for (int i = 0; i < this.meta.getFieldName().length; ++i) {
            ValueMetaInterface targetMeta = this.data.outputRowMeta.getValueMeta(this.data.inputRowMeta.size() + i);
            ValueMetaInterface sourceMeta = this.data.conversionMeta.getValueMeta(this.data.inputRowMeta.size() + i);
            this.data.extraData[i] = targetMeta.convertData(sourceMeta, this.getValue(this.meta.getVariableName()[i], this.getRowDefaultValue(i)));
        }
    }

    private Object getValue(String varName, Object defaultValue) {
        Object value;
        String sessionVarName;
        block2: {
            sessionVarName = this.environmentSubstitute(varName);
            try {
                value = SessionHelper.getSessionVariable(sessionVarName);
            }
            catch (NoClassDefFoundError e) {
                String pdiVarName = "${_FAKE_SESSION_" + sessionVarName + "}";
                value = this.environmentSubstitute(pdiVarName);
                if (!value.equals(pdiVarName)) break block2;
                value = defaultValue;
            }
        }
        this.logBasic(BaseMessages.getString(PKG, (String)"GetSessionVariable.Log.GetVariable", (Object[])new Object[]{sessionVarName, value}));
        return value;
    }

    private Object getRowDefaultValue(int i) {
        return this.environmentSubstitute(this.meta.getDefaultValue()[i]);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        super.dispose(smi, sdi);
    }
}

