/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils.inspector;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.pentaho.di.baserver.utils.inspector.Endpoint;
import org.pentaho.di.baserver.utils.inspector.WadlParser;
import org.pentaho.di.baserver.utils.web.HttpConnectionHelper;
import org.pentaho.di.baserver.utils.web.Response;
import org.pentaho.di.core.exception.KettleStepException;

public class Inspector {
    private static final String DEFAULT_PLATFORM_NAME = "platform";
    private String serverUrl = "";
    private String userName = "";
    private String password = "";
    private TreeMap<String, TreeMap<String, LinkedList<Endpoint>>> endpoints = new TreeMap();
    private WadlParser parser = new WadlParser();

    public static Inspector getInstance() {
        return InspectorHolder.INSTANCE;
    }

    protected String getServerUrl() {
        return this.serverUrl;
    }

    protected String getUserName() {
        return this.userName;
    }

    protected String getPassword() {
        return this.password;
    }

    protected TreeMap<String, TreeMap<String, LinkedList<Endpoint>>> getEndpointsTree() {
        return this.endpoints;
    }

    protected TreeMap<String, LinkedList<Endpoint>> getModuleEndpoints(String module) {
        return this.getEndpointsTree().get(module);
    }

    protected WadlParser getParser() {
        return this.parser;
    }

    public boolean inspectServer(String serverUrl, String userName, String password) {
        this.serverUrl = serverUrl;
        this.userName = userName;
        this.password = password;
        return this.inspectModuleNames();
    }

    public int checkServerStatus(String serverUrl, String userName, String password) {
        this.serverUrl = serverUrl;
        this.userName = userName;
        this.password = password;
        return this.getConnectionStatus();
    }

    public Iterable<String> getModuleNames() {
        if (this.getEndpointsTree() != null) {
            return this.getEndpointsTree().keySet();
        }
        return Collections.emptyList();
    }

    public String getDefaultModuleName() {
        if (this.getEndpointsTree() != null) {
            return DEFAULT_PLATFORM_NAME;
        }
        return "";
    }

    public Iterable<String> getEndpointPaths(String moduleName) {
        Map<String, LinkedList<Endpoint>> moduleEndpoints = this.getEndpointMap(moduleName);
        return moduleEndpoints.keySet();
    }

    public String getDefaultEndpointPath(String moduleName) {
        Iterable<String> endpointPaths = this.getEndpointPaths(moduleName);
        if (endpointPaths != null && endpointPaths.iterator().hasNext()) {
            return endpointPaths.iterator().next();
        }
        return "";
    }

    public Iterable<Endpoint> getEndpoints(String moduleName, String path) {
        Map<String, LinkedList<Endpoint>> moduleEndpoints = this.getEndpointMap(moduleName);
        Iterable endpoints = moduleEndpoints.get(path);
        if (endpoints != null) {
            return endpoints;
        }
        return Collections.emptyList();
    }

    public Endpoint getDefaultEndpoint(String moduleName, String path) {
        Iterable<Endpoint> endpoints = this.getEndpoints(moduleName, path);
        if (endpoints != null && endpoints.iterator().hasNext()) {
            return endpoints.iterator().next();
        }
        return null;
    }

    protected Map<String, LinkedList<Endpoint>> getEndpointMap(String moduleName) {
        TreeMap<String, LinkedList<Endpoint>> endpointMap = this.getModuleEndpoints(moduleName);
        if (endpointMap != null) {
            return endpointMap;
        }
        if (this.inspectEndpoints(moduleName)) {
            return this.getModuleEndpoints(moduleName);
        }
        return Collections.emptyMap();
    }

    protected boolean inspectModuleNames() {
        String endpointUrl = this.getBaseUrl(this.getServerUrl()) + "/plugin-manager/ids";
        Response response = this.callHttp(endpointUrl);
        if (response != null && response.getStatusCode() == 200) {
            String[] moduleNames;
            for (String moduleName : moduleNames = this.getModuleNames(response.getResult())) {
                String id = moduleName.substring(1, moduleName.length() - 1);
                this.getEndpointsTree().put(id, null);
            }
            this.getEndpointsTree().put(DEFAULT_PLATFORM_NAME, null);
            return true;
        }
        return false;
    }

    protected int getConnectionStatus() {
        String endpointUrl = this.getBaseUrl(this.getServerUrl()) + "/plugin-manager/ids";
        Response response = this.callHttp(endpointUrl);
        return response == null ? -1 : response.getStatusCode();
    }

    private String[] getModuleNames(String result) {
        return result.substring(12, result.length() - 2).split(",");
    }

    protected boolean inspectEndpoints(String moduleName) {
        Document doc;
        Response response;
        URI uri = null;
        try {
            uri = new URI(this.getApplicationWadlEndpoint(moduleName));
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (uri != null && (response = this.callHttp(uri.toASCIIString())) != null && response.getStatusCode() == 200 && (doc = this.getDocument(response.getResult())) != null) {
            TreeMap endpointMap = new TreeMap();
            for (Endpoint endpoint : this.getParser().getEndpoints(doc)) {
                String path = endpoint.getPath();
                if (!endpointMap.containsKey(path)) {
                    endpointMap.put(path, new LinkedList());
                }
                ((LinkedList)endpointMap.get(path)).add(endpoint);
            }
            this.getEndpointsTree().put(moduleName, endpointMap);
            return true;
        }
        return false;
    }

    protected Document getDocument(String result) {
        SAXReader reader = new SAXReader();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(result.getBytes());
        try {
            return reader.read((InputStream)inputStream);
        }
        catch (DocumentException e) {
            return null;
        }
    }

    protected String getApplicationWadlEndpoint(String moduleName) {
        if (moduleName.equals(DEFAULT_PLATFORM_NAME)) {
            return this.getBaseUrl(this.getServerUrl()) + "/application.wadl";
        }
        return this.getBaseUrl(this.getServerUrl(), moduleName) + "/application.wadl";
    }

    protected Response callHttp(String endpointUrl) {
        return this.callHttp(endpointUrl, null, null);
    }

    protected Response callHttp(String endpointUrl, Map<String, String> queryParameters, String httpMethod) {
        Response response = null;
        try {
            response = HttpConnectionHelper.getInstance().callHttp(endpointUrl, queryParameters, httpMethod, this.getUserName(), this.getPassword());
        }
        catch (IOException e) {
        }
        catch (KettleStepException e) {
            // empty catch block
        }
        return response;
    }

    private String getBaseUrl(String serverUrl) {
        if (serverUrl.endsWith("/")) {
            return serverUrl + "api";
        }
        return serverUrl + "/api";
    }

    private String getBaseUrl(String serverUrl, String pluginId) {
        if (serverUrl.endsWith("/")) {
            return serverUrl + "plugin/" + pluginId + "/api";
        }
        return serverUrl + "/plugin/" + pluginId + "/api";
    }

    private static class InspectorHolder {
        public static final Inspector INSTANCE = new Inspector();

        private InspectorHolder() {
        }
    }
}

