/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.baserver.utils.web.InternalHttpServletRequest;
import org.pentaho.di.baserver.utils.web.InternalHttpServletResponse;
import org.pentaho.di.baserver.utils.web.Response;
import org.pentaho.di.cluster.SlaveConnectionManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.servlet.JAXRSPluginServlet;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.web.context.request.RequestContextListener;

public class HttpConnectionHelper {
    public static final String UTF_8 = "UTF-8";
    private static final Log logger = LogFactory.getLog(HttpConnectionHelper.class);
    private static HttpConnectionHelper _instance = new HttpConnectionHelper();

    public static HttpConnectionHelper getInstance() {
        return _instance;
    }

    public Response invokeEndpoint(String serverUrl, String userName, String password, String moduleName, String endpointPath, String httpMethod, Map<String, String> queryParameters) {
        Response response = new Response();
        String requestUrl = serverUrl.endsWith("/") ? serverUrl : serverUrl + "/";
        requestUrl = moduleName.equals("platform") ? requestUrl + "api" : requestUrl + "plugin/" + moduleName + "/api";
        requestUrl = endpointPath.startsWith("/") ? requestUrl + endpointPath : requestUrl + "/" + endpointPath;
        logger.info((Object)("requestUrl = " + requestUrl));
        try {
            response = this.callHttp(requestUrl, queryParameters, httpMethod, userName, password);
        }
        catch (IOException ex) {
            logger.error((Object)"Failed ", (Throwable)ex);
        }
        catch (KettleStepException ex) {
            logger.error((Object)"Failed ", (Throwable)ex);
        }
        return response;
    }

    public Response invokeEndpoint(String moduleName, String endpointPath, String httpMethod, Map<String, String> queryParameters) {
        if (moduleName.equals("platform")) {
            return this.invokePlatformEndpoint(endpointPath, httpMethod, queryParameters);
        }
        return this.invokePluginEndpoint(moduleName, endpointPath, httpMethod, queryParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response invokePlatformEndpoint(String endpointPath, String httpMethod, Map<String, String> queryParameters) {
        Response response = new Response();
        ServletContext servletContext = null;
        RequestDispatcher requestDispatcher = null;
        try {
            Object context = this.getContext();
            if (context instanceof ServletContext) {
                servletContext = (ServletContext)context;
                requestDispatcher = servletContext.getRequestDispatcher("/api" + endpointPath);
            }
        }
        catch (NoClassDefFoundError ex) {
            logger.error((Object)"Failed to get application servlet context", (Throwable)ex);
            return response;
        }
        if (requestDispatcher != null) {
            URL fullyQualifiedServerURL;
            try {
                fullyQualifiedServerURL = this.getUrl();
            }
            catch (MalformedURLException e) {
                logger.error((Object)"FullyQualifiedServerURL is incorrect");
                return response;
            }
            InternalHttpServletRequest servletRequest = new InternalHttpServletRequest(httpMethod, fullyQualifiedServerURL, "/api", endpointPath);
            servletRequest.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", 2);
            try {
                this.insertParameters(httpMethod, queryParameters, servletRequest);
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"Can't encode parameters");
                return response;
            }
            ServletRequestEvent servletRequestEvent = new ServletRequestEvent(servletContext, (ServletRequest)servletRequest);
            RequestContextListener requestContextListener = new RequestContextListener();
            requestContextListener.requestInitialized(servletRequestEvent);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            InternalHttpServletResponse servletResponse = new InternalHttpServletResponse(outputStream);
            try {
                long startTime = System.currentTimeMillis();
                requestDispatcher.forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                long responseTime = System.currentTimeMillis() - startTime;
                response.setStatusCode(servletResponse.getStatus());
                response.setResult(servletResponse.getContentAsString());
                response.setResponseTime(responseTime);
            }
            catch (ServletException ex) {
                logger.error((Object)"Failed ", (Throwable)ex);
                Response response2 = response;
                return response2;
            }
            catch (IOException ex) {
                logger.error((Object)"Failed ", (Throwable)ex);
                Response response3 = response;
                return response3;
            }
            finally {
                requestContextListener.requestDestroyed(servletRequestEvent);
            }
        }
        return response;
    }

    protected void insertParameters(String httpMethod, Map<String, String> queryParameters, InternalHttpServletRequest servletRequest) throws UnsupportedEncodingException {
        if (!httpMethod.equals("GET")) {
            StringBuilder s = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                if (!first) {
                    s.append("&");
                }
                s.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), UTF_8));
                first = false;
            }
            servletRequest.setContentType("application/x-www-form-urlencoded");
            servletRequest.setContent(s.toString().getBytes());
        } else {
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                String value = URLEncoder.encode(entry.getValue(), UTF_8);
                servletRequest.setParameter(entry.getKey(), value);
            }
        }
    }

    protected URL getUrl() throws MalformedURLException {
        return new URL(this.getFullyQualifiedServerURL());
    }

    protected String getFullyQualifiedServerURL() {
        return PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
    }

    protected Object getContext() {
        return PentahoSystem.getApplicationContext().getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response invokePluginEndpoint(String pluginName, String endpointPath, String httpMethod, Map<String, String> queryParameters) {
        URL fullyQualifiedServerURL;
        Response response = new Response();
        response.setStatusCode(404);
        response.setResponseTime(0L);
        IPluginManager pluginManager = this.getPluginManager();
        if (pluginManager == null) {
            logger.error((Object)"Failed to get plugin manager");
            return response;
        }
        ClassLoader classLoader = this.getPluginClassLoader(pluginName, pluginManager);
        if (classLoader == null) {
            logger.error((Object)("No such plugin: " + pluginName));
            return response;
        }
        ListableBeanFactory beanFactory = this.getListableBeanFactory(pluginName, pluginManager);
        if (beanFactory == null || !beanFactory.containsBean("api")) {
            logger.error((Object)("Bean not found for plugin: " + pluginName));
            return response;
        }
        JAXRSPluginServlet pluginServlet = this.getJAXRSPluginServlet(beanFactory);
        try {
            fullyQualifiedServerURL = this.getUrl();
        }
        catch (MalformedURLException e) {
            logger.error((Object)"FullyQualifiedServerURL is incorrect");
            return response;
        }
        InternalHttpServletRequest servletRequest = new InternalHttpServletRequest(httpMethod, fullyQualifiedServerURL, "/plugin", "/" + pluginName + "/api" + endpointPath);
        try {
            this.insertParameters(httpMethod, queryParameters, servletRequest);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Can't encode parameters");
            return response;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        InternalHttpServletResponse servletResponse = new InternalHttpServletResponse(outputStream);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long startTime = System.currentTimeMillis();
            Thread.currentThread().setContextClassLoader(classLoader);
            pluginServlet.service((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
            long responseTime = System.currentTimeMillis() - startTime;
            response.setStatusCode(servletResponse.getStatus());
            response.setResult(servletResponse.getContentAsString());
            response.setResponseTime(responseTime);
        }
        catch (ServletException ex) {
            logger.error((Object)"Failed ", (Throwable)ex);
            Response response2 = response;
            return response2;
        }
        catch (IOException ex) {
            logger.error((Object)"Failed ", (Throwable)ex);
            Response response3 = response;
            return response3;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        return response;
    }

    protected JAXRSPluginServlet getJAXRSPluginServlet(ListableBeanFactory beanFactory) {
        return (JAXRSPluginServlet)beanFactory.getBean("api", JAXRSPluginServlet.class);
    }

    protected ListableBeanFactory getListableBeanFactory(String pluginName, IPluginManager pluginManager) {
        return pluginManager.getBeanFactory(pluginName);
    }

    protected ClassLoader getPluginClassLoader(String pluginName, IPluginManager pluginManager) {
        return pluginManager.getClassLoader(pluginName);
    }

    protected IPluginManager getPluginManager() {
        return (IPluginManager)PentahoSystem.get(IPluginManager.class);
    }

    public Response callHttp(String url, Map<String, String> queryParameters, String httpMethod, String user, String password) throws IOException, KettleStepException {
        int status;
        long startTime = System.currentTimeMillis();
        HttpClient httpclient = this.getHttpClient();
        HttpMethod method = this.getHttpMethod(url, queryParameters, httpMethod);
        httpclient.getParams().setAuthenticationPreemptive(true);
        Credentials credentials = this.getCredentials(user, password);
        httpclient.getState().setCredentials(AuthScope.ANY, credentials);
        HostConfiguration hostConfiguration = new HostConfiguration();
        try {
            status = httpclient.executeMethod(hostConfiguration, method);
        }
        catch (IllegalArgumentException ex) {
            status = -1;
        }
        Response response = new Response();
        if (status != -1) {
            String contentType;
            String encoding = "";
            Header contentTypeHeader = method.getResponseHeader("Content-Type");
            if (contentTypeHeader != null && (contentType = contentTypeHeader.getValue()) != null && contentType.contains("charset")) {
                encoding = contentType.replaceFirst("^.*;\\s*charset\\s*=\\s*", "").replace("\"", "").trim();
            }
            String body = this.getContent(method, encoding);
            long responseTime = System.currentTimeMillis() - startTime;
            response.setStatusCode(status);
            response.setResult(body);
            response.setResponseTime(responseTime);
        }
        return response;
    }

    protected String getContent(HttpMethod method, String encoding) throws IOException {
        int c;
        InputStreamReader inputStreamReader = !Const.isEmpty((String)encoding) ? new InputStreamReader(method.getResponseBodyAsStream(), encoding) : new InputStreamReader(method.getResponseBodyAsStream());
        StringBuilder bodyBuffer = new StringBuilder();
        while ((c = inputStreamReader.read()) != -1) {
            bodyBuffer.append((char)c);
        }
        inputStreamReader.close();
        String body = bodyBuffer.toString();
        return body;
    }

    protected Credentials getCredentials(String user, String password) {
        return new UsernamePasswordCredentials(user, password);
    }

    protected HttpMethod getHttpMethod(String url, Map<String, String> queryParameters, String httpMethod) {
        org.pentaho.di.baserver.utils.inspector.HttpMethod method;
        if (httpMethod == null) {
            httpMethod = "";
        }
        try {
            method = org.pentaho.di.baserver.utils.inspector.HttpMethod.valueOf(httpMethod);
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("Method '" + httpMethod + "' is not supported - using 'GET'"));
            method = org.pentaho.di.baserver.utils.inspector.HttpMethod.GET;
        }
        switch (method) {
            case GET: {
                return new GetMethod(url + this.constructQueryString(queryParameters));
            }
            case POST: {
                PostMethod postMethod = new PostMethod(url);
                this.setRequestEntity((EntityEnclosingMethod)postMethod, queryParameters);
                return postMethod;
            }
            case PUT: {
                PutMethod putMethod = new PutMethod(url);
                this.setRequestEntity((EntityEnclosingMethod)putMethod, queryParameters);
                return putMethod;
            }
            case DELETE: {
                return new DeleteMethod(url + this.constructQueryString(queryParameters));
            }
            case HEAD: {
                return new HeadMethod(url + this.constructQueryString(queryParameters));
            }
            case OPTIONS: {
                return new OptionsMethod(url + this.constructQueryString(queryParameters));
            }
        }
        return new GetMethod(url + this.constructQueryString(queryParameters));
    }

    private void setRequestEntity(EntityEnclosingMethod method, Map<String, String> queryParameters) {
        try {
            String queryString = this.constructQueryString(queryParameters);
            if (!queryString.isEmpty()) {
                queryString = queryString.substring(1);
            }
            method.setRequestEntity((RequestEntity)new StringRequestEntity(queryString, "application/x-www-form-urlencoded", UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Failed", (Throwable)e);
        }
    }

    private String constructQueryString(Map<String, String> queryParameters) {
        StringBuilder queryString = new StringBuilder();
        if (queryParameters != null && !queryParameters.isEmpty()) {
            try {
                boolean first = true;
                for (String parameterName : queryParameters.keySet()) {
                    if (first) {
                        queryString.append("?");
                        first = false;
                    } else {
                        queryString.append("&");
                    }
                    queryString.append(parameterName).append("=").append(URLEncoder.encode(queryParameters.get(parameterName), UTF_8));
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"Failed ", (Throwable)e);
            }
        }
        return queryString.toString();
    }

    protected HttpClient getHttpClient() {
        return SlaveConnectionManager.getInstance().createHttpClient();
    }
}

