/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils.web;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.pentaho.di.baserver.utils.web.ServletInputStreamWrapper;

public class InternalHttpServletRequest
implements HttpServletRequest {
    public static final String DEFAULT_PROTOCOL = "http";
    public static final String DEFAULT_SERVER_ADDR = "127.0.0.1";
    public static final String DEFAULT_SERVER_NAME = "localhost";
    public static final int DEFAULT_SERVER_PORT = 8080;
    public static final String DEFAULT_REMOTE_ADDR = "127.0.0.1";
    public static final String DEFAULT_REMOTE_HOST = "localhost";
    private String protocol = "http";
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 8080;
    private String localName = "localhost";
    private String localAddr = "127.0.0.1";
    private int localPort = 8080;
    private String remoteAddr = "127.0.0.1";
    private String remoteHost = "localhost";
    private int remotePort = 8080;
    private String servletPath;
    private HashMap<String, String[]> parameters = new HashMap();
    private HashMap<String, Object> attributes = new HashMap();
    private String method;
    private String pathInfo;
    private String requestURI;
    private String contextPath = "";
    private String queryString;
    private byte[] content;
    private String contentType;

    public String getProtocol() {
        return this.protocol;
    }

    protected void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getQueryString() {
        String queryString = "";
        for (Map.Entry<String, String[]> entry : this.parameters.entrySet()) {
            queryString = queryString + "&";
            queryString = queryString + entry.getKey() + "=" + entry.getValue()[0];
        }
        return queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getPathTranslated() {
        return this.pathInfo != null ? this.getRealPath(this.pathInfo) : null;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return null;
    }

    public long getDateHeader(String s) {
        return 0L;
    }

    public String getHeader(String s) {
        return null;
    }

    public Enumeration getHeaders(String s) {
        return Collections.enumeration(Collections.emptyList());
    }

    public Enumeration getHeaderNames() {
        return Collections.enumeration(Collections.emptyList());
    }

    public int getIntHeader(String s) {
        return 0;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String s) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public HttpSession getSession(boolean b) {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public Object getAttribute(String s) {
        return this.attributes.get(s);
    }

    public void setAttribute(String s, Object o) {
        this.attributes.put(s, o);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return null;
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
    }

    public void removeAttribute(String s) {
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public Enumeration getLocales() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public InternalHttpServletRequest(String method, URL fullyQualifiedServerURL, String servletPath, String pathInfo) {
        this.method = method;
        this.scheme = fullyQualifiedServerURL.getProtocol();
        this.serverName = fullyQualifiedServerURL.getHost();
        this.serverPort = fullyQualifiedServerURL.getPort();
        this.contextPath = fullyQualifiedServerURL.getPath();
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.requestURI = this.contextPath + servletPath + pathInfo;
        this.parameters = new HashMap();
    }

    public InternalHttpServletRequest(String method, String requestURI) {
        this.method = method;
        this.requestURI = requestURI;
        this.parameters = new HashMap();
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer(this.scheme);
        url.append("://").append(this.serverName).append(':').append(this.serverPort);
        url.append(this.getRequestURI());
        url.append('?');
        url.append(this.getQueryString());
        return url;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public int getContentLength() {
        return this.content != null ? this.content.length : -1;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.content != null) {
            return new ServletInputStreamWrapper(new ByteArrayInputStream(this.content));
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String getParameter(String name) {
        String[] arr = this.parameters.get(name);
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public void setParameter(String name, String value) {
        this.setParameter(name, new String[]{value});
    }

    public void setParameter(String name, String[] values) {
        this.parameters.put(name, values);
    }

    public BufferedReader getReader() throws IOException {
        if (this.content != null) {
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(this.content);
            InputStreamReader sourceReader = new InputStreamReader(sourceStream);
            return new BufferedReader(sourceReader);
        }
        return null;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }
}

