/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.baserver.utils.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.pentaho.di.baserver.utils.widgets.WidgetBuilder;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.ComboVar;

public final class ComboVarBuilder
extends WidgetBuilder<ComboVar> {
    private VariableSpace variableSpace;
    private List<String> items = new ArrayList<String>();

    public ComboVarBuilder addItem(String item) {
        if (item != null) {
            this.items.add(item);
            Collections.sort(this.items);
        }
        return this;
    }

    public ComboVarBuilder addAllItems(Collection<String> items) {
        this.items.addAll(items);
        Collections.sort(this.items);
        return this;
    }

    public ComboVarBuilder(Composite parent, PropsUI props, VariableSpace variableSpace) {
        super(parent, props);
        this.variableSpace = variableSpace;
    }

    @Override
    protected ComboVar createWidget(Composite parent) {
        ComboVar comboVar = new ComboVar(this.variableSpace, this.parent, 2048);
        String[] itemsArray = this.items.toArray(new String[this.items.size()]);
        comboVar.setItems(itemsArray);
        return comboVar;
    }
}

