/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.util;

import java.io.Externalizable;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Iterator;

public class SQLExceptionHelper {
    public static SQLException wrap(Throwable t) {
        if (SQLExceptionHelper.isExceptionGeneric(t)) {
            if (t instanceof SQLException) {
                return (SQLException)t;
            }
            return new SQLException(t.getMessage(), t);
        }
        return SQLExceptionHelper.wrapThrowable(t);
    }

    public static SQLException wrap(SQLException ex) {
        if (SQLExceptionHelper.isSQLExceptionGeneric(ex)) {
            return ex;
        }
        return SQLExceptionHelper.wrapSQLException(ex);
    }

    private static boolean isExceptionGeneric(Throwable ex) {
        boolean exceptionIsGeneric = true;
        for (Throwable loop = ex; loop != null && exceptionIsGeneric; loop = loop.getCause()) {
            exceptionIsGeneric = Serializable.class.isAssignableFrom(loop.getClass()) || Externalizable.class.isAssignableFrom(loop.getClass());
        }
        return exceptionIsGeneric;
    }

    private static boolean isSQLExceptionGeneric(SQLException ex) {
        boolean exceptionIsGeneric = true;
        Iterator<Throwable> it = ex.iterator();
        while (it.hasNext() && exceptionIsGeneric) {
            Throwable t = it.next();
            exceptionIsGeneric = Serializable.class.isAssignableFrom(t.getClass()) || Externalizable.class.isAssignableFrom(t.getClass());
        }
        return exceptionIsGeneric;
    }

    private static SQLException wrapSQLException(SQLException ex) {
        SQLException ex2 = new SQLException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), SQLExceptionHelper.wrap(ex.getCause()));
        if (ex.getNextException() != null) {
            ex2.setNextException(SQLExceptionHelper.wrap(ex.getNextException()));
        }
        return ex2;
    }

    private static SQLException wrapThrowable(Throwable t) {
        SQLException wrapped = null;
        wrapped = t instanceof SQLException ? SQLExceptionHelper.wrapSQLException((SQLException)t) : new SQLException(t.getMessage(), SQLExceptionHelper.wrap(t.getCause()));
        wrapped.setStackTrace(wrapped.getStackTrace());
        return wrapped;
    }
}

