/*
 * Decompiled with CFR 0.152.
 */
package net.sf.farrago.release;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eigenbase.util.property.IntegerProperty;
import org.eigenbase.util.property.StringProperty;

public class FarragoReleaseProperties
extends Properties {
    private static FarragoReleaseProperties instance;
    public final StringProperty packageName = new StringProperty(this, "package.name", "farrago");
    public final StringProperty productName = new StringProperty(this, "product.name", "Farrago");
    public final IntegerProperty productVersionMajor = new IntegerProperty((Properties)this, "product.version.major", 0);
    public final IntegerProperty productVersionMinor = new IntegerProperty((Properties)this, "product.version.minor", 1);
    public final StringProperty productVersionPoint = new StringProperty(this, "product.version.point", "0");
    public final IntegerProperty productBuildNumber = new IntegerProperty((Properties)this, "product.build.number", 0);
    public final StringProperty jdbcDriverName = new StringProperty(this, "jdbc.driver.name", "FarragoJdbcDriver");
    public final IntegerProperty jdbcDriverVersionMajor = new IntegerProperty((Properties)this, "jdbc.driver.version.major", 0);
    public final IntegerProperty jdbcDriverVersionMinor = new IntegerProperty((Properties)this, "jdbc.driver.version.minor", 1);
    public final StringProperty jdbcUrlBase = new StringProperty(this, "jdbc.url.base", "jdbc:farrago:");
    public final IntegerProperty jdbcUrlPortDefault = new IntegerProperty((Properties)this, "jdbc.url.port.default", 5433);
    public final IntegerProperty jdbcUrlHttpPortDefault = new IntegerProperty((Properties)this, "jdbc.url.http.port.default", 8033);

    public String getVersionString() {
        StringBuilder result = new StringBuilder();
        result.append(this.productVersionMajor.get());
        result.append(".");
        result.append(this.productVersionMinor.get());
        result.append(".");
        result.append(this.productVersionPoint.get());
        if (this.productBuildNumber.get() > 0) {
            result.append(".");
            result.append(this.productBuildNumber.get());
        }
        return result.toString();
    }

    public static synchronized FarragoReleaseProperties instance() {
        if (instance == null) {
            String resourceName = "FarragoRelease.properties";
            String failureString = "Failed to load " + resourceName;
            instance = new FarragoReleaseProperties();
            URL url = FarragoReleaseProperties.class.getClassLoader().getResource(resourceName);
            if (url == null) {
                throw new RuntimeException(failureString);
            }
            InputStream urlStream = null;
            try {
                urlStream = url.openStream();
                instance.load(urlStream);
            }
            catch (IOException ex) {
                RuntimeException rx = new RuntimeException(failureString);
                rx.initCause(ex);
                throw rx;
            }
            finally {
                if (urlStream != null) {
                    try {
                        urlStream.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        return instance;
    }
}

