/*
 * Decompiled with CFR 0.152.
 */
package org.luciddb.test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import net.sf.farrago.catalog.FarragoRepos;
import net.sf.farrago.cwm.relational.CwmSchema;
import net.sf.farrago.fem.med.FemDataWrapper;
import net.sf.farrago.jdbc.engine.FarragoJdbcEngineConnection;
import net.sf.farrago.test.FarragoTestCase;
import org.luciddb.test.LucidDbTestCleanup;

public class LucidDbTestCleanup
extends FarragoTestCase.Cleanup {
    private static Thread shutdownHook;
    private final FarragoRepos ldbRepos;
    private final Statement ldbStmt;

    public LucidDbTestCleanup(Connection ldbConn) throws Exception {
        super("LucidDbCleanup");
        this.ldbStmt = ldbConn.createStatement();
        this.ldbRepos = ((FarragoJdbcEngineConnection)ldbConn).getSession().getRepos();
    }

    protected FarragoRepos getRepos() {
        return this.ldbRepos;
    }

    protected Statement getStmt() {
        return this.ldbStmt;
    }

    protected boolean isBlessedSchema(CwmSchema schema) {
        String name = schema.getName();
        return name.equals("SQLJ") || name.equals("APPLIB") || name.equals("INFORMATION_SCHEMA") || name.equals("SYSTEM") || name.startsWith("SYS_");
    }

    protected boolean isBlessedWrapper(FemDataWrapper wrapper) {
        String name = wrapper.getName();
        return name.equals("ORACLE") || name.equals("SQL SERVER") || name.equals("FLAT FILE") || name.equals("LUCIDDB LOCAL") || name.equals("LUCIDDB REMOTE") || name.equals("SALESFORCE") || name.contains("NETSUITE") || super.isBlessedWrapper(wrapper);
    }

    public static void saveTestParameters() throws Exception {
        LucidDbTestCleanup cleanup = LucidDbTestCleanup.newCleanup();
        cleanup.saveCleanupParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanTest() throws Exception {
        if (shutdownHook == null) {
            shutdownHook = new ShutdownThread(null);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        LucidDbTestCleanup cleanup = LucidDbTestCleanup.newCleanup();
        cleanup.getRepos().getEnkiMdrRepos().beginSession();
        try {
            cleanup.execute();
        }
        finally {
            cleanup.getRepos().getEnkiMdrRepos().endSession();
        }
    }

    public void execute() throws Exception {
        super.execute();
        this.ldbStmt.executeUpdate("alter system deallocate old");
    }

    private static LucidDbTestCleanup newCleanup() throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        return new LucidDbTestCleanup(conn);
    }
}

