/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.manager.InformationSchemaManager;
import com.cloudera.sqoop.mapreduce.JdbcExportJob;
import com.cloudera.sqoop.mapreduce.JdbcUpdateExportJob;
import com.cloudera.sqoop.util.ExportException;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.cli.RelatedOptions;
import org.apache.sqoop.mapreduce.SQLServerResilientExportOutputFormat;
import org.apache.sqoop.mapreduce.SQLServerResilientUpdateOutputFormat;
import org.apache.sqoop.mapreduce.db.SQLServerConnectionFailureHandler;
import org.apache.sqoop.mapreduce.db.SQLServerDBInputFormat;
import org.apache.sqoop.mapreduce.sqlserver.SqlServerExportBatchOutputFormat;
import org.apache.sqoop.mapreduce.sqlserver.SqlServerInputFormat;

public class SQLServerManager
extends InformationSchemaManager {
    public static final String SCHEMA = "schema";
    public static final String TABLE_HINTS = "table-hints";
    public static final String TABLE_HINTS_PROP = "org.apache.sqoop.manager.sqlserver.table.hints";
    public static final Log LOG = LogFactory.getLog((String)SQLServerManager.class.getName());
    public static final String NON_RESILIENT_OPTION = "non-resilient";
    private static final String DRIVER_CLASS = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final int DATETIMEOFFSET = -155;
    private String schema;
    private String tableHints;

    public SQLServerManager(SqoopOptions opts) {
        super(DRIVER_CLASS, opts);
        try {
            this.parseExtraArgs(opts.getExtraArgs());
        }
        catch (ParseException e) {
            throw new RuntimeException("Can't parse extra arguments", e);
        }
    }

    @Override
    public String toJavaType(int sqlType) {
        String javaType = sqlType == -155 ? "String" : super.toJavaType(sqlType);
        return javaType;
    }

    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        context.setConnManager(this);
        Configuration configuration = context.getOptions().getConf();
        if (this.tableHints != null) {
            configuration.set(TABLE_HINTS_PROP, this.tableHints);
        }
        if (!this.isNonResilientOperation()) {
            SqoopOptions opts = context.getOptions();
            String splitCol = this.getSplitColumn(opts, context.getTableName());
            if (splitCol != null) {
                this.configureConnectionRecoveryForImport(context);
            } else {
                context.setInputFormat(SqlServerInputFormat.class);
            }
        } else {
            context.setInputFormat(SqlServerInputFormat.class);
        }
        super.importTable(context);
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        JdbcExportJob exportJob;
        context.setConnManager(this);
        Configuration configuration = context.getOptions().getConf();
        if (this.tableHints != null) {
            configuration.set(TABLE_HINTS_PROP, this.tableHints);
        }
        if (this.isNonResilientOperation()) {
            exportJob = new JdbcExportJob(context, null, null, SqlServerExportBatchOutputFormat.class);
        } else {
            exportJob = new JdbcExportJob(context, null, null, SQLServerResilientExportOutputFormat.class);
            this.configureConnectionRecoveryForExport(context);
        }
        exportJob.runExport();
    }

    @Override
    public void updateTable(ExportJobContext context) throws IOException, ExportException {
        if (this.isNonResilientOperation()) {
            super.updateTable(context);
        } else {
            context.setConnManager(this);
            JdbcUpdateExportJob exportJob = new JdbcUpdateExportJob(context, null, null, SQLServerResilientUpdateOutputFormat.class);
            this.configureConnectionRecoveryForUpdate(context);
            exportJob.runExport();
        }
    }

    @Override
    public String getCurTimestampQuery() {
        return "SELECT CURRENT_TIMESTAMP";
    }

    @Override
    protected String getListDatabasesQuery() {
        return "SELECT NAME FROM SYS.DATABASES";
    }

    @Override
    protected String getSchemaQuery() {
        if (this.schema == null) {
            return "SELECT SCHEMA_NAME()";
        }
        return "'" + this.schema + "'";
    }

    @Override
    protected String getListColumnsQuery(String tableName) {
        return "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = (" + this.getSchemaQuery() + ") " + "  AND TABLE_NAME = N'" + tableName + "' " + "  ORDER BY ORDINAL_POSITION";
    }

    @Override
    protected String getPrimaryKeyQuery(String tableName) {
        return "SELECT kcu.COLUMN_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc,   INFORMATION_SCHEMA.KEY_COLUMN_USAGE kcu WHERE tc.TABLE_SCHEMA = kcu.TABLE_SCHEMA   AND tc.TABLE_NAME = kcu.TABLE_NAME   AND tc.CONSTRAINT_SCHEMA = kcu.CONSTRAINT_SCHEMA   AND tc.CONSTRAINT_NAME = kcu.CONSTRAINT_NAME   AND tc.TABLE_SCHEMA = (" + this.getSchemaQuery() + ") " + "  AND tc.TABLE_NAME = N'" + tableName + "' " + "  AND tc.CONSTRAINT_TYPE = 'PRIMARY KEY'";
    }

    @Override
    public String escapeColName(String colName) {
        return this.escapeObjectName(colName);
    }

    @Override
    public String escapeTableName(String tableName) {
        if (this.schema != null && !this.schema.isEmpty()) {
            return this.escapeObjectName(this.schema) + "." + this.escapeObjectName(tableName);
        }
        return this.escapeObjectName(tableName);
    }

    @Override
    public boolean escapeTableNameOnExport() {
        return true;
    }

    public String escapeObjectName(String objectName) {
        if (null == objectName) {
            return null;
        }
        return "[" + objectName + "]";
    }

    void parseExtraArgs(String[] args) throws ParseException {
        if (args == null || args.length == 0) {
            return;
        }
        GnuParser parser = new GnuParser();
        CommandLine cmdLine = parser.parse((Options)this.getExtraOptions(), args, true);
        if (cmdLine.hasOption(SCHEMA)) {
            String schemaName = cmdLine.getOptionValue(SCHEMA);
            LOG.info((Object)("We will use schema " + schemaName));
            this.schema = schemaName;
        }
        if (cmdLine.hasOption(TABLE_HINTS)) {
            String hints = cmdLine.getOptionValue(TABLE_HINTS);
            LOG.info((Object)("Sqoop will use following table hints for data transfer: " + hints));
            this.tableHints = hints;
        }
    }

    private RelatedOptions getExtraOptions() {
        RelatedOptions extraOptions = new RelatedOptions("SQL Server extra options:");
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Optional schema name");
        OptionBuilder.withLongOpt((String)SCHEMA);
        extraOptions.addOption(OptionBuilder.create());
        OptionBuilder.withArgName((String)"string");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Optional table hints to use");
        OptionBuilder.withLongOpt((String)TABLE_HINTS);
        extraOptions.addOption(OptionBuilder.create());
        return extraOptions;
    }

    @Override
    public void importQuery(ImportJobContext context) throws IOException, ImportException {
        SqoopOptions opts;
        String splitCol;
        if (!this.isNonResilientOperation() && (splitCol = this.getSplitColumn(opts = context.getOptions(), context.getTableName())) != null) {
            this.configureConnectionRecoveryForImport(context);
        }
        super.importQuery(context);
    }

    protected void configureConnectionRecoveryForImport(ImportJobContext context) {
        Configuration conf = context.getOptions().getConf();
        context.setInputFormat(SQLServerDBInputFormat.class);
        if (conf.get("sqoop.import.failure.handler.class") == null) {
            conf.set("sqoop.import.failure.handler.class", SQLServerConnectionFailureHandler.class.getName());
        }
    }

    protected void configureConnectionRecoveryForExport(ExportJobContext context) {
        Configuration conf = context.getOptions().getConf();
        String clsFailureHandler = conf.get("sqoop.export.failure.handler.class");
        if (clsFailureHandler == null) {
            conf.set("sqoop.export.failure.handler.class", SQLServerConnectionFailureHandler.class.getName());
        }
    }

    protected void configureConnectionRecoveryForUpdate(ExportJobContext context) {
        Configuration conf = context.getOptions().getConf();
        String clsFailureHandler = conf.get("sqoop.export.failure.handler.class");
        if (clsFailureHandler == null) {
            conf.set("sqoop.export.failure.handler.class", SQLServerConnectionFailureHandler.class.getName());
        }
    }

    protected boolean isNonResilientOperation() {
        String[] extraArgs = this.options.getExtraArgs();
        if (extraArgs != null) {
            for (int iArg = 0; iArg < extraArgs.length; ++iArg) {
                String currentArg = extraArgs[iArg];
                if (!currentArg.startsWith("--") || !currentArg.substring(2).equalsIgnoreCase(NON_RESILIENT_OPTION)) continue;
                return true;
            }
        }
        return false;
    }
}

