/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.gpload;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.gpload.GPLoad;
import org.pentaho.di.trans.steps.gpload.GPLoadMeta;

public class GPLoadDataOutput {
    private static Class<?> PKG = GPLoadDataOutput.class;
    protected LogChannelInterface log;
    private GPLoad gpLoad = null;
    private GPLoadMeta meta;
    private PrintWriter output = null;
    private boolean first = true;
    private int[] fieldNumbers = null;
    private String enclosure = null;
    private String delimiter = null;
    private SimpleDateFormat sdfDate = null;
    private SimpleDateFormat sdfDateTime = null;

    public GPLoadDataOutput(GPLoad gpLoad, GPLoadMeta meta) {
        this.meta = meta;
        this.gpLoad = gpLoad;
    }

    public GPLoadDataOutput(GPLoad gpLoad, GPLoadMeta meta, LogLevel logLevel) {
        this(gpLoad, meta);
        this.log = new LogChannel((Object)this);
        this.log.setLogLevel(logLevel);
    }

    public void open(VariableSpace space, Process sqlldrProcess) throws KettleException {
        try {
            FileOutputStream os = null;
            String dataFile = this.meta.getDataFile();
            if (Const.isEmpty((String)dataFile)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPload.Exception.DataFileMissing", (String[])new String[0]));
            }
            if (Const.isEmpty((String)(dataFile = space.environmentSubstitute(dataFile)))) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPload.Exception.DataFileMissing", (String[])new String[0]));
            }
            this.log.logDetailed("Creating temporary load file " + dataFile);
            os = new FileOutputStream(dataFile, false);
            String encoding = this.meta.getEncoding();
            this.output = Const.isEmpty((String)encoding) ? new PrintWriter(new BufferedWriter(new OutputStreamWriter(os))) : new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)os, encoding)));
        }
        catch (IOException e) {
            throw new KettleException("GPLoadDataOutput.Exception" + e.getMessage(), (Throwable)e);
        }
    }

    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
        }
    }

    PrintWriter getOutput() {
        return this.output;
    }

    private String createEscapedString(String orig, String enclosure) {
        StringBuffer buf = new StringBuffer(orig);
        Const.repl((StringBuffer)buf, (String)enclosure, (String)(enclosure + enclosure));
        return buf.toString();
    }

    public void writeLine(RowMetaInterface mi, Object[] row) throws KettleException {
        if (this.first) {
            this.first = false;
            this.enclosure = this.meta.getEnclosure();
            this.enclosure = this.enclosure == null ? "" : this.gpLoad.environmentSubstitute(this.enclosure);
            this.delimiter = this.meta.getDelimiter();
            if (this.delimiter == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPload.Exception.DelimiterMissing", (String[])new String[0]));
            }
            this.delimiter = this.gpLoad.environmentSubstitute(this.delimiter);
            if (Const.isEmpty((String)this.delimiter)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPload.Exception.DelimiterMissing", (String[])new String[0]));
            }
            this.fieldNumbers = new int[this.meta.getFieldStream().length];
            for (int i = 0; i < this.fieldNumbers.length; ++i) {
                this.fieldNumbers[i] = mi.indexOfValue(this.meta.getFieldStream()[i]);
                if (this.fieldNumbers[i] >= 0) continue;
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoadDataOutput.Exception.FieldNotFound", (String[])new String[]{this.meta.getFieldStream()[i]}));
            }
            this.sdfDate = new SimpleDateFormat("yyyy-MM-dd");
            this.sdfDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        }
        ValueMetaInterface v = null;
        int number = 0;
        block10: for (int i = 0; i < this.fieldNumbers.length; ++i) {
            if (i != 0) {
                this.output.print(this.delimiter);
            }
            number = this.fieldNumbers[i];
            v = mi.getValueMeta(number);
            if (row[number] == null) {
                this.output.print(this.enclosure);
                this.output.print(this.enclosure);
                continue;
            }
            switch (v.getType()) {
                case 2: {
                    String s = mi.getString(row, number);
                    if (s.indexOf(this.enclosure) >= 0) {
                        s = this.createEscapedString(s, this.enclosure);
                    }
                    this.output.print(this.enclosure);
                    this.output.print(s);
                    this.output.print(this.enclosure);
                    continue block10;
                }
                case 5: {
                    Long l = mi.getInteger(row, number);
                    if (this.meta.getEncloseNumbers()) {
                        this.output.print(this.enclosure);
                        this.output.print(l);
                        this.output.print(this.enclosure);
                        continue block10;
                    }
                    this.output.print(l);
                    continue block10;
                }
                case 1: {
                    Double d = mi.getNumber(row, number);
                    if (this.meta.getEncloseNumbers()) {
                        this.output.print(this.enclosure);
                        this.output.print(d);
                        this.output.print(this.enclosure);
                        continue block10;
                    }
                    this.output.print(d);
                    continue block10;
                }
                case 6: {
                    BigDecimal bd = mi.getBigNumber(row, number);
                    if (this.meta.getEncloseNumbers()) {
                        this.output.print(this.enclosure);
                        this.output.print(bd);
                        this.output.print(this.enclosure);
                        continue block10;
                    }
                    this.output.print(bd);
                    continue block10;
                }
                case 3: {
                    Date dt = mi.getDate(row, number);
                    this.output.print(this.enclosure);
                    String mask = this.meta.getDateMask()[i];
                    if ("DATETIME".equals(mask)) {
                        this.output.print(this.sdfDateTime.format(dt));
                    } else {
                        this.output.print(this.sdfDate.format(dt));
                    }
                    this.output.print(this.enclosure);
                    continue block10;
                }
                case 4: {
                    Boolean b = mi.getBoolean(row, number);
                    this.output.print(this.enclosure);
                    if (b.booleanValue()) {
                        this.output.print("Y");
                    } else {
                        this.output.print("N");
                    }
                    this.output.print(this.enclosure);
                    continue block10;
                }
                case 8: {
                    byte[] byt = mi.getBinary(row, number);
                    this.output.print("<startlob>");
                    this.output.print(byt);
                    this.output.print("<endlob>");
                    continue block10;
                }
                default: {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"GPLoadDataOutput.Exception.TypeNotSupported", (Object[])new Object[]{v.getType()}));
                }
            }
        }
        this.output.print(Const.CR);
    }
}

