/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.gpload;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.gpload.GPLoadMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class GPLoadDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = GPLoadMeta.class;
    private CTabFolder wTabFolder;
    private CCombo wConnection;
    private TextVar wSchema;
    private TextVar wLocalhostPort;
    private TextVar wTable;
    private TextVar wErrorTable;
    private TextVar wGploadPath;
    private CCombo wLoadMethod;
    private CCombo wLoadAction;
    private TextVar wMaxErrors;
    private TableView wReturn;
    private TableView wLocalHosts;
    private TextVar wControlFile;
    private TextVar wDataFile;
    private TextVar wLogFile;
    private Combo wEncoding;
    private Button wEraseFiles;
    private GPLoadMeta input;
    private TextVar wDelimiter;
    private Text wUpdateCondition;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private ColumnInfo[] ciReturn;
    private List<ColumnInfo> localHostsColumns = new ArrayList<ColumnInfo>();
    private ColumnInfo[] ciLocalHosts;
    private static final String[] ALL_FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"GPLoadDialog.Filetype.All", (String[])new String[0])};
    private Map<String, Integer> inputFields;

    public GPLoadDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (GPLoadMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GPLoadDialog.this.input.setChanged();
            }
        };
        FocusAdapter lsFocusLost = new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                GPLoadDialog.this.setTableFieldCombo();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        Label wlSchema = new Label((Composite)this.shell, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        wlSchema.setLayoutData((Object)fdlSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.addFocusListener((FocusListener)lsFocusLost);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        fdSchema.right = new FormAttachment(100, 0);
        this.wSchema.setLayoutData((Object)fdSchema);
        Label wlTable = new Label((Composite)this.shell, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)this.wSchema, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbTable);
        wbTable.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.Browse.Button", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)this.wSchema, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsMod);
        this.wTable.addFocusListener((FocusListener)lsFocusLost);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.top = new FormAttachment((Control)this.wSchema, margin);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        Label wlLoadMethod = new Label((Composite)this.shell, 131072);
        wlLoadMethod.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.LoadMethod.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLoadMethod);
        FormData fdlLoadMethod = new FormData();
        fdlLoadMethod.left = new FormAttachment(0, 0);
        fdlLoadMethod.right = new FormAttachment(middle, -margin);
        fdlLoadMethod.top = new FormAttachment((Control)this.wTable, margin);
        wlLoadMethod.setLayoutData((Object)fdlLoadMethod);
        this.wLoadMethod = new CCombo((Composite)this.shell, 2060);
        this.wLoadMethod.add(BaseMessages.getString(PKG, (String)"GPLoadDialog.AutoEndLoadMethod.Label", (String[])new String[0]));
        this.wLoadMethod.add(BaseMessages.getString(PKG, (String)"GPLoadDialog.ManualLoadMethod.Label", (String[])new String[0]));
        this.wLoadMethod.select(0);
        this.wLoadMethod.addModifyListener(lsMod);
        this.props.setLook((Control)this.wLoadMethod);
        FormData fdLoadMethod = new FormData();
        fdLoadMethod.left = new FormAttachment(middle, 0);
        fdLoadMethod.top = new FormAttachment((Control)this.wTable, margin);
        fdLoadMethod.right = new FormAttachment(100, 0);
        this.wLoadMethod.setLayoutData((Object)fdLoadMethod);
        Label wlEraseFiles = new Label((Composite)this.shell, 131072);
        wlEraseFiles.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.EraseFiles.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEraseFiles);
        FormData fdlEraseFiles = new FormData();
        fdlEraseFiles.left = new FormAttachment(0, 0);
        fdlEraseFiles.top = new FormAttachment((Control)this.wLoadMethod, margin);
        fdlEraseFiles.right = new FormAttachment(middle, -margin);
        wlEraseFiles.setLayoutData((Object)fdlEraseFiles);
        this.wEraseFiles = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wEraseFiles);
        FormData fdEraseFiles = new FormData();
        fdEraseFiles.left = new FormAttachment(middle, 0);
        fdEraseFiles.top = new FormAttachment((Control)this.wLoadMethod, margin);
        fdEraseFiles.right = new FormAttachment(100, 0);
        this.wEraseFiles.setLayoutData((Object)fdEraseFiles);
        this.wEraseFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GPLoadDialog.this.input.setChanged();
            }
        });
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.addFieldTabItem(this.wTabFolder, margin, lsMod);
        this.addLocalHostsTabItem(this.wTabFolder, margin, lsMod, (FocusListener)lsFocusLost);
        this.addGPConfigTabItem(this.wTabFolder, margin, lsMod, (FocusListener)lsFocusLost);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wEraseFiles, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wTabFolder.setSelection(0);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wSQL = new Button((Composite)this.shell, 8);
        this.wSQL.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.SQL.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wSQL, this.wCancel}, margin, (Control)this.wTabFolder);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = GPLoadDialog.this.transMeta.findStep(GPLoadDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = GPLoadDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            GPLoadDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        GPLoadDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        GPLoadDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                GPLoadDialog.this.ok();
            }
        };
        this.lsSQL = new Listener(){

            public void handleEvent(Event e) {
                GPLoadDialog.this.create();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                GPLoadDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wSQL.addListener(13, this.lsSQL);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                GPLoadDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wSchema.addSelectionListener(this.lsDef);
        this.wTable.addSelectionListener(this.lsDef);
        this.wMaxErrors.addSelectionListener(this.lsDef);
        this.wControlFile.addSelectionListener(this.lsDef);
        this.wDataFile.addSelectionListener(this.lsDef);
        this.wLogFile.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                GPLoadDialog.this.cancel();
            }
        });
        wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GPLoadDialog.this.getTableName(GPLoadDialog.this.wSchema, GPLoadDialog.this.wTable);
            }
        });
        this.setSize();
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void generateMappings() {
        EnterMappingDialog d;
        RowMetaInterface targetFields;
        RowMetaInterface sourceFields;
        try {
            sourceFields = this.transMeta.getPrevStepFields(this.stepMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GPLoadDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GPLoadDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.input.setTableName(this.transMeta.environmentSubstitute(this.wTable.getText()));
        StepMetaInterface stepMetaInterface = this.stepMeta.getStepMetaInterface();
        try {
            targetFields = stepMetaInterface.getRequiredFields((VariableSpace)this.transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GPLoadDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GPLoadDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            ValueMetaInterface value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName() + "            (" + value.getOrigin() + ")";
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            String message = "";
            if (missingSourceFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"GPLoadDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"GPLoadDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = message + Const.CR;
            message = message + BaseMessages.getString(PKG, (String)"GPLoadDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            boolean goOn = MessageDialog.openConfirm((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"GPLoadDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message);
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = new Runnable(){

            @Override
            public void run() {
                block7: {
                    if (!(GPLoadDialog.this.wTable.isDisposed() || GPLoadDialog.this.wConnection.isDisposed() || GPLoadDialog.this.wSchema.isDisposed())) {
                        DatabaseMeta ci;
                        String tableName = GPLoadDialog.this.wTable.getText();
                        String connectionName = GPLoadDialog.this.wConnection.getText();
                        String schemaName = GPLoadDialog.this.wSchema.getText();
                        for (ColumnInfo colInfo : GPLoadDialog.this.tableFieldColumns) {
                            colInfo.setComboValues(new String[0]);
                        }
                        if (!Const.isEmpty((String)tableName) && (ci = GPLoadDialog.this.transMeta.findDatabase(connectionName)) != null) {
                            Database db = new Database(BaseStepDialog.loggingObject, ci);
                            try {
                                String[] fieldNames;
                                db.connect();
                                String schemaTable = ci.getQuotedSchemaTableCombination(GPLoadDialog.this.transMeta.environmentSubstitute(schemaName), GPLoadDialog.this.transMeta.environmentSubstitute(tableName));
                                RowMetaInterface r = db.getTableFields(schemaTable);
                                if (null == r || null == (fieldNames = r.getFieldNames())) break block7;
                                for (ColumnInfo colInfo : GPLoadDialog.this.tableFieldColumns) {
                                    colInfo.setComboValues(fieldNames);
                                }
                            }
                            catch (Exception e) {
                                for (ColumnInfo colInfo : GPLoadDialog.this.tableFieldColumns) {
                                    colInfo.setComboValues(new String[0]);
                                }
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    public void getData() {
        TableItem item;
        int i;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GPLoadDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getMaxErrors() != null) {
            this.wMaxErrors.setText(this.input.getMaxErrors());
        }
        if (this.input.getFieldTable() != null) {
            for (i = 0; i < this.input.getFieldTable().length; ++i) {
                String dateMask;
                item = this.wReturn.table.getItem(i);
                if (this.input.getFieldTable()[i] != null) {
                    item.setText(1, this.input.getFieldTable()[i]);
                }
                if (this.input.getFieldStream()[i] != null) {
                    item.setText(2, this.input.getFieldStream()[i]);
                }
                if ((dateMask = this.input.getDateMask()[i]) != null) {
                    if ("DATE".equals(dateMask)) {
                        item.setText(3, BaseMessages.getString(PKG, (String)"GPLoadDialog.DateMask.Label", (String[])new String[0]));
                    } else if ("DATETIME".equals(dateMask)) {
                        item.setText(3, BaseMessages.getString(PKG, (String)"GPLoadDialog.DateTimeMask.Label", (String[])new String[0]));
                    } else {
                        item.setText(3, "");
                    }
                } else {
                    item.setText(3, "");
                }
                item.setText(4, this.input.getMatchColumn()[i] ? "Y" : "N");
                item.setText(5, this.input.getUpdateColumn()[i] ? "Y" : "N");
            }
        }
        if (this.input.getLocalHosts() != null) {
            for (i = 0; i < this.input.getLocalHosts().length; ++i) {
                item = this.wLocalHosts.table.getItem(i);
                if (this.input.getLocalHosts()[i] == null) continue;
                item.setText(1, this.input.getLocalHosts()[i]);
            }
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getErrorTableName() != null) {
            this.wErrorTable.setText(this.input.getErrorTableName());
        }
        if (this.input.getGploadPath() != null) {
            this.wGploadPath.setText(this.input.getGploadPath());
        }
        if (this.input.getControlFile() != null) {
            this.wControlFile.setText(this.input.getControlFile());
        }
        if (this.input.getDataFile() != null) {
            this.wDataFile.setText(this.input.getDataFile());
        }
        if (this.input.getDelimiter() != null) {
            this.wDelimiter.setText(this.input.getDelimiter());
        }
        if (this.input.getLogFile() != null) {
            this.wLogFile.setText(this.input.getLogFile());
        }
        if (this.input.getEncoding() != null) {
            this.wEncoding.setText(this.input.getEncoding());
        }
        if (this.input.getLocalhostPort() != null) {
            this.wLocalhostPort.setText(this.input.getLocalhostPort());
        }
        if (this.input.getUpdateCondition() != null) {
            this.wUpdateCondition.setText(this.input.getUpdateCondition());
        }
        this.wEraseFiles.setSelection(this.input.isEraseFiles());
        String method = this.input.getLoadMethod();
        if ("AUTO_END".equals(method)) {
            this.wLoadMethod.select(0);
        } else if ("MANUAL".equals(method)) {
            this.wLoadMethod.select(1);
        } else {
            if (this.log.isDebug()) {
                this.logDebug("Internal error: load_method set to default 'auto at end'");
            }
            this.wLoadMethod.select(0);
        }
        String action = this.input.getLoadAction();
        if ("insert".equals(action)) {
            this.wLoadAction.select(0);
        } else if ("update".equals(action)) {
            this.wLoadAction.select(1);
        } else if ("merge".equals(action)) {
            this.wLoadAction.select(2);
        } else {
            if (this.log.isDebug()) {
                this.logDebug("Internal error: load_action set to default 'insert'");
            }
            this.wLoadAction.select(0);
        }
        this.wStepname.selectAll();
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(GPLoadMeta inf) {
        int nrfields = this.wReturn.nrNonEmpty();
        inf.allocate(nrfields);
        inf.setMaxErrors(this.wMaxErrors.getText());
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GPLoadDialog.Log.FoundFields", (String[])new String[]{"" + nrfields}));
        }
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            inf.getFieldTable()[i] = item.getText(1);
            inf.getFieldStream()[i] = item.getText(2);
            inf.getDateMask()[i] = BaseMessages.getString(PKG, (String)"GPLoadDialog.DateMask.Label", (String[])new String[0]).equals(item.getText(3)) ? "DATE" : (BaseMessages.getString(PKG, (String)"GPLoadDialog.DateTimeMask.Label", (String[])new String[0]).equals(item.getText(3)) ? "DATETIME" : "");
            inf.getMatchColumn()[i] = "Y".equalsIgnoreCase(item.getText(4));
            inf.getUpdateColumn()[i] = "Y".equalsIgnoreCase(item.getText(5));
        }
        int numberOfLocalHosts = this.wLocalHosts.nrNonEmpty();
        inf.allocateLocalHosts(numberOfLocalHosts);
        for (int i = 0; i < numberOfLocalHosts; ++i) {
            TableItem item = this.wLocalHosts.getNonEmpty(i);
            inf.getLocalHosts()[i] = item.getText(1);
        }
        inf.setSchemaName(this.wSchema.getText());
        inf.setTableName(this.wTable.getText());
        inf.setErrorTableName(this.wErrorTable.getText());
        inf.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        inf.setGploadPath(this.wGploadPath.getText());
        inf.setControlFile(this.wControlFile.getText());
        inf.setDataFile(this.wDataFile.getText());
        inf.setLogFile(this.wLogFile.getText());
        inf.setEncoding(this.wEncoding.getText());
        inf.setEraseFiles(this.wEraseFiles.getSelection());
        inf.setLocalhostPort(this.wLocalhostPort.getText());
        inf.setDelimiter(this.wDelimiter.getText());
        inf.setUpdateCondition(this.wUpdateCondition.getText());
        String method = this.wLoadMethod.getText();
        if (BaseMessages.getString(PKG, (String)"GPLoadDialog.AutoEndLoadMethod.Label", (String[])new String[0]).equals(method)) {
            inf.setLoadMethod("AUTO_END");
        } else if (BaseMessages.getString(PKG, (String)"GPLoadDialog.ManualLoadMethod.Label", (String[])new String[0]).equals(method)) {
            inf.setLoadMethod("MANUAL");
        } else {
            if (this.log.isDebug()) {
                this.logDebug("Internal error: load_method set to default 'auto concurrent', value found '" + method + "'.");
            }
            inf.setLoadMethod("AUTO_END");
        }
        String action = this.wLoadAction.getText();
        if (BaseMessages.getString(PKG, (String)"GPLoadDialog.InsertLoadAction.Label", (String[])new String[0]).equals(action)) {
            inf.setLoadAction("insert");
        } else if (BaseMessages.getString(PKG, (String)"GPLoadDialog.UpdateLoadAction.Label", (String[])new String[0]).equals(action)) {
            inf.setLoadAction("update");
        } else if (BaseMessages.getString(PKG, (String)"GPLoadDialog.MergeLoadAction.Label", (String[])new String[0]).equals(action)) {
            inf.setLoadAction("merge");
        } else {
            if (this.log.isDebug()) {
                this.logDebug("Internal error: load_action set to default 'append', value found '" + action + "'.");
            }
            inf.setLoadAction("insert");
        }
        this.stepname = this.wStepname.getText();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.getInfo(this.input);
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"GPLoadDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void getTableName(TextVar schema, TextVar tableName) {
        DatabaseMeta inf = null;
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            inf = this.transMeta.getDatabase(connr);
        }
        if (inf != null) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"GPLoadDialog.Log.LookingAtConnection", (String[])new String[0]) + inf.toString());
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                schema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                tableName.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"GPLoadDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void getUpdate() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        if (v.getType() == 3) {
                            tableItem.setText(3, BaseMessages.getString((Class)PKG, (String)"GPLoadDialog.DateMask.Label", (String[])new String[0]));
                        } else {
                            tableItem.setText(3, "");
                        }
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (TableItemInsertListener)listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GPLoadDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GPLoadDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            GPLoadMeta info = new GPLoadMeta();
            this.getInfo(info);
            String name = this.stepname;
            StepMeta stepMeta = new StepMeta(BaseMessages.getString(PKG, (String)"GPLoadDialog.StepMeta.Title", (String[])new String[0]), name, (StepMetaInterface)info);
            RowMetaInterface prev = this.transMeta.getPrevStepFields(this.stepname);
            SQLStatement sql = info.getSQLStatements(this.transMeta, stepMeta, prev, this.repository, this.metaStore);
            if (!sql.hasError()) {
                if (sql.hasSQL()) {
                    SQLEditor sqledit = new SQLEditor((VariableSpace)this.transMeta, this.shell, 0, info.getDatabaseMeta(), this.transMeta.getDbCache(), sql.getSQL());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"GPLoadDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GPLoadDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GPLoadDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void addFieldTabItem(CTabFolder tabFolder, int margin, ModifyListener lsMod) {
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.FieldsTab.Title", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)tabFolder, 0);
        this.props.setLook((Control)wFieldsComp);
        FormLayout tabFieldLayout = new FormLayout();
        tabFieldLayout.marginWidth = 3;
        tabFieldLayout.marginHeight = 3;
        wFieldsComp.setLayout((Layout)tabFieldLayout);
        Label wlLoadAction = new Label(wFieldsComp, 0);
        wlLoadAction.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.LoadAction.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLoadAction);
        FormData fdlLoadAction = new FormData();
        fdlLoadAction.left = new FormAttachment(0, 0);
        fdlLoadAction.top = new FormAttachment(0, margin);
        wlLoadAction.setLayoutData((Object)fdlLoadAction);
        this.wLoadAction = new CCombo(wFieldsComp, 2060);
        this.wLoadAction.add(BaseMessages.getString(PKG, (String)"GPLoadDialog.InsertLoadAction.Label", (String[])new String[0]));
        this.wLoadAction.add(BaseMessages.getString(PKG, (String)"GPLoadDialog.UpdateLoadAction.Label", (String[])new String[0]));
        this.wLoadAction.add(BaseMessages.getString(PKG, (String)"GPLoadDialog.MergeLoadAction.Label", (String[])new String[0]));
        this.wLoadAction.select(0);
        this.wLoadAction.addModifyListener(lsMod);
        this.props.setLook((Control)this.wLoadAction);
        FormData fdLoadAction = new FormData();
        fdLoadAction.left = new FormAttachment((Control)wlLoadAction, margin);
        fdLoadAction.top = new FormAttachment(0, margin);
        this.wLoadAction.setLayoutData((Object)fdLoadAction);
        Button wDoMapping = new Button(wFieldsComp, 8);
        wDoMapping.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.EditMapping.Label", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment(0, margin);
        fdDoMapping.right = new FormAttachment(75, 0);
        wDoMapping.setLayoutData((Object)fdDoMapping);
        Button wGetLU = new Button(wFieldsComp, 8);
        wGetLU.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.GetFields.Label", (String[])new String[0]));
        FormData fdGetLU = new FormData();
        fdGetLU.top = new FormAttachment(0, margin);
        fdGetLU.right = new FormAttachment((Control)wDoMapping, -margin);
        wGetLU.setLayoutData((Object)fdGetLU);
        wDoMapping.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                GPLoadDialog.this.generateMappings();
            }
        });
        int numberOfColumns = 5;
        int UpInsRows = this.input.getFieldTable() != null ? this.input.getFieldTable().length : 1;
        this.ciReturn = new ColumnInfo[numberOfColumns];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GPLoadDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GPLoadDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GPLoadDialog.ColumnInfo.DateMask", (String[])new String[0]), 2, new String[]{"", BaseMessages.getString(PKG, (String)"GPLoadDialog.DateMask.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GPLoadDialog.DateTimeMask.Label", (String[])new String[0])}, true);
        this.ciReturn[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GPLoadDialog.ColumnInfo.ColumnMatch", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}, true);
        this.ciReturn[4] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GPLoadDialog.ColumnInfo.ColumnUpdate", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}, true);
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView((VariableSpace)this.transMeta, wFieldsComp, 68354, this.ciReturn, UpInsRows, lsMod, this.props);
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)this.wLoadAction, margin);
        fdReturn.right = new FormAttachment(75, 0);
        fdReturn.bottom = new FormAttachment(100, -2 * margin);
        this.wReturn.setLayoutData((Object)fdReturn);
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, margin);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        Label wlUpdateCondition = new Label(wFieldsComp, 0);
        wlUpdateCondition.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.UpdateCondition.Label", (String[])new String[0]));
        this.props.setLook((Control)wlUpdateCondition);
        FormData fdlUpdateCondition = new FormData();
        fdlUpdateCondition.top = new FormAttachment((Control)wDoMapping, margin);
        fdlUpdateCondition.left = new FormAttachment((Control)this.wReturn, margin);
        wlUpdateCondition.setLayoutData((Object)fdlUpdateCondition);
        this.wUpdateCondition = new Text(wFieldsComp, 18498);
        this.props.setLook((Control)this.wUpdateCondition);
        this.wUpdateCondition.addModifyListener(lsMod);
        FormData fdUpdateCondition = new FormData();
        fdUpdateCondition.top = new FormAttachment((Control)wlUpdateCondition, margin);
        fdUpdateCondition.left = new FormAttachment((Control)this.wReturn, margin);
        fdUpdateCondition.right = new FormAttachment(100, -margin);
        fdUpdateCondition.bottom = new FormAttachment(50, 0);
        this.wUpdateCondition.setLayoutData((Object)fdUpdateCondition);
        wFieldsComp.layout();
        tabItem.setControl((Control)wFieldsComp);
        Listener lsGetLU = new Listener(){

            public void handleEvent(Event e) {
                GPLoadDialog.this.getUpdate();
            }
        };
        wGetLU.addListener(13, lsGetLU);
    }

    private void addLocalHostsTabItem(CTabFolder tabFolder, int margin, ModifyListener lsMod, FocusListener lsFocusLost) {
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.LocalHostsTab.Title", (String[])new String[0]));
        Composite wLocalHostsComp = new Composite((Composite)tabFolder, 0);
        this.props.setLook((Control)wLocalHostsComp);
        int middle = this.props.getMiddlePct();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 3;
        formLayout.marginHeight = 3;
        wLocalHostsComp.setLayout((Layout)formLayout);
        Label wlLocalhostPort = new Label(wLocalHostsComp, 0);
        wlLocalhostPort.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.Port.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLocalhostPort);
        FormData fdlLocalhostPort = new FormData();
        fdlLocalhostPort.left = new FormAttachment(0, 0);
        fdlLocalhostPort.top = new FormAttachment(0, margin * 2);
        wlLocalhostPort.setLayoutData((Object)fdlLocalhostPort);
        this.wLocalhostPort = new TextVar((VariableSpace)this.transMeta, wLocalHostsComp, 18436);
        this.props.setLook((Control)this.wLocalhostPort);
        this.wLocalhostPort.addModifyListener(lsMod);
        this.wLocalhostPort.addFocusListener(lsFocusLost);
        FormData fdLocalhostPort = new FormData();
        fdLocalhostPort.left = new FormAttachment((Control)wlLocalhostPort, margin);
        fdLocalhostPort.top = new FormAttachment(0, margin * 2);
        fdLocalhostPort.right = new FormAttachment(middle, 0);
        this.wLocalhostPort.setLayoutData((Object)fdLocalhostPort);
        this.wLocalhostPort.addModifyListener(lsMod);
        Label wlLocalHosts = new Label(wLocalHostsComp, 0);
        wlLocalHosts.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.LocalHosts.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLocalHosts);
        FormData fdlLocalHosts = new FormData();
        fdlLocalHosts.left = new FormAttachment(0, 0);
        fdlLocalHosts.top = new FormAttachment((Control)this.wLocalhostPort, margin);
        wlLocalHosts.setLayoutData((Object)fdlLocalHosts);
        int LocalHostsColumns = 1;
        int LocalHostsRows = this.input.getLocalHosts() != null ? this.input.getLocalHosts().length : 1;
        this.ciLocalHosts = new ColumnInfo[LocalHostsColumns];
        this.ciLocalHosts[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"GPLoadDialog.ColumnInfo.LocalHosts", (String[])new String[0]), 1, new String[]{""}, false);
        this.localHostsColumns.add(this.ciReturn[0]);
        this.wLocalHosts = new TableView((VariableSpace)this.transMeta, wLocalHostsComp, 68354, this.ciLocalHosts, LocalHostsRows, lsMod, this.props);
        FormData fdLocalHostsComp = new FormData();
        fdLocalHostsComp.left = new FormAttachment(0, 0);
        fdLocalHostsComp.top = new FormAttachment((Control)wlLocalHosts, margin);
        fdLocalHostsComp.right = new FormAttachment(75, 0);
        fdLocalHostsComp.bottom = new FormAttachment(100, -margin);
        this.wLocalHosts.setLayoutData((Object)fdLocalHostsComp);
        wLocalHostsComp.layout();
        tabItem.setControl((Control)wLocalHostsComp);
    }

    private void addGPConfigTabItem(CTabFolder tabFolder, int margin, ModifyListener lsMod, FocusListener lsFocusLost) {
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.GPConfiguratonTab.Title", (String[])new String[0]));
        Composite wGPConfigTabComp = new Composite((Composite)tabFolder, 0);
        this.props.setLook((Control)wGPConfigTabComp);
        int middle = this.props.getMiddlePct();
        FormLayout formlayout = new FormLayout();
        formlayout.marginWidth = 3;
        formlayout.marginHeight = 3;
        wGPConfigTabComp.setLayout((Layout)formlayout);
        Label wlGploadPath = new Label(wGPConfigTabComp, 131072);
        wlGploadPath.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.GPLoadPath.Label", (String[])new String[0]));
        this.props.setLook((Control)wlGploadPath);
        FormData fdlGploadPath = new FormData();
        fdlGploadPath.left = new FormAttachment(0, 0);
        fdlGploadPath.right = new FormAttachment(middle, -margin);
        fdlGploadPath.top = new FormAttachment(0, margin);
        wlGploadPath.setLayoutData((Object)fdlGploadPath);
        Button wbGploadPath = new Button(wGPConfigTabComp, 0x1000008);
        this.props.setLook((Control)wbGploadPath);
        wbGploadPath.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.Browse.Button", (String[])new String[0]));
        FormData fdbGploadPath = new FormData();
        fdbGploadPath.right = new FormAttachment(75, 0);
        fdbGploadPath.top = new FormAttachment(0, margin);
        wbGploadPath.setLayoutData((Object)fdbGploadPath);
        this.wGploadPath = new TextVar((VariableSpace)this.transMeta, wGPConfigTabComp, 18436);
        this.props.setLook((Control)this.wGploadPath);
        this.wGploadPath.addModifyListener(lsMod);
        FormData fdGploadPath = new FormData();
        fdGploadPath.left = new FormAttachment(middle, 0);
        fdGploadPath.top = new FormAttachment(0, margin);
        fdGploadPath.right = new FormAttachment((Control)wbGploadPath, -margin);
        this.wGploadPath.setLayoutData((Object)fdGploadPath);
        Label wlControlFile = new Label(wGPConfigTabComp, 131072);
        wlControlFile.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.ControlFile.Label", (String[])new String[0]));
        this.props.setLook((Control)wlControlFile);
        FormData fdlControlFile = new FormData();
        fdlControlFile.left = new FormAttachment(0, 0);
        fdlControlFile.top = new FormAttachment((Control)this.wGploadPath, margin);
        fdlControlFile.right = new FormAttachment(middle, -margin);
        wlControlFile.setLayoutData((Object)fdlControlFile);
        Button wbControlFile = new Button(wGPConfigTabComp, 0x1000008);
        this.props.setLook((Control)wbControlFile);
        wbControlFile.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.Browse.Button", (String[])new String[0]));
        FormData fdbControlFile = new FormData();
        fdbControlFile.right = new FormAttachment(75, 0);
        fdbControlFile.top = new FormAttachment((Control)this.wGploadPath, margin);
        wbControlFile.setLayoutData((Object)fdbControlFile);
        this.wControlFile = new TextVar((VariableSpace)this.transMeta, wGPConfigTabComp, 18436);
        this.props.setLook((Control)this.wControlFile);
        this.wControlFile.addModifyListener(lsMod);
        FormData fdControlFile = new FormData();
        fdControlFile.left = new FormAttachment(middle, 0);
        fdControlFile.top = new FormAttachment((Control)this.wGploadPath, margin);
        fdControlFile.right = new FormAttachment((Control)wbControlFile, -margin);
        this.wControlFile.setLayoutData((Object)fdControlFile);
        Label wlErrorTable = new Label(wGPConfigTabComp, 131072);
        wlErrorTable.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.ErrorTable.Label", (String[])new String[0]));
        this.props.setLook((Control)wlErrorTable);
        FormData fdlErrorTable = new FormData();
        fdlErrorTable.left = new FormAttachment(0, 0);
        fdlErrorTable.top = new FormAttachment((Control)this.wControlFile, margin);
        fdlErrorTable.right = new FormAttachment(middle, -margin);
        wlErrorTable.setLayoutData((Object)fdlErrorTable);
        Button wbErrorTable = new Button(wGPConfigTabComp, 0x1000008);
        this.props.setLook((Control)wbErrorTable);
        wbErrorTable.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.Browse.Button", (String[])new String[0]));
        FormData fdbErrorTable = new FormData();
        fdbErrorTable.right = new FormAttachment(75, 0);
        fdbErrorTable.top = new FormAttachment((Control)this.wControlFile, margin);
        wbErrorTable.setLayoutData((Object)fdbErrorTable);
        this.wErrorTable = new TextVar((VariableSpace)this.transMeta, wGPConfigTabComp, 18436);
        this.props.setLook((Control)this.wErrorTable);
        this.wErrorTable.addModifyListener(lsMod);
        this.wErrorTable.addFocusListener(lsFocusLost);
        FormData fdErrorTable = new FormData();
        fdErrorTable.left = new FormAttachment(middle, 0);
        fdErrorTable.top = new FormAttachment((Control)this.wControlFile, margin);
        fdErrorTable.right = new FormAttachment((Control)wbErrorTable, -margin);
        this.wErrorTable.setLayoutData((Object)fdErrorTable);
        Label wlMaxErrors = new Label(wGPConfigTabComp, 131072);
        wlMaxErrors.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.MaxErrors.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMaxErrors);
        FormData fdlMaxErrors = new FormData();
        fdlMaxErrors.left = new FormAttachment((Control)wbErrorTable, margin);
        fdlMaxErrors.top = new FormAttachment((Control)this.wControlFile, margin);
        wlMaxErrors.setLayoutData((Object)fdlMaxErrors);
        this.wMaxErrors = new TextVar((VariableSpace)this.transMeta, wGPConfigTabComp, 18436);
        this.props.setLook((Control)this.wMaxErrors);
        this.wMaxErrors.addModifyListener(lsMod);
        FormData fdMaxErrors = new FormData();
        fdMaxErrors.left = new FormAttachment((Control)wlMaxErrors, margin);
        fdMaxErrors.top = new FormAttachment((Control)this.wControlFile, margin);
        fdMaxErrors.right = new FormAttachment(100, 0);
        this.wMaxErrors.setLayoutData((Object)fdMaxErrors);
        Label wlLogFile = new Label(wGPConfigTabComp, 131072);
        wlLogFile.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.LogFile.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLogFile);
        FormData fdlLogFile = new FormData();
        fdlLogFile.left = new FormAttachment(0, 0);
        fdlLogFile.top = new FormAttachment((Control)this.wErrorTable, margin);
        fdlLogFile.right = new FormAttachment(middle, -margin);
        wlLogFile.setLayoutData((Object)fdlLogFile);
        Button wbLogFile = new Button(wGPConfigTabComp, 0x1000008);
        this.props.setLook((Control)wbLogFile);
        wbLogFile.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.Browse.Button", (String[])new String[0]));
        FormData fdbLogFile = new FormData();
        fdbLogFile.right = new FormAttachment(75, 0);
        fdbLogFile.top = new FormAttachment((Control)this.wErrorTable, margin);
        wbLogFile.setLayoutData((Object)fdbLogFile);
        this.wLogFile = new TextVar((VariableSpace)this.transMeta, wGPConfigTabComp, 18436);
        this.props.setLook((Control)this.wLogFile);
        this.wLogFile.addModifyListener(lsMod);
        FormData fdLogFile = new FormData();
        fdLogFile.left = new FormAttachment(middle, 0);
        fdLogFile.top = new FormAttachment((Control)this.wErrorTable, margin);
        fdLogFile.right = new FormAttachment((Control)wbLogFile, -margin);
        this.wLogFile.setLayoutData((Object)fdLogFile);
        Label wlDataFile = new Label(wGPConfigTabComp, 131072);
        wlDataFile.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.DataFile.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDataFile);
        FormData fdlDataFile = new FormData();
        fdlDataFile.left = new FormAttachment(0, 0);
        fdlDataFile.top = new FormAttachment((Control)this.wLogFile, margin);
        fdlDataFile.right = new FormAttachment(middle, -margin);
        wlDataFile.setLayoutData((Object)fdlDataFile);
        Button wbDataFile = new Button(wGPConfigTabComp, 0x1000008);
        this.props.setLook((Control)wbDataFile);
        wbDataFile.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.Browse.Button", (String[])new String[0]));
        FormData fdbDataFile = new FormData();
        fdbDataFile.right = new FormAttachment(75, 0);
        fdbDataFile.top = new FormAttachment((Control)this.wLogFile, margin);
        wbDataFile.setLayoutData((Object)fdbDataFile);
        this.wDataFile = new TextVar((VariableSpace)this.transMeta, wGPConfigTabComp, 18436);
        this.props.setLook((Control)this.wDataFile);
        this.wDataFile.addModifyListener(lsMod);
        FormData fdDataFile = new FormData();
        fdDataFile.left = new FormAttachment(middle, 0);
        fdDataFile.top = new FormAttachment((Control)this.wLogFile, margin);
        fdDataFile.right = new FormAttachment((Control)wbDataFile, -margin);
        this.wDataFile.setLayoutData((Object)fdDataFile);
        Label wlDelimiter = new Label(wGPConfigTabComp, 131072);
        wlDelimiter.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.Delimiter.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDelimiter);
        FormData fdlDelimiter = new FormData();
        fdlDelimiter.left = new FormAttachment((Control)wbDataFile, margin);
        fdlDelimiter.top = new FormAttachment((Control)this.wLogFile, margin);
        wlDelimiter.setLayoutData((Object)fdlDelimiter);
        this.wDelimiter = new TextVar((VariableSpace)this.transMeta, wGPConfigTabComp, 18436);
        this.props.setLook((Control)this.wMaxErrors);
        this.wDelimiter.addModifyListener(lsMod);
        FormData fdDelimiter = new FormData();
        fdDelimiter.left = new FormAttachment((Control)wlDelimiter, margin);
        fdDelimiter.top = new FormAttachment((Control)this.wLogFile, margin);
        fdDelimiter.right = new FormAttachment(100, 0);
        this.wDelimiter.setLayoutData((Object)fdDelimiter);
        Label wlEncoding = new Label(wGPConfigTabComp, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"GPLoadDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.top = new FormAttachment((Control)this.wDataFile, margin);
        fdlEncoding.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new Combo(wGPConfigTabComp, 18436);
        this.wEncoding.setToolTipText(BaseMessages.getString(PKG, (String)"GPLoadDialog.Encoding.Tooltip", (String[])new String[0]));
        this.wEncoding.setItems(GPLoadMeta.SUPPORTED_ENCODINGS);
        this.props.setLook((Control)this.wEncoding);
        FormData fdEncoding = new FormData();
        fdEncoding.left = new FormAttachment(middle, 0);
        fdEncoding.top = new FormAttachment((Control)this.wDataFile, margin);
        fdEncoding.right = new FormAttachment(75, 0);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addModifyListener(lsMod);
        wGPConfigTabComp.layout();
        tabItem.setControl((Control)wGPConfigTabComp);
        wbErrorTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GPLoadDialog.this.getTableName(GPLoadDialog.this.wSchema, GPLoadDialog.this.wErrorTable);
            }
        });
        wbGploadPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(GPLoadDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*"});
                if (GPLoadDialog.this.wGploadPath.getText() != null) {
                    dialog.setFileName(GPLoadDialog.this.wGploadPath.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    GPLoadDialog.this.wGploadPath.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        wbControlFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(GPLoadDialog.this.shell, 8192);
                dialog.setFilterExtensions(new String[]{"*"});
                if (GPLoadDialog.this.wControlFile.getText() != null) {
                    dialog.setFileName(GPLoadDialog.this.wControlFile.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    GPLoadDialog.this.wControlFile.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        wbDataFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(GPLoadDialog.this.shell, 8192);
                dialog.setFilterExtensions(new String[]{"*"});
                if (GPLoadDialog.this.wDataFile.getText() != null) {
                    dialog.setFileName(GPLoadDialog.this.wDataFile.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    GPLoadDialog.this.wDataFile.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        wbLogFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(GPLoadDialog.this.shell, 8192);
                dialog.setFilterExtensions(new String[]{"*"});
                if (GPLoadDialog.this.wLogFile.getText() != null) {
                    dialog.setFileName(GPLoadDialog.this.wLogFile.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    GPLoadDialog.this.wLogFile.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
    }
}

