/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.dialect;

import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IValueMeta;
import org.pentaho.database.dialect.AbstractDatabaseDialect;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;

public class HiveDatabaseDialect
extends AbstractDatabaseDialect {
    private static final long serialVersionUID = -8456961348836455937L;
    private static final int DEFAULT_PORT = 10000;
    private static final IDatabaseType DBTYPE = new DatabaseType("Hadoop Hive", "HIVE", DatabaseAccessType.getList(DatabaseAccessType.NATIVE, DatabaseAccessType.JNDI), 10000, "https://cwiki.apache.org/Hive/hiveclient.html");

    @Override
    public IDatabaseType getDatabaseType() {
        return DBTYPE;
    }

    @Override
    public String getNativeDriver() {
        return "org.apache.hadoop.hive.jdbc.HiveDriver";
    }

    @Override
    public String getURL(IDatabaseConnection connection) throws DatabaseDialectException {
        StringBuffer urlBuffer = new StringBuffer(this.getNativeJdbcPre());
        urlBuffer.append(connection.getHostname());
        urlBuffer.append(":");
        urlBuffer.append(connection.getDatabasePort());
        urlBuffer.append("/");
        urlBuffer.append(connection.getDatabaseName());
        return urlBuffer.toString();
    }

    @Override
    public String getNativeJdbcPre() {
        return "jdbc:hive://";
    }

    @Override
    public String getAddColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "DATETIME";
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval = retval + "BOOLEAN";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (use_autoinc) {
                        retval = retval + "BIGINT AUTO_INCREMENT NOT NULL PRIMARY KEY";
                        break;
                    }
                    retval = retval + "BIGINT NOT NULL PRIMARY KEY";
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            retval = retval + "BIGINT";
                            break;
                        }
                        retval = retval + "DECIMAL(" + length + ")";
                        break;
                    }
                    retval = retval + "INT";
                    break;
                }
                if (length > 15) {
                    retval = retval + "DECIMAL(" + length;
                    if (precision > 0) {
                        retval = retval + ", " + precision;
                    }
                    retval = retval + ")";
                    break;
                }
                retval = retval + "DOUBLE";
                break;
            }
            case 2: {
                if (length > 0) {
                    if (length == 1) {
                        retval = retval + "CHAR(1)";
                        break;
                    }
                    if (length < 256) {
                        retval = retval + "VARCHAR(" + length + ")";
                        break;
                    }
                    if (length < 65536) {
                        retval = retval + "TEXT";
                        break;
                    }
                    if (length < 0xFFFFFF) {
                        retval = retval + "MEDIUMTEXT";
                        break;
                    }
                    retval = retval + "LONGTEXT";
                    break;
                }
                retval = retval + "TINYTEXT";
                break;
            }
            case 8: {
                retval = retval + "LONGBLOB";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + " ";
        }
        return retval;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"pentaho-hadoop-hive-jdbc-shim-1.4-SNAPSHOT.jar"};
    }

    @Override
    public int getDefaultDatabasePort() {
        return 10000;
    }

    @Override
    public boolean supportsSchemas() {
        return false;
    }
}

