/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.NumberFormatParser;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class DecimalFormatParser
extends NumberFormatParser {
    private Locale lastLocale;
    private boolean keepState;

    public DecimalFormatParser() {
        this.setFormatter(new DecimalFormat());
    }

    public DecimalFormat getDecimalFormat() {
        return (DecimalFormat)this.getFormatter();
    }

    public void setDecimalFormat(DecimalFormat format) {
        this.setFormatter(format);
    }

    @Override
    public void setFormatter(Format format) {
        if (format == null) {
            throw new NullPointerException("The number format given must not be null.");
        }
        DecimalFormat dfmt = (DecimalFormat)format;
        dfmt.setParseBigDecimal(true);
        super.setFormatter(dfmt);
    }

    public String getFormatString() {
        return this.getDecimalFormat().toPattern();
    }

    public void setFormatString(String format) {
        this.getDecimalFormat().applyPattern(format);
    }

    public String getLocalizedFormatString() {
        return this.getDecimalFormat().toLocalizedPattern();
    }

    public void setLocalizedFormatString(String format) {
        this.getDecimalFormat().applyLocalizedPattern(format);
    }

    public boolean isKeepState() {
        return this.keepState;
    }

    public void setKeepState(boolean keepState) {
        this.keepState = keepState;
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        Locale locale;
        if (!this.keepState && runtime != null && (locale = runtime.getResourceBundleFactory().getLocale()) != null && !locale.equals(this.lastLocale)) {
            this.lastLocale = locale;
            this.getDecimalFormat().setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
        }
        return super.getValue(runtime, element);
    }
}

