/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.text.Format;
import java.text.ParseException;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.DataFilter;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class FormatParser
implements DataFilter {
    private Format format;
    private DataSource datasource;
    private Object nullvalue;

    public void setFormatter(Format format) {
        if (format == null) {
            throw new NullPointerException();
        }
        this.format = format;
    }

    public Format getFormatter() {
        return this.format;
    }

    @Override
    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        Format f = this.getFormatter();
        if (f == null) {
            return this.getNullValue();
        }
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return this.getNullValue();
        }
        Object o = ds.getValue(runtime, element);
        if (o == null) {
            return this.getNullValue();
        }
        if (this.isValidOutput(o)) {
            return o;
        }
        try {
            return f.parseObject(String.valueOf(o));
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected boolean isValidOutput(Object o) {
        return false;
    }

    @Override
    public DataSource getDataSource() {
        return this.datasource;
    }

    @Override
    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        this.datasource = ds;
    }

    public void setNullValue(Object nullvalue) {
        this.nullvalue = nullvalue;
    }

    public Object getNullValue() {
        return this.nullvalue;
    }

    @Override
    public FormatParser clone() throws CloneNotSupportedException {
        FormatParser p = (FormatParser)super.clone();
        if (this.datasource != null) {
            p.datasource = this.datasource.clone();
        }
        if (this.format != null) {
            p.format = (Format)this.format.clone();
        }
        return p;
    }
}

