/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionUtilities;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.Sequence;

public class TotalGroupSumFunction
extends AbstractFunction
implements FieldAggregationFunction {
    protected static final BigDecimal ZERO = new BigDecimal(0.0);
    private transient HashMap<ReportStateKey, Sequence<BigDecimal>> results = new HashMap();
    private transient int lastGroupSequenceNumber;
    private String field;
    private String group;
    private transient Sequence<BigDecimal> result;
    private transient ReportStateKey globalStateKey;
    protected transient ReportStateKey currentGroupKey;
    private String crosstabFilterGroup;

    @Override
    public void reportInitialized(ReportEvent event) {
        this.globalStateKey = event.getState().getProcessKey();
        if (this.isPrepareRunLevel(event)) {
            this.result = new Sequence();
            this.results.clear();
            this.results.put(this.globalStateKey, this.result);
            this.lastGroupSequenceNumber = 0;
        } else {
            this.result = this.results.get(this.globalStateKey);
            this.lastGroupSequenceNumber = 0;
        }
    }

    protected boolean isPrepareRunLevel(ReportEvent event) {
        return FunctionUtilities.isDefinedPrepareRunLevel(this, event);
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getGroup(), event)) {
            this.currentGroupKey = event.getState().getProcessKey();
            if (this.isPrepareRunLevel(event)) {
                this.clear();
                this.results.put(this.globalStateKey, this.result);
                this.results.put(this.currentGroupKey, this.result);
            } else {
                this.result = this.results.get(this.currentGroupKey);
            }
        }
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    protected void clear() {
        this.result = new Sequence();
        this.lastGroupSequenceNumber = 0;
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        if (this.field == null) {
            return;
        }
        if (!this.isPrepareRunLevel(event)) {
            return;
        }
        BigDecimal value = ExpressionUtilities.convertToBigDecimal(event.getDataRow().get(this.getField()));
        if (value == null) {
            return;
        }
        BigDecimal oldValue = this.result.get(this.lastGroupSequenceNumber);
        if (oldValue == null) {
            this.result.set(this.lastGroupSequenceNumber, value);
        } else {
            this.result.set(this.lastGroupSequenceNumber, oldValue.add(value));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TotalGroupSumFunction o = (TotalGroupSumFunction)super.clone();
        o.results = (HashMap)this.results.clone();
        for (Map.Entry<ReportStateKey, Sequence<BigDecimal>> entry : this.results.entrySet()) {
            if (entry.getKey() == this.globalStateKey || entry.getKey() == this.currentGroupKey) continue;
            o.results.put(entry.getKey(), (Sequence<BigDecimal>)entry.getValue().clone());
        }
        if (this.result != null) {
            o.result = this.result.clone();
            o.results.put(this.globalStateKey, o.result);
            o.results.put(this.currentGroupKey, o.result);
        }
        return o;
    }

    @Override
    public void summaryRowSelection(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getCrosstabFilterGroup(), event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    public Object getValue() {
        if (this.result == null) {
            return ZERO;
        }
        BigDecimal value = this.result.get(this.lastGroupSequenceNumber);
        if (value == null) {
            return ZERO;
        }
        return value;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public void setField(String field) {
        this.field = field;
    }

    @Override
    public Expression getInstance() {
        TotalGroupSumFunction function = (TotalGroupSumFunction)super.getInstance();
        function.result = null;
        function.results = new HashMap();
        return function;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.results = new HashMap();
        this.result = null;
    }

    @Override
    public String getCrosstabFilterGroup() {
        return this.crosstabFilterGroup;
    }

    @Override
    public void setCrosstabFilterGroup(String crosstabFilterGroup) {
        this.crosstabFilterGroup = crosstabFilterGroup;
    }
}

