/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.formula;

import java.math.BigDecimal;
import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class RowCountFunction
implements Function {
    public String getCanonicalName() {
        return "ROWCOUNT";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int groupStart;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount > 1) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        ReportFormulaContext rfc = (ReportFormulaContext)context;
        if (parameterCount == 0) {
            groupStart = rfc.getRuntime().getGroupStartRow(-1);
        } else {
            String groupName = context.getTypeRegistry().convertToText(parameters.getType(0), parameters.getValue(0));
            groupStart = rfc.getRuntime().getGroupStartRow(groupName);
        }
        int row = rfc.getRuntime().getCurrentRow();
        return new TypeValuePair((Type)NumberType.GENERIC_NUMBER, (Object)new BigDecimal((double)(row - groupStart)));
    }
}

