/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.layout.ModelPrinter;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;

public class FileModelPrinter
extends ModelPrinter {
    private BufferedWriter writer;
    private boolean enablePageFooter;
    private boolean enablePageHeader;

    public FileModelPrinter() throws IOException {
        this("model-dump-");
        this.enablePageFooter = true;
        this.enablePageHeader = true;
    }

    public FileModelPrinter(String prefix) throws IOException {
        File file = File.createTempFile(prefix, ".txt");
        this.writer = new BufferedWriter(new FileWriter(file));
    }

    public FileModelPrinter(String prefix, File tempDir) throws IOException {
        File file = File.createTempFile(prefix, ".txt", tempDir);
        this.writer = new BufferedWriter(new FileWriter(file));
    }

    public FileModelPrinter(File file) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(file));
    }

    @Override
    protected boolean isPrintingEnabled() {
        return true;
    }

    @Override
    protected void print(String s) {
        try {
            this.writer.write(s);
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    protected boolean isPrintPageHeader() {
        return this.enablePageHeader;
    }

    @Override
    protected boolean isPrintPageFooter() {
        return this.enablePageFooter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void print(String filename, RenderBox renderBox) {
        try {
            FileModelPrinter f = new FileModelPrinter(new File(filename));
            f.enablePageFooter = false;
            f.enablePageHeader = false;
            try {
                f.print(renderBox);
            }
            finally {
                f.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

