/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.libraries.base.util.MemoryUsageMessage;
import org.pentaho.reporting.libraries.formatting.FastMessageFormat;

public abstract class AbstractOutputProcessor
implements OutputProcessor {
    private static final Log logger = LogFactory.getLog(AbstractOutputProcessor.class);
    protected static final int PROCESSING_PAGES = 0;
    protected static final int PROCESSING_CONTENT = 2;
    private int processingState;
    private List<LogicalPageKey> logicalPages = new ArrayList<LogicalPageKey>();
    private int pageCursor;
    private long startTime;

    protected AbstractOutputProcessor() {
    }

    @Override
    public void processingStarted(ReportDefinition report, ProcessingContext processingContext) {
        this.startTime = processingContext.getReportProcessingStartTime();
        this.logPerformance("Time to Pagination");
    }

    protected long getStartTime() {
        return this.startTime;
    }

    @Override
    public final int getLogicalPageCount() {
        return this.logicalPages.size();
    }

    @Override
    public final LogicalPageKey getLogicalPage(int page) {
        if (!this.isPaginationFinished()) {
            throw new IllegalStateException();
        }
        return this.logicalPages.get(page);
    }

    @Override
    public final boolean isPaginationFinished() {
        return this.processingState == 2;
    }

    @Override
    public final void processingFinished() {
        if (this.processingState == 0) {
            this.processingPagesFinished();
            this.logPerformance("Pagination finished");
            this.processingState = 2;
        } else {
            this.processingContentFinished();
            this.logPerformance("Content Processing finished");
        }
        this.pageCursor = 0;
    }

    private void logPerformance(String message) {
        long time = System.currentTimeMillis();
        double deltaTime = time - this.getStartTime();
        double rowsPerSec = (double)this.getPageCursor() * 1000.0 / deltaTime;
        if (logger.isDebugEnabled()) {
            FastMessageFormat messageFormat = new FastMessageFormat("{0} - Pages: {1} - Time: {2,number,0.000}sec - Throughput: ({3,number,0.000} rows/sec) ");
            logger.debug((Object)new MemoryUsageMessage(messageFormat.format((Object)new Object[]{message, this.getPageCursor(), deltaTime / 1000.0, rowsPerSec})));
        }
    }

    protected void processingContentFinished() {
    }

    protected void processingPagesFinished() {
        this.logicalPages = Collections.unmodifiableList(this.logicalPages);
    }

    protected LogicalPageKey createLogicalPage(int width, int height) {
        return new LogicalPageKey(this.logicalPages.size(), width, height);
    }

    @Override
    public final int getPageCursor() {
        return this.pageCursor;
    }

    @Override
    public final void setPageCursor(int pageCursor) {
        this.pageCursor = pageCursor;
    }

    protected boolean isContentGeneratable() {
        return this.processingState == 2;
    }

    @Override
    public void processRecomputedContent(LogicalPageBox pageBox) throws ContentProcessingException {
        this.setPageCursor(this.pageCursor + 1);
    }

    @Override
    public final void processContent(LogicalPageBox logicalPage) throws ContentProcessingException {
        if (!this.isContentGeneratable()) {
            PageGrid pageGrid = logicalPage.getPageGrid();
            int rowCount = pageGrid.getRowCount();
            int colCount = pageGrid.getColumnCount();
            LogicalPageKey key = this.createLogicalPage(colCount, rowCount);
            this.logicalPages.add(key);
            int pageCursor = this.getPageCursor();
            if (key.getPosition() != pageCursor) {
                throw new IllegalStateException("Expected position " + pageCursor + " is not the key's position " + key.getPosition());
            }
            this.processPaginationContent(key, logicalPage);
            this.setPageCursor(pageCursor + 1);
        } else {
            int pageCursor = this.getPageCursor();
            LogicalPageKey logicalPageKey = this.getLogicalPage(pageCursor);
            this.processPageContent(logicalPageKey, logicalPage);
            this.setPageCursor(pageCursor + 1);
        }
    }

    @Override
    public boolean isNeedAlignedPage() {
        return this.isContentGeneratable();
    }

    protected void processPaginationContent(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage) throws ContentProcessingException {
    }

    protected abstract void processPageContent(LogicalPageKey var1, LogicalPageBox var2) throws ContentProcessingException;

    @Override
    public int getPhysicalPageCount() {
        return this.getLogicalPageCount();
    }
}

