/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.model.BreakMarkerRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositionList;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositions;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.FindOldestProcessKeyStep;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateVisualProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.PaginationStepLib;
import org.pentaho.reporting.engine.classic.core.layout.process.util.BoxShifter;
import org.pentaho.reporting.engine.classic.core.layout.process.util.InitialPaginationShiftState;
import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationResult;
import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationShiftState;
import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationShiftStatePool;
import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationTableState;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;

public final class PaginationStep
extends IterateVisualProcessStep {
    private static final Log logger = LogFactory.getLog(PaginationStep.class);
    private boolean breakPending;
    private FindOldestProcessKeyStep findOldestProcessKeyStep = new FindOldestProcessKeyStep();
    private PageBreakPositionList basePageBreakList = new PageBreakPositionList();
    private ReportStateKey visualState;
    private BreakMarkerRenderBox breakIndicatorEncountered;
    private PaginationTableState paginationTableState;
    private PaginationShiftState shiftState;
    private PaginationShiftStatePool shiftStatePool = new PaginationShiftStatePool();
    private long pageOffsetKey;
    private long usablePageHeight;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaginationResult performPagebreak(LogicalPageBox pageBox) {
        this.getEventWatch().start();
        this.getSummaryWatch().start();
        try {
            PaginationStepLib.assertProgress(pageBox);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Start pagination ... " + pageBox.getPageOffset()));
            }
            this.breakIndicatorEncountered = null;
            this.visualState = null;
            this.pageOffsetKey = pageBox.getPageOffset();
            this.shiftState = new InitialPaginationShiftState();
            this.breakPending = false;
            this.usablePageHeight = Long.MAX_VALUE;
            long[] allCurrentBreaks = pageBox.getPhysicalBreaks(1);
            if (allCurrentBreaks.length == 0) {
                throw new InvalidReportStateException("No page given. This is really bad.");
            }
            long lastBreakLocal = allCurrentBreaks[allCurrentBreaks.length - 1];
            long reservedHeight = PaginationStepLib.restrictPageAreaHeights(pageBox, allCurrentBreaks);
            if (reservedHeight >= lastBreakLocal) {
                throw new InvalidReportStateException("Header and footer consume the whole page. No space left for normal-flow.");
            }
            PaginationStepLib.configureBreakUtility(this.basePageBreakList, pageBox, allCurrentBreaks, reservedHeight, lastBreakLocal);
            long pageEnd = this.basePageBreakList.getLastMasterBreak();
            long pageHeight = pageBox.getPageHeight();
            this.paginationTableState = new PaginationTableState(pageHeight, pageBox.getPageOffset(), pageEnd, this.basePageBreakList);
            if (this.startBlockLevelBox(pageBox)) {
                this.processBoxChilds(pageBox);
            }
            this.finishBlockLevelBox(pageBox);
            PaginationStepLib.assertProgress(pageBox);
            long usedPageHeight = Math.min(pageBox.getHeight(), this.usablePageHeight);
            long masterBreak = this.basePageBreakList.getLastMasterBreak();
            boolean overflow = this.breakIndicatorEncountered != null ? (this.breakIndicatorEncountered.getY() <= pageBox.getPageOffset() ? usedPageHeight > masterBreak : true) : usedPageHeight > masterBreak;
            boolean nextPageContainsContent = pageBox.getHeight() > masterBreak;
            PaginationResult paginationResult = new PaginationResult(this.basePageBreakList, overflow, nextPageContainsContent, this.visualState);
            return paginationResult;
        }
        finally {
            this.breakIndicatorEncountered = null;
            this.paginationTableState = null;
            this.visualState = null;
            this.shiftState = null;
            this.getEventWatch().stop();
            this.getSummaryWatch().stop(true);
        }
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.processBoxChilds(box);
    }

    @Override
    protected boolean startBlockLevelBox(RenderBox box) {
        box.setOverflowAreaHeight(box.getCachedHeight());
        boolean retval = this.handleStartBlockLevelBox(box);
        this.installTableContext(box);
        return retval;
    }

    private boolean handleStartBlockLevelBox(RenderBox box) {
        this.shiftState = this.shiftStatePool.create(box, this.shiftState);
        long shift = this.shiftState.getShiftForNextChild();
        PaginationStepLib.assertBlockPosition(box, shift);
        this.handleBlockLevelBoxFinishedMarker(box, shift);
        if (!this.shiftState.isManualBreakSuspended()) {
            if (this.handleManualBreakOnBox(box, this.shiftState, this.breakPending)) {
                this.breakPending = false;
                return true;
            }
            this.breakPending = false;
        }
        RenderLength fixedPositionLength = box.getBoxDefinition().getFixedPosition();
        if (this.shiftState.isManualBreakSuspended() || RenderLength.AUTO.equals(fixedPositionLength) || this.paginationTableState.isFixedPositionProcessingSuspended()) {
            return this.handleAutomaticPagebreak(box, this.shiftState);
        }
        long boxY = box.getY();
        long shiftedBoxPosition = boxY + shift;
        long fixedPositionResolved = fixedPositionLength.resolve(this.paginationTableState.getPageHeight(), 0L);
        PageBreakPositions breakUtility = this.paginationTableState.getBreakPositions();
        long fixedPositionInFlow = breakUtility.computeFixedPositionInFlow(shiftedBoxPosition, fixedPositionResolved);
        if (fixedPositionInFlow < shiftedBoxPosition) {
            return this.handleAutomaticPagebreak(box, this.shiftState);
        }
        if (!breakUtility.isCrossingPagebreakWithFixedPosition(shiftedBoxPosition, box.getHeight(), fixedPositionResolved)) {
            return this.handleFixedPositionWithoutBreakOnBox(box, shift, fixedPositionInFlow);
        }
        long fixedPositionDelta = fixedPositionInFlow - shiftedBoxPosition;
        this.shiftState.setShift(shift + fixedPositionDelta);
        box.setY(fixedPositionInFlow);
        this.updateStateKey(box);
        return true;
    }

    private boolean handleFixedPositionWithoutBreakOnBox(RenderBox box, long shift, long fixedPositionInFlow) {
        long boxY = box.getY();
        long shiftedBoxPosition = boxY + shift;
        long fixedPositionDelta = fixedPositionInFlow - shiftedBoxPosition;
        RenderBox.BreakIndicator breakIndicator = box.getManualBreakIndicator();
        if (breakIndicator == RenderBox.BreakIndicator.INDIRECT_MANUAL_BREAK) {
            box.setY(fixedPositionInFlow);
            this.shiftState.setShift(shift + fixedPositionDelta);
            this.updateStateKey(box);
            return true;
        }
        BoxShifter.shiftBox(box, fixedPositionDelta);
        this.updateStateKeyDeep(box);
        return false;
    }

    @Override
    protected void processBlockLevelNode(RenderNode node) {
        long shift = this.shiftState.getShiftForNextChild();
        node.setY(node.getY() + shift);
        if (!this.breakPending && node.isBreakAfter()) {
            boolean bl = this.breakPending = !this.paginationTableState.isOnPageStart(node.getY());
            if (this.breakPending && logger.isDebugEnabled()) {
                logger.debug((Object)("BreakPending True for Node:isBreakAfter: " + node));
            }
        }
    }

    @Override
    protected void finishBlockLevelBox(RenderBox box) {
        this.uninstallTableContext(box);
        if (!this.breakPending && box.isBreakAfter()) {
            boolean bl = this.breakPending = !this.paginationTableState.isOnPageStart(box.getY() + box.getHeight());
            if (this.breakPending && logger.isDebugEnabled()) {
                logger.debug((Object)("BreakPending True for Box:isBreakAfter: " + box));
            }
        }
        this.shiftState = this.shiftState.pop(box.getInstanceId());
    }

    @Override
    protected boolean startCanvasLevelBox(RenderBox box) {
        box.setOverflowAreaHeight(box.getCachedHeight());
        if (box.isCommited()) {
            box.setFinishedPaginate(true);
        }
        this.installTableContext(box);
        this.shiftState = this.shiftStatePool.create(box, this.shiftState);
        this.shiftState.suspendManualBreaks();
        box.setY(box.getY() + this.shiftState.getShiftForNextChild());
        return true;
    }

    @Override
    protected void finishCanvasLevelBox(RenderBox box) {
        this.shiftState = this.shiftState.pop(box.getInstanceId());
        this.uninstallTableContext(box);
    }

    @Override
    protected boolean startRowLevelBox(RenderBox box) {
        box.setOverflowAreaHeight(box.getCachedHeight());
        if (box.isCommited()) {
            box.setFinishedPaginate(true);
        }
        this.installTableContext(box);
        this.shiftState = this.shiftStatePool.create(box, this.shiftState);
        this.shiftState.suspendManualBreaks();
        box.setY(box.getY() + this.shiftState.getShiftForNextChild());
        return true;
    }

    @Override
    protected void finishRowLevelBox(RenderBox box) {
        this.shiftState = this.shiftState.pop(box.getInstanceId());
        this.uninstallTableContext(box);
    }

    @Override
    protected boolean startTableLevelBox(RenderBox box) {
        box.setOverflowAreaHeight(box.getCachedHeight());
        if (box.getNodeType() == 270338) {
            TableSectionRenderBox sectionRenderBox = (TableSectionRenderBox)box;
            switch (sectionRenderBox.getDisplayRole()) {
                case HEADER: {
                    this.shiftState = this.shiftStatePool.create(box, this.shiftState);
                    this.paginationTableState = new PaginationTableState(this.paginationTableState);
                    this.paginationTableState.suspendVisualStateCollection(true);
                    this.startTableHeaderSection(box, sectionRenderBox);
                    return false;
                }
                case FOOTER: {
                    this.shiftState = this.shiftStatePool.create(box, this.shiftState);
                    this.paginationTableState = new PaginationTableState(this.paginationTableState);
                    this.paginationTableState.suspendVisualStateCollection(true);
                    long contextShift = this.shiftState.getShiftForNextChild();
                    BoxShifter.shiftBox(box, contextShift);
                    return false;
                }
                case BODY: {
                    return this.startBlockLevelBox(box);
                }
            }
            throw new IllegalArgumentException();
        }
        this.shiftState = this.shiftStatePool.create(box, this.shiftState);
        return true;
    }

    private RenderBox findRootBox(RenderBox box) {
        RenderBox parent = box.getParent();
        while (parent != null) {
            if (!parent.isContainsReservedContent()) {
                return box;
            }
            box = parent;
            parent = box.getParent();
        }
        return box;
    }

    private void startTableHeaderSection(RenderBox _box, TableSectionRenderBox sectionRenderBox) {
        long headerShift;
        RenderBox box = this.findRootBox(_box);
        long contextShift = this.shiftState.getShiftForNextChild();
        long pageOffset = this.paginationTableState.getPageOffset();
        long delta = pageOffset - (sectionRenderBox.getY() + contextShift);
        if (delta <= 0L) {
            BoxShifter.shiftBox(box, contextShift);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HEADER NOT SHIFTED; DELTA = " + delta + " -> " + contextShift));
            }
            sectionRenderBox.setHeaderShift(this.pageOffsetKey, 0L);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("HEADER SHIFTED; DELTA = " + delta + " -> " + contextShift));
        }
        if ((headerShift = sectionRenderBox.getHeaderShift(this.pageOffsetKey)) == 0L) {
            long previousPageOffset = this.paginationTableState.getBreakPositions().findPageStartPositionForPageEndPosition(pageOffset);
            headerShift = sectionRenderBox.getHeaderShift(previousPageOffset) + box.getHeight();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HeaderShift: " + headerShift + " <=> " + pageOffset + " ; prevOffset=" + previousPageOffset));
            }
            sectionRenderBox.setHeaderShift(this.pageOffsetKey, headerShift);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Existing HeaderShift: " + headerShift + " <=> " + pageOffset));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Table-Height before extension: " + box.getParent().getHeight()));
        }
        BoxShifter.shiftBox(box, delta);
        this.updateStateKeyDeep(box);
        this.shiftState.increaseShift(headerShift);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Table-Height after extension: " + box.getParent().getHeight()));
        }
    }

    @Override
    protected void finishTableLevelBox(RenderBox box) {
        if (box.getNodeType() == 270338) {
            TableSectionRenderBox sectionRenderBox = (TableSectionRenderBox)box;
            switch (sectionRenderBox.getDisplayRole()) {
                case HEADER: {
                    this.shiftState = this.shiftState.pop(box.getInstanceId());
                    this.paginationTableState = this.paginationTableState.pop();
                    this.paginationTableState.defineArtificialPageStart(box.getHeight() + this.paginationTableState.getPageOffset());
                    break;
                }
                case FOOTER: {
                    this.shiftState = this.shiftState.pop(box.getInstanceId());
                    this.paginationTableState = this.paginationTableState.pop();
                    break;
                }
                case BODY: {
                    this.finishBlockLevelBox(box);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return;
        }
        this.finishBlockLevelBox(box);
    }

    @Override
    protected boolean startTableSectionLevelBox(RenderBox box) {
        box.setOverflowAreaHeight(box.getCachedHeight());
        if (box.getNodeType() == 278530 && box.isOpen()) {
            this.paginationTableState = new PaginationTableState(this.paginationTableState);
            this.paginationTableState.suspendVisualStateCollection(false);
        }
        return this.startBlockLevelBox(box);
    }

    @Override
    protected void finishTableSectionLevelBox(RenderBox box) {
        if (box.getNodeType() == 278530 && box.isOpen()) {
            this.paginationTableState = this.paginationTableState.pop();
        }
        this.finishBlockLevelBox(box);
    }

    @Override
    protected boolean startTableRowLevelBox(RenderBox box) {
        box.setOverflowAreaHeight(box.getCachedHeight());
        return this.startRowLevelBox(box);
    }

    @Override
    protected void finishTableRowLevelBox(RenderBox box) {
        this.finishRowLevelBox(box);
    }

    @Override
    protected boolean startTableCellLevelBox(RenderBox box) {
        box.setOverflowAreaHeight(box.getCachedHeight());
        this.installTableContext(box);
        return this.startBlockLevelBox(box);
    }

    @Override
    protected void finishTableCellLevelBox(RenderBox box) {
        this.finishBlockLevelBox(box);
        this.uninstallTableContext(box);
    }

    @Override
    protected boolean startInlineLevelBox(RenderBox box) {
        box.setOverflowAreaHeight(box.getHeight());
        BoxShifter.shiftBox(box, this.shiftState.getShiftForNextChild());
        return false;
    }

    @Override
    protected void processInlineLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void finishInlineLevelBox(RenderBox box) {
    }

    @Override
    protected boolean startTableColLevelBox(RenderBox box) {
        return false;
    }

    @Override
    protected boolean startTableColGroupLevelBox(RenderBox box) {
        return false;
    }

    @Override
    protected void processCanvasLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void processRowLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void processOtherLevelChild(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void processTableLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void processTableRowLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void processTableSectionLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void processTableCellLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    @Override
    protected void processTableColLevelNode(RenderNode node) {
        node.setY(node.getY() + this.shiftState.getShiftForNextChild());
    }

    private void updateStateKey(RenderBox box) {
        ReportStateKey stateKey;
        if (this.paginationTableState.isVisualStateCollectionSuspended()) {
            return;
        }
        if (box.getNodeType() == 266242) {
            return;
        }
        long y = box.getY();
        if (y < this.paginationTableState.getPageEnd() && (stateKey = box.getStateKey()) != null && !stateKey.isInlineSubReportState()) {
            this.visualState = stateKey;
        }
    }

    private void updateStateKeyDeep(RenderBox box) {
        if (this.paginationTableState.isVisualStateCollectionSuspended()) {
            return;
        }
        long y = box.getY();
        if (y >= this.paginationTableState.getPageEnd()) {
            return;
        }
        ReportStateKey reportStateKey = this.findOldestProcessKeyStep.find(box);
        if (reportStateKey != null && !reportStateKey.isInlineSubReportState()) {
            this.visualState = reportStateKey;
        }
    }

    private boolean handleAutomaticPagebreak(RenderBox box, PaginationShiftState boxContext) {
        long shift = boxContext.getShiftForNextChild();
        PageBreakPositions breakUtility = this.paginationTableState.getBreakPositions();
        long boxHeightAndWidowArea = Math.max(box.getHeight(), PaginationStepLib.getWidowConstraint(box, boxContext, this.paginationTableState));
        if (!breakUtility.isCrossingPagebreak(box.getY(), boxHeightAndWidowArea, shift)) {
            RenderBox.BreakIndicator breakIndicator = box.getManualBreakIndicator();
            if (breakIndicator == RenderBox.BreakIndicator.INDIRECT_MANUAL_BREAK || box.getRestrictFinishedClearOut() == RenderBox.RestrictFinishClearOut.RESTRICTED) {
                long boxY = box.getY();
                box.setY(boxY + shift);
                this.updateStateKey(box);
                return true;
            }
            BoxShifter.shiftBox(box, shift);
            this.updateStateKeyDeep(box);
            return false;
        }
        long boxY = box.getY();
        long boxYShifted = boxY + shift;
        long nextMinorBreak = breakUtility.findNextBreakPosition(boxYShifted);
        long spaceAvailable = nextMinorBreak - boxYShifted;
        if (spaceAvailable == 0L) {
            box.setY(boxYShifted);
            this.updateStateKey(box);
            if (boxYShifted < nextMinorBreak) {
                box.markPinned(nextMinorBreak);
            }
            return true;
        }
        long spaceConsumed = PaginationStepLib.computeNonBreakableBoxHeight(box, boxContext, this.paginationTableState);
        if (spaceAvailable < spaceConsumed) {
            long nextShift = nextMinorBreak - boxY;
            long shiftDelta = nextShift - shift;
            if (shiftDelta > 0L && logger.isDebugEnabled()) {
                logger.debug((Object)("Automatic pagebreak, after orphan-opt-out: " + box));
                logger.debug((Object)("Automatic pagebreak                      : " + this.visualState));
            }
            box.setY(boxY + nextShift);
            boxContext.setShift(nextShift);
            this.updateStateKey(box);
            box.markPinned(nextMinorBreak);
            return true;
        }
        box.setY(boxYShifted);
        this.updateStateKey(box);
        return true;
    }

    private boolean handleManualBreakOnBox(RenderBox box, PaginationShiftState boxContext, boolean breakPending) {
        long fixedPositionOnNextPage;
        RenderBox.BreakIndicator breakIndicator = box.getManualBreakIndicator();
        if (breakIndicator != RenderBox.BreakIndicator.DIRECT_MANUAL_BREAK && !breakPending) {
            return false;
        }
        long shift = boxContext.getShiftForNextChild();
        if (box.getNodeType() == 530) {
            BreakMarkerRenderBox bmrb = (BreakMarkerRenderBox)box;
            long pageOffsetForMarker = bmrb.getValidityRange();
            long pageEndForOffset = this.paginationTableState.getBreakPositions().findPageEndForPageStartPosition(pageOffsetForMarker);
            if (box.getY() + shift > pageEndForOffset) {
                return false;
            }
            if (this.breakIndicatorEncountered == null || this.breakIndicatorEncountered.getY() < bmrb.getY() + shift) {
                this.breakIndicatorEncountered = bmrb;
            }
        }
        PageBreakPositions breakUtility = this.paginationTableState.getBreakPositions();
        RenderLength fixedPosition = box.getBoxDefinition().getFixedPosition();
        long fixedPositionResolved = fixedPosition.resolve(this.paginationTableState.getPageHeight(), 0L);
        long boxY = box.getY();
        long shiftedBoxY = boxY + shift;
        long nextNonShiftedMajorBreak = breakUtility.findNextMajorBreakPosition(shiftedBoxY);
        long nextMajorBreak = Math.max(nextNonShiftedMajorBreak, fixedPositionOnNextPage = breakUtility.computeFixedPositionInFlow(nextNonShiftedMajorBreak, fixedPositionResolved));
        if (nextMajorBreak < shiftedBoxY) {
            box.setY(boxY + shift);
        } else {
            long nextShift = nextMajorBreak - boxY;
            long shiftDelta = nextShift - shift;
            box.setY(boxY + nextShift);
            boxContext.setShift(nextShift);
        }
        this.updateStateKey(box);
        long pageEnd = this.paginationTableState.getPageEnd();
        if (box.getY() < pageEnd) {
            box.markPinned(pageEnd);
        }
        return true;
    }

    private void handleBlockLevelBoxFinishedMarker(RenderBox box, long shift) {
        if (box.isFinishedPaginate()) {
            return;
        }
        if (box.isCommited()) {
            box.setFinishedPaginate(true);
        } else {
            StaticBoxLayoutProperties sblp = box.getStaticBoxLayoutProperties();
            if (sblp.isAvoidPagebreakInside() || sblp.getWidows() > 0 || sblp.getOrphans() > 0) {
                long boxY = box.getY();
                PageBreakPositions breakUtility = this.paginationTableState.getBreakPositions();
                long nextMinorBreak = breakUtility.findNextBreakPosition(boxY + shift);
                long spaceAvailable = nextMinorBreak - (boxY + shift);
                if (spaceAvailable == 0L || box.isPinned()) {
                    box.setFinishedPaginate(true);
                }
            } else {
                box.setFinishedPaginate(true);
            }
        }
    }

    protected void installTableContext(RenderBox box) {
        if (box.getNodeType() != 266242) {
            return;
        }
        this.paginationTableState = new PaginationTableState(this.paginationTableState);
    }

    protected void uninstallTableContext(RenderBox box) {
        if (box.getNodeType() != 266242) {
            return;
        }
        this.paginationTableState = this.paginationTableState.pop();
    }
}

