/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.richtext;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;

public class RichTextConverterUtilities {
    private RichTextConverterUtilities() {
    }

    public static Document parseDocument(EditorKit editorKit, Object value) throws IOException, BadLocationException {
        if (value instanceof Document) {
            return (Document)value;
        }
        InputStream inputStream = RichTextConverterUtilities.convertToStream(value);
        if (inputStream != null) {
            Document doc = editorKit.createDefaultDocument();
            editorKit.read(inputStream, doc, 0);
            return doc;
        }
        Reader reader = RichTextConverterUtilities.convertToReader(value);
        if (reader != null) {
            Document doc = editorKit.createDefaultDocument();
            editorKit.read(reader, doc, 0);
            return doc;
        }
        return null;
    }

    public static boolean isValidReaderOrStream(Object o) {
        if (o instanceof byte[]) {
            return true;
        }
        if (o instanceof Blob) {
            return true;
        }
        if (o instanceof InputStream) {
            return true;
        }
        if (o instanceof char[]) {
            return true;
        }
        if (o instanceof String) {
            return true;
        }
        if (o instanceof Clob) {
            return true;
        }
        return o instanceof Reader;
    }

    public static InputStream convertToStream(Object o) throws IOException {
        if (o instanceof byte[]) {
            return new ByteArrayInputStream((byte[])o);
        }
        if (o instanceof Blob) {
            Blob b = (Blob)o;
            try {
                return b.getBinaryStream();
            }
            catch (SQLException e) {
                throw new IOException("Failed to convert from BLOB");
            }
        }
        if (o instanceof InputStream) {
            return (InputStream)o;
        }
        return null;
    }

    public static Reader convertToReader(Object o) throws IOException {
        if (o instanceof char[]) {
            return new StringReader(new String((char[])o));
        }
        if (o instanceof String) {
            return new StringReader((String)o);
        }
        if (o instanceof Clob) {
            Clob b = (Clob)o;
            try {
                return b.getCharacterStream();
            }
            catch (SQLException e) {
                throw new IOException("Failed to convert from BLOB");
            }
        }
        if (o instanceof Reader) {
            return (Reader)o;
        }
        return null;
    }

    public static Band convertToBand(StyleKey[] definedStyleKeys, ReportElement element, Element child) {
        Band b = new Band(element.getObjectID());
        ElementStyleSheet targetStyle = b.getStyle();
        ElementStyleSheet sourceStyle = element.getStyle();
        for (int i = 0; i < definedStyleKeys.length; ++i) {
            StyleKey key = definedStyleKeys[i];
            targetStyle.setStyleProperty(key, sourceStyle.getStyleProperty(key));
        }
        String[] attrNs = element.getAttributeNamespaces();
        for (int i = 0; i < attrNs.length; ++i) {
            String attrNamespace = attrNs[i];
            String[] attrNames = element.getAttributeNames(attrNamespace);
            for (int j = 0; j < attrNames.length; ++j) {
                String attrName = attrNames[j];
                Object attrValue = element.getAttribute(attrNamespace, attrName);
                b.setAttribute(attrNamespace, attrName, attrValue);
            }
        }
        b.addElement(child);
        b.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, "block");
        return b;
    }
}

