/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.filter.MessageFormatSupport;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeCore;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ResourceReference;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.formula.util.FormulaUtil;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultAttributeCore
implements AttributeCore {
    private static final String[] EMPTY = new String[0];
    private static final ResourceReference[] EMPTY_RESOURCES = new ResourceReference[0];

    @Override
    public String[] getReferencedFields(AttributeMetaData metaData, ReportElement element, Object attributeValue) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (attributeValue == null) {
            return EMPTY;
        }
        String valueRole = metaData.getValueRole();
        if ("Field".equals(valueRole)) {
            if (attributeValue instanceof String[]) {
                String[] vals = (String[])attributeValue;
                return (String[])vals.clone();
            }
            return new String[]{String.valueOf(attributeValue)};
        }
        if ("Message".equals(valueRole)) {
            String message = String.valueOf(attributeValue);
            MessageFormatSupport messageFormatSupport = new MessageFormatSupport();
            messageFormatSupport.setFormatString(message);
            return messageFormatSupport.getFields();
        }
        if ("Formula".equals(valueRole)) {
            String formula = String.valueOf(attributeValue);
            try {
                String[] objects = FormulaUtil.getReferences((String)formula);
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < objects.length; ++i) {
                    String object = objects[i];
                    if (!(object instanceof String)) continue;
                    list.add(object);
                }
                return list.toArray(new String[list.size()]);
            }
            catch (ParseException e) {
                return EMPTY;
            }
        }
        return EMPTY;
    }

    @Override
    public String[] getReferencedGroups(AttributeMetaData metaData, ReportElement element, Object attributeValue) {
        String valueRole = metaData.getValueRole();
        if (element == null) {
            throw new NullPointerException();
        }
        if (attributeValue == null) {
            return EMPTY;
        }
        if ("Group".equals(valueRole)) {
            if (attributeValue instanceof String[]) {
                String[] attrVal = (String[])attributeValue;
                return (String[])attrVal.clone();
            }
            return new String[]{String.valueOf(attributeValue)};
        }
        return EMPTY;
    }

    @Override
    public ResourceReference[] getReferencedResources(AttributeMetaData metaData, ReportElement element, ResourceManager resourceManager, Object attributeValue) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        String valueRole = metaData.getValueRole();
        if ("Content".equals(valueRole)) {
            ResourceKey contentBase = this.getContentBase(element);
            ResourceKey elementSource = this.getDefinitionSource(element);
            if (attributeValue instanceof ResourceKey) {
                ResourceKey path = (ResourceKey)attributeValue;
                boolean linked = BundleUtilities.isSameBundle((ResourceKey)elementSource, (ResourceKey)path);
                return new ResourceReference[]{new ResourceReference(path, linked)};
            }
            if (attributeValue instanceof String && contentBase != null) {
                try {
                    ResourceKey path = resourceManager.deriveKey(contentBase, String.valueOf(attributeValue));
                    boolean linked = !BundleUtilities.isSameBundle((ResourceKey)elementSource, (ResourceKey)path);
                    return new ResourceReference[]{new ResourceReference(path, linked)};
                }
                catch (ResourceKeyCreationException rce) {}
            } else if (attributeValue != null) {
                try {
                    ResourceKey path = resourceManager.createKey(attributeValue);
                    boolean linked = !BundleUtilities.isSameBundle((ResourceKey)elementSource, (ResourceKey)path);
                    return new ResourceReference[]{new ResourceReference(path, linked)};
                }
                catch (ResourceKeyCreationException rce) {
                    // empty catch block
                }
            }
        }
        return EMPTY_RESOURCES;
    }

    protected ResourceKey getDefinitionSource(ReportElement element) {
        Object o = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source");
        if (o instanceof ResourceKey) {
            return (ResourceKey)o;
        }
        Section parent = element.getParentSection();
        if (parent != null) {
            return this.getDefinitionSource(parent);
        }
        return null;
    }

    protected ResourceKey getContentBase(ReportElement element) {
        Object o = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "content-base");
        if (o instanceof ResourceKey) {
            return (ResourceKey)o;
        }
        Section parent = element.getParentSection();
        if (parent != null) {
            return this.getContentBase(parent);
        }
        return null;
    }

    @Override
    public String[] getExtraCalculationFields(AttributeMetaData metaData) {
        return new String[0];
    }
}

