/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import java.beans.PropertyEditor;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultExpressionPropertyCore;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyCore;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.SharedBeanInfo;
import org.pentaho.reporting.engine.classic.core.metadata.builder.ExpressionPropertyMetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AbstractMetaDataReadHandler;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ExpressionPropertyReadHandler
extends AbstractMetaDataReadHandler {
    private SharedBeanInfo beanInfo;
    private String bundleLocation;
    private boolean validatePropertiesOnBoot = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.metadata.StrictValidation"));
    private ExpressionPropertyMetaDataBuilder builder;

    public ExpressionPropertyReadHandler(SharedBeanInfo beanInfo, String bundleLocation) {
        this.beanInfo = beanInfo;
        this.bundleLocation = bundleLocation;
        this.builder = new ExpressionPropertyMetaDataBuilder();
    }

    public ExpressionPropertyMetaDataBuilder getBuilder() {
        return this.builder;
    }

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        this.getBuilder().mandatory("true".equals(attrs.getValue(this.getUri(), "mandatory")));
        this.getBuilder().computed("true".equals(attrs.getValue(this.getUri(), "computed")));
        this.getBuilder().valueRole(this.parseValueRole(attrs));
        this.getBuilder().editor(this.parsePropertyEditor(attrs));
        this.getBuilder().core(this.parsePropertyCore(attrs));
        this.getBuilder().bundle(this.getEffectiveBundle(), "property.");
        this.getBuilder().descriptorFromParent(this.beanInfo.getBeanClass());
        if (this.validatePropertiesOnBoot && this.beanInfo.getPropertyDescriptor(this.getName()) == null) {
            throw new ParseException("Attribute 'name' with value '" + this.getName() + "' does not reference a valid property. [" + this.beanInfo.getBeanClass() + "]", this.getLocator());
        }
    }

    private ExpressionPropertyCore parsePropertyCore(Attributes attrs) throws ParseException {
        ExpressionPropertyCore expressionPropertyCore;
        String metaDataCoreClass = attrs.getValue(this.getUri(), "impl");
        if (metaDataCoreClass != null) {
            expressionPropertyCore = (ExpressionPropertyCore)ObjectUtilities.loadAndInstantiate((String)metaDataCoreClass, ExpressionPropertyReadHandler.class, ExpressionPropertyCore.class);
            if (expressionPropertyCore == null) {
                throw new ParseException("Attribute 'impl' references a invalid ExpressionPropertyCore implementation.", this.getLocator());
            }
        } else {
            expressionPropertyCore = new DefaultExpressionPropertyCore();
        }
        return expressionPropertyCore;
    }

    private Class<? extends PropertyEditor> parsePropertyEditor(Attributes attrs) {
        String propertyEditorClass = attrs.getValue(this.getUri(), "propertyEditor");
        return ObjectUtilities.loadAndValidate((String)propertyEditorClass, ExpressionPropertyReadHandler.class, PropertyEditor.class);
    }

    private String parseValueRole(Attributes attrs) {
        String valueRole = attrs.getValue(this.getUri(), "value-role");
        if (valueRole == null) {
            valueRole = "Value";
        }
        return valueRole;
    }

    public boolean isMandatory() {
        return this.getBuilder().isMandatory();
    }

    public String getValueRole() {
        return this.getBuilder().getValueRole();
    }

    public ExpressionPropertyMetaData getObject() throws SAXException {
        return new DefaultExpressionPropertyMetaData(this.getBuilder());
    }

    public String getEffectiveBundle() {
        if (this.getBundle() != null) {
            return this.getBundle();
        }
        return this.bundleLocation;
    }
}

