/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import org.pentaho.reporting.engine.classic.core.style.TextDirection;
import org.pentaho.reporting.engine.classic.core.style.TextWrap;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.TextDirectionValueConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class TextDirectionPropertyEditor
implements PropertyEditor {
    private TextDirectionValueConverter valueConverter;
    private TextDirection value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public TextDirectionPropertyEditor() {
        this.valueConverter = new TextDirectionValueConverter();
    }

    @Override
    public void setValue(Object value) {
        TextDirection oldValue = this.value;
        this.value = TextDirection.LTR.equals(value) ? TextDirection.LTR : (TextDirection.RTL.equals(value) ? TextDirection.RTL : null);
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        if (TextDirection.LTR.equals(this.value)) {
            return TextDirection.class.getName() + ".LTR";
        }
        if (TextDirection.RTL.equals(this.value)) {
            return TextWrap.class.getName() + ".RTL";
        }
        return "null";
    }

    @Override
    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        try {
            return this.valueConverter.toAttributeValue(this.value);
        }
        catch (BeanException e) {
            return null;
        }
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)text)) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(this.valueConverter.toPropertyValue(text));
        }
        catch (BeanException e) {
            throw new IllegalArgumentException("This is not a valid property-value");
        }
    }

    @Override
    public String[] getTags() {
        return new String[]{TextDirection.LTR.toString(), TextDirection.RTL.toString()};
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

