/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters;

import java.awt.Color;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterUpdateContext;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;

public class TextComponentEditHandler
implements Runnable,
DocumentListener,
ActionListener {
    private Class type;
    private String keyName;
    private JTextComponent textComponent;
    private ParameterUpdateContext updateContext;
    private Format formatter;
    private Color color;
    private boolean inProgress;
    private boolean adjustingToExternalInput;

    public TextComponentEditHandler(Class type, String keyName, JTextComponent textComponent, ParameterUpdateContext updateContext, Format formatter) {
        this.type = type;
        this.keyName = keyName;
        this.textComponent = textComponent;
        this.updateContext = updateContext;
        this.formatter = formatter;
        this.color = this.textComponent.getBackground();
        if (this.color == null) {
            this.color = SystemColor.text;
        }
    }

    public boolean isAdjustingToExternalInput() {
        return this.adjustingToExternalInput;
    }

    public void setAdjustingToExternalInput(boolean adjustingToExternalInput) {
        this.adjustingToExternalInput = adjustingToExternalInput;
    }

    protected Class getType() {
        return this.type;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.convertParameterValue();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.convertParameterValue();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.convertParameterValue();
    }

    private void convertParameterValue() {
        if (this.inProgress) {
            return;
        }
        this.inProgress = true;
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        this.convert(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convert(boolean autoUpdate) {
        try {
            String text = this.textComponent.getText();
            this.textComponent.setBackground(this.color);
            this.updateContext.setParameterValue(this.keyName, this.convertValue(text), autoUpdate);
        }
        catch (BeanException e) {
            this.textComponent.setBackground(Color.RED);
        }
        finally {
            this.inProgress = false;
        }
    }

    protected Object convertValue(String text) throws BeanException {
        if (text == null) {
            return null;
        }
        if (this.formatter != null) {
            try {
                Object o = this.formatter.parseObject(text);
                String asText = ConverterRegistry.toAttributeValue(o);
                return ConverterRegistry.toPropertyValue(asText, this.getType());
            }
            catch (ParseException e) {
                throw new BeanException("Failed to format object");
            }
        }
        if (Object.class == this.type || String.class == this.type) {
            return text;
        }
        return ConverterRegistry.toPropertyValue(text, this.type);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.convert(true);
    }

    public static TimeZone createTimeZone(String selectedItem, TimeZone defaultValue) {
        if (selectedItem == null) {
            return defaultValue;
        }
        if ("server".equals(selectedItem) || "client".equals(selectedItem)) {
            return defaultValue;
        }
        String id = String.valueOf(selectedItem);
        if ("utc".equals(id)) {
            return TimeZone.getTimeZone("UTC");
        }
        TimeZone timeZone = TimeZone.getTimeZone(id);
        if ("GMT".equals(timeZone.getID()) && !"GMT".equals(id)) {
            return defaultValue;
        }
        return timeZone;
    }

    public static Format createFormat(String formatString, Locale locale, TimeZone timeZone, Class parameterType) {
        if (formatString == null || parameterType == null) {
            return null;
        }
        if (Number.class.isAssignableFrom(parameterType)) {
            try {
                DecimalFormat decimalFormat = new DecimalFormat(formatString, new DecimalFormatSymbols(locale));
                decimalFormat.setParseBigDecimal(true);
                return decimalFormat;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (Date.class.isAssignableFrom(parameterType)) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(formatString, locale);
                dateFormat.setLenient(false);
                dateFormat.setTimeZone(timeZone);
                return dateFormat;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }
}

