/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.tablemodel;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.layout.output.GenericOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;

public final class TableModelInfo {
    private TableModelInfo() {
    }

    public static void printTableMetaData(TableModel mod, PrintStream out) {
        if (!(mod instanceof MetaTableModel)) {
            out.println("TableModel has no meta-data.");
            return;
        }
        MetaTableModel metaTableModel = (MetaTableModel)mod;
        DataAttributes tableAttributes = metaTableModel.getTableAttributes();
        DefaultDataAttributeContext attributeContext = new DefaultDataAttributeContext(new GenericOutputProcessorMetaData(), Locale.US);
        Object[] tableAttrDomains = tableAttributes.getMetaAttributeDomains();
        Arrays.sort(tableAttrDomains);
        for (int i = 0; i < tableAttrDomains.length; ++i) {
            Object tableAttrDomain = tableAttrDomains[i];
            Object[] attributeNames = tableAttributes.getMetaAttributeNames((String)tableAttrDomain);
            Arrays.sort(attributeNames);
            for (int j = 0; j < attributeNames.length; ++j) {
                Object attributeName = attributeNames[j];
                Object o = tableAttributes.getMetaAttribute((String)tableAttrDomain, (String)attributeName, Object.class, attributeContext);
                out.println("TableAttribute [" + (String)tableAttrDomain + ':' + (String)attributeName + "]=" + TableModelInfo.format(o));
            }
        }
        for (int column = 0; column < mod.getColumnCount(); ++column) {
            DataAttributes columnAttributes = metaTableModel.getColumnAttributes(column);
            Object[] columnAttributeDomains = columnAttributes.getMetaAttributeDomains();
            Arrays.sort(columnAttributeDomains);
            for (int i = 0; i < columnAttributeDomains.length; ++i) {
                Object colAttrDomain = columnAttributeDomains[i];
                Object[] attributeNames = columnAttributes.getMetaAttributeNames((String)colAttrDomain);
                Arrays.sort(attributeNames);
                for (int j = 0; j < attributeNames.length; ++j) {
                    Object attributeName = attributeNames[j];
                    Object o = columnAttributes.getMetaAttribute((String)colAttrDomain, (String)attributeName, Object.class, attributeContext);
                    out.println("ColumnAttribute(" + column + ") [" + (String)colAttrDomain + ':' + (String)attributeName + "]=" + TableModelInfo.format(o));
                }
            }
        }
    }

    public static void printTableCellAttributes(TableModel mod, PrintStream out) {
        if (!(mod instanceof MetaTableModel)) {
            out.println("TableModel has no meta-data.");
            return;
        }
        MetaTableModel metaTableModel = (MetaTableModel)mod;
        if (!metaTableModel.isCellDataAttributesSupported()) {
            out.println("TableModel has no cell-meta-data.");
            return;
        }
        DefaultDataAttributeContext attributeContext = new DefaultDataAttributeContext(new GenericOutputProcessorMetaData(), Locale.US);
        out.println("Tablemodel contains " + mod.getRowCount() + " rows.");
        out.println("Checking the attributes inside");
        for (int rows = 0; rows < mod.getRowCount(); ++rows) {
            for (int i = 0; i < mod.getColumnCount(); ++i) {
                DataAttributes cellAttributes = metaTableModel.getCellDataAttributes(rows, i);
                Object[] columnAttributeDomains = cellAttributes.getMetaAttributeDomains();
                Arrays.sort(columnAttributeDomains);
                for (int attrDomainIdx = 0; attrDomainIdx < columnAttributeDomains.length; ++attrDomainIdx) {
                    Object colAttrDomain = columnAttributeDomains[attrDomainIdx];
                    Object[] attributeNames = cellAttributes.getMetaAttributeNames((String)colAttrDomain);
                    Arrays.sort(attributeNames);
                    for (int j = 0; j < attributeNames.length; ++j) {
                        Object attributeName = attributeNames[j];
                        Object o = cellAttributes.getMetaAttribute((String)colAttrDomain, (String)attributeName, Object.class, attributeContext);
                        out.println("CellAttribute(" + rows + ", " + i + ") [" + (String)colAttrDomain + ':' + (String)attributeName + "]=" + TableModelInfo.format(o));
                    }
                }
            }
        }
    }

    public static void printTableModel(TableModel mod, PrintStream out) {
        out.println("Tablemodel contains " + mod.getRowCount() + " rows.");
        for (int i = 0; i < mod.getColumnCount(); ++i) {
            out.println("Column: " + i + " Name=" + mod.getColumnName(i) + "; DataType=" + mod.getColumnClass(i));
        }
        out.println("Checking the data inside");
        for (int rows = 0; rows < mod.getRowCount(); ++rows) {
            for (int i = 0; i < mod.getColumnCount(); ++i) {
                Object value = mod.getValueAt(rows, i);
                Class<?> c = mod.getColumnClass(i);
                if (value == null) {
                    out.println("ValueAt (" + rows + ", " + i + ") is null");
                    continue;
                }
                if (!c.isAssignableFrom(value.getClass())) {
                    out.println("ValueAt (" + rows + ", " + i + ") is not assignable from " + c);
                    continue;
                }
                if (c.equals(Object.class)) {
                    out.println("ValueAt (" + rows + ", " + i + ") is in a generic column and is of " + "type " + value.getClass());
                    continue;
                }
                out.println("ValueAt (" + rows + ", " + i + ") is in a typed column and is of " + "type " + value.getClass());
            }
        }
    }

    public static void printTableModel(TableModel mod) {
        TableModelInfo.printTableModel(mod, System.out);
    }

    public static void printTableModelContents(TableModel mod, PrintStream out) {
        out.println("Tablemodel contains " + mod.getRowCount() + " rows.");
        for (int i = 0; i < mod.getColumnCount(); ++i) {
            out.println("Column: " + i + " Name=" + mod.getColumnName(i) + "; DataType=" + mod.getColumnClass(i));
        }
        out.println("Checking the data inside");
        for (int rows = 0; rows < mod.getRowCount(); ++rows) {
            for (int i = 0; i < mod.getColumnCount(); ++i) {
                Object value = mod.getValueAt(rows, i);
                out.println("ValueAt (" + rows + ", " + i + ") is '" + TableModelInfo.format(value) + "'");
            }
        }
    }

    private static String format(Object value) {
        if (value instanceof Float || value instanceof Double) {
            DecimalFormat fmt = new DecimalFormat("#0.0###", new DecimalFormatSymbols(Locale.US));
            return fmt.format(value);
        }
        return String.valueOf(value);
    }

    public static void printTableModelContents(TableModel mod) {
        TableModelInfo.printTableModelContents(mod, System.out);
    }
}

