/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.PageableTextOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.TextFilePrinterDriver;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public final class PlainTextReportUtil {
    private PlainTextReportUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTextFile(MasterReport report, String filename, float charsPerInch, float linesPerInch) throws IOException, ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (filename == null) {
            throw new NullPointerException();
        }
        OutputStream fout = null;
        try {
            fout = new BufferedOutputStream(new FileOutputStream(filename));
            TextFilePrinterDriver pc = new TextFilePrinterDriver(fout, charsPerInch, linesPerInch);
            String lineSeparator = report.getReportConfiguration().getConfigProperty("line.separator", "\n");
            pc.setEndOfLine(lineSeparator.toCharArray());
            pc.setEndOfPage(lineSeparator.toCharArray());
            PageableTextOutputProcessor outputProcessor = new PageableTextOutputProcessor(pc, report.getConfiguration());
            PageableReportProcessor proc = new PageableReportProcessor(report, outputProcessor);
            proc.processReport();
            proc.close();
            fout.close();
            fout = null;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void createTextFile(MasterReport report, String filename) throws IOException, ReportProcessingException {
        Configuration configuration = report.getConfiguration();
        String cpiText = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.CharsPerInch");
        String lpiText = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.LinesPerInch");
        PlainTextReportUtil.createTextFile(report, filename, ParserUtil.parseInt((String)cpiText, (int)10), ParserUtil.parseInt((String)lpiText, (int)6));
    }

    public static void createPlainText(MasterReport report, String filename) throws IOException, ReportProcessingException {
        Configuration configuration = report.getConfiguration();
        String cpiText = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.CharsPerInch");
        String lpiText = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.LinesPerInch");
        PlainTextReportUtil.createPlainText(report, filename, (float)ParserUtil.parseInt((String)cpiText, (int)10), (float)ParserUtil.parseInt((String)lpiText, (int)6));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPlainText(MasterReport report, String filename, float charsPerInch, float linesPerInch) throws IOException, ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (filename == null) {
            throw new NullPointerException();
        }
        OutputStream fout = null;
        try {
            fout = new BufferedOutputStream(new FileOutputStream(filename));
            PlainTextReportUtil.createPlainText(report, fout, charsPerInch, linesPerInch, null);
            fout.close();
            fout = null;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void createPlainText(MasterReport report, OutputStream outputStream) throws ReportProcessingException {
        Configuration configuration = report.getConfiguration();
        String cpiText = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.CharsPerInch");
        String lpiText = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.LinesPerInch");
        PlainTextReportUtil.createPlainText(report, outputStream, ParserUtil.parseInt((String)cpiText, (int)10), ParserUtil.parseInt((String)lpiText, (int)6), null);
    }

    public static void createPlainText(MasterReport report, OutputStream outputStream, float charsPerInch, float linesPerInch) throws ReportProcessingException {
        PlainTextReportUtil.createPlainText(report, outputStream, charsPerInch, linesPerInch, null);
    }

    public static void createPlainText(MasterReport report, OutputStream outputStream, float charsPerInch, float linesPerInch, String encoding) throws ReportProcessingException {
        if (report == null) {
            throw new NullPointerException();
        }
        if (outputStream == null) {
            throw new NullPointerException();
        }
        TextFilePrinterDriver pc = new TextFilePrinterDriver(outputStream, charsPerInch, linesPerInch);
        PageableTextOutputProcessor outputProcessor = new PageableTextOutputProcessor(pc, report.getConfiguration());
        outputProcessor.setEncoding(encoding);
        PageableReportProcessor proc = new PageableReportProcessor(report, outputProcessor);
        proc.processReport();
        proc.close();
    }

    public static byte[] getInitSequence(Configuration report) throws UnsupportedEncodingException {
        if (report == null) {
            throw new NullPointerException();
        }
        String encoding = report.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.RawEncoding", "Raw");
        String sequence = report.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.RawInitSequence");
        if (sequence == null) {
            return null;
        }
        if ("Raw".equalsIgnoreCase(encoding)) {
            char[] rawChars = sequence.toCharArray();
            int rawCharLength = rawChars.length;
            byte[] rawBytes = new byte[rawCharLength];
            for (int i = 0; i < rawCharLength; ++i) {
                rawBytes[i] = (byte)rawChars[i];
            }
            return rawBytes;
        }
        return sequence.getBytes(encoding);
    }
}

