/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext;

import java.awt.font.TextLayout;
import java.awt.print.Paper;
import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PhysicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnGroupNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.PhysicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.RevalidateTextEllipseProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.text.GlyphList;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.TextOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PlainTextPage;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.PrinterDriver;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;

public class TextDocumentWriter
extends IterateStructuralProcessStep {
    private PrinterDriver driver;
    private String encoding;
    private PlainTextPage plainTextPage;
    private long characterWidthInMicroPoint;
    private long characterHeightInMicroPoint;
    private StrictBounds drawArea;
    private RevalidateTextEllipseProcessStep revalidateTextEllipseProcessStep;
    private long contentAreaX1;
    private long contentAreaX2;
    private boolean textLineOverflow;
    private CodePointBuffer codePointBuffer;
    private boolean ellipseDrawn;
    private boolean clipOnWordBoundary;
    private boolean watermarkOnTop;

    public TextDocumentWriter(OutputProcessorMetaData metaData, PrinterDriver driver, String encoding) {
        if (encoding == null) {
            throw new NullPointerException();
        }
        if (driver == null) {
            throw new NullPointerException();
        }
        if (metaData == null) {
            throw new NullPointerException();
        }
        this.codePointBuffer = new CodePointBuffer(400);
        this.driver = driver;
        this.encoding = encoding;
        this.characterHeightInMicroPoint = StrictGeomUtility.toInternalValue(metaData.getNumericFeatureValue(TextOutputProcessorMetaData.CHAR_HEIGHT));
        this.characterWidthInMicroPoint = StrictGeomUtility.toInternalValue(metaData.getNumericFeatureValue(TextOutputProcessorMetaData.CHAR_WIDTH));
        if (this.characterHeightInMicroPoint <= 0L || this.characterWidthInMicroPoint <= 0L) {
            throw new IllegalStateException("Invalid character box size. Cannot continue.");
        }
        this.revalidateTextEllipseProcessStep = new RevalidateTextEllipseProcessStep(metaData);
        this.clipOnWordBoundary = "true".equals(metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.LastLineBreaksOnWordBoundary"));
        this.watermarkOnTop = metaData.isFeatureSupported(OutputProcessorFeature.WATERMARK_PRINTED_ON_TOP);
    }

    @Deprecated
    public void close() {
    }

    @Deprecated
    public void open() {
    }

    public void processPhysicalPage(PageGrid pageGrid, LogicalPageBox logicalPage, int row, int col, PhysicalPageKey pageKey) throws IOException {
        PhysicalPageBox page = pageGrid.getPage(row, col);
        Paper paper = new Paper();
        paper.setSize(StrictGeomUtility.toExternalValue(page.getWidth()), StrictGeomUtility.toExternalValue(page.getHeight()));
        paper.setImageableArea(StrictGeomUtility.toExternalValue(page.getImageableX()), StrictGeomUtility.toExternalValue(page.getImageableY()), StrictGeomUtility.toExternalValue(page.getImageableWidth()), StrictGeomUtility.toExternalValue(page.getImageableHeight()));
        this.drawArea = new StrictBounds(page.getGlobalX(), page.getGlobalY(), page.getWidth(), page.getHeight());
        this.plainTextPage = new PlainTextPage(paper, this.driver, this.encoding);
        this.processPageBox(logicalPage);
        this.plainTextPage.writePage();
    }

    public void processLogicalPage(LogicalPageKey key, LogicalPageBox logicalPage) throws IOException {
        Paper paper = new Paper();
        paper.setSize(StrictGeomUtility.toExternalValue(logicalPage.getPageWidth()), StrictGeomUtility.toExternalValue(logicalPage.getPageHeight()));
        paper.setImageableArea(0.0, 0.0, StrictGeomUtility.toExternalValue(logicalPage.getPageWidth()), StrictGeomUtility.toExternalValue(logicalPage.getPageHeight()));
        paper.setSize(logicalPage.getPageWidth(), logicalPage.getPageHeight());
        paper.setImageableArea(0.0, 0.0, logicalPage.getPageWidth(), logicalPage.getPageHeight());
        this.drawArea = new StrictBounds(0L, 0L, logicalPage.getWidth(), logicalPage.getHeight());
        this.plainTextPage = new PlainTextPage(paper, this.driver, this.encoding);
        this.processPageBox(logicalPage);
        this.plainTextPage.writePage();
    }

    protected void processPageBox(LogicalPageBox box) {
        if (this.startBlockBox(box)) {
            if (!this.watermarkOnTop) {
                this.startProcessing(box.getWatermarkArea());
            }
            this.startProcessing(box.getHeaderArea());
            this.processBoxChilds(box);
            this.startProcessing(box.getRepeatFooterArea());
            this.startProcessing(box.getFooterArea());
            if (this.watermarkOnTop) {
                this.startProcessing(box.getWatermarkArea());
            }
        }
        this.finishBlockBox(box);
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        return this.startBox(box);
    }

    @Override
    public boolean startCanvasBox(CanvasRenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected boolean startRowBox(RenderBox box) {
        return this.startBox(box);
    }

    protected boolean startBox(RenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        return box.isBoxVisible(this.drawArea);
    }

    @Override
    protected boolean startTableCellBox(TableCellRenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected boolean startTableRowBox(TableRowRenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected boolean startTableSectionBox(TableSectionRenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected boolean startTableColumnGroupBox(TableColumnGroupNode box) {
        return this.startBox(box);
    }

    @Override
    protected boolean startTableBox(TableRenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected boolean startOtherBox(RenderBox box) {
        return this.startBox(box);
    }

    @Override
    protected boolean startAutoBox(RenderBox box) {
        return this.startBox(box);
    }

    protected void drawText(RenderableText renderableText) {
        this.drawText(renderableText, renderableText.getX() + renderableText.getWidth());
    }

    protected void drawText(RenderableText text, long contentX2) {
        if (!text.isNodeVisible(this.drawArea)) {
            return;
        }
        if (text.getLength() == 0) {
            return;
        }
        GlyphList gs = text.getGlyphs();
        int maxLength = text.computeMaximumTextSize(contentX2);
        String rawText = gs.getText(text.getOffset(), maxLength, this.codePointBuffer);
        int x = PlainTextPage.correctedDivisionFloor(text.getX() - this.drawArea.getX(), this.characterWidthInMicroPoint);
        int y = PlainTextPage.correctedDivisionFloor(text.getY() - this.drawArea.getY(), this.characterHeightInMicroPoint);
        int w = Math.min(maxLength, PlainTextPage.correctedDivisionFloor(text.getWidth(), this.characterWidthInMicroPoint));
        if (x + w > this.plainTextPage.getWidth()) {
            w = Math.max(0, this.plainTextPage.getWidth() - x);
        }
        if (w == 0) {
            return;
        }
        if (y < 0) {
            return;
        }
        if (y >= this.plainTextPage.getHeight()) {
            return;
        }
        this.plainTextPage.addTextChunk(x, y, w, rawText, text.getStyleSheet());
    }

    protected void drawComplexText(RenderNode node) {
        RenderableComplexText renderableComplexText = (RenderableComplexText)node;
        if (!renderableComplexText.isNodeVisible(this.drawArea)) {
            return;
        }
        if (renderableComplexText.getRawText().length() == 0) {
            return;
        }
        TextLayout textLayout = renderableComplexText.getTextLayout();
        String debugInfo = textLayout.toString();
        String startPos = debugInfo.substring(debugInfo.indexOf("[start:"), debugInfo.indexOf(", len:")).replace("[start:", "");
        int startPosIntValue = -1;
        try {
            startPosIntValue = Integer.parseInt(startPos);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String text = renderableComplexText.getRawText().length() > textLayout.getCharacterCount() && startPosIntValue >= 0 ? renderableComplexText.getRawText().substring(startPosIntValue, textLayout.getCharacterCount() + startPosIntValue) : renderableComplexText.getRawText();
        int x = PlainTextPage.correctedDivisionFloor(renderableComplexText.getX() - this.drawArea.getX(), this.characterWidthInMicroPoint);
        int y = PlainTextPage.correctedDivisionFloor(renderableComplexText.getY() - this.drawArea.getY(), this.characterHeightInMicroPoint);
        int w = text.length();
        if (x + w > this.plainTextPage.getWidth()) {
            w = Math.max(0, this.plainTextPage.getWidth() - x);
        }
        if (w == 0) {
            return;
        }
        if (y < 0) {
            return;
        }
        if (y >= this.plainTextPage.getHeight()) {
            return;
        }
        this.plainTextPage.addTextChunk(x, y, w, text, renderableComplexText.getStyleSheet());
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        if (!(node.getNodeType() == 17) && !(node.getNodeType() == 273)) {
            return;
        }
        if (this.isTextLineOverflow()) {
            if (!node.isNodeVisible(this.drawArea)) {
                return;
            }
            if (!this.clipOnWordBoundary) {
                long x1;
                RenderNode text;
                if (node.getNodeType() == 17) {
                    text = (RenderableText)node;
                    long ellipseSize = this.extractEllipseSize(node);
                    long x12 = text.getX();
                    long effectiveAreaX2 = this.contentAreaX2 - ellipseSize;
                    if (x12 < this.contentAreaX2) {
                        this.drawText((RenderableText)text, effectiveAreaX2);
                    }
                } else if (node.getNodeType() == 273 && (x1 = (text = (RenderableComplexText)node).getX()) < this.contentAreaX2) {
                    this.drawComplexText(node);
                }
            }
            if (node.isVirtualNode()) {
                RenderBox textEllipseBox;
                if (this.ellipseDrawn) {
                    return;
                }
                this.ellipseDrawn = true;
                RenderBox parent = node.getParent();
                if (parent != null && (textEllipseBox = parent.getTextEllipseBox()) != null) {
                    this.processBoxChilds(textEllipseBox);
                }
                return;
            }
        }
        if (this.isTextLineOverflow()) {
            long effectiveAreaX2;
            if (!node.isNodeVisible(this.drawArea)) {
                return;
            }
            long ellipseSize = this.extractEllipseSize(node);
            long x1 = node.getX();
            long x2 = x1 + node.getWidth();
            if (x2 <= (effectiveAreaX2 = this.contentAreaX2 - ellipseSize)) {
                if (node.getNodeType() == 17) {
                    this.drawText((RenderableText)node);
                } else if (node.getNodeType() == 273) {
                    this.drawComplexText(node);
                }
            } else if (x1 < this.contentAreaX2) {
                RenderBox textEllipseBox;
                if (node.getNodeType() == 17) {
                    this.drawText((RenderableText)node, effectiveAreaX2);
                } else if (node.getNodeType() == 273) {
                    this.drawComplexText(node);
                }
                RenderBox parent = node.getParent();
                if (parent != null && (textEllipseBox = parent.getTextEllipseBox()) != null) {
                    this.processBoxChilds(textEllipseBox);
                }
            }
        } else if (node.getNodeType() == 17) {
            this.drawText((RenderableText)node);
        } else if (node.getNodeType() == 273) {
            this.drawComplexText(node);
        }
    }

    private long extractEllipseSize(RenderNode node) {
        if (node == null) {
            return 0L;
        }
        RenderBox parent = node.getParent();
        if (parent == null) {
            return 0L;
        }
        RenderBox textEllipseBox = parent.getTextEllipseBox();
        if (textEllipseBox == null) {
            return 0L;
        }
        return textEllipseBox.getWidth();
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.contentAreaX1 = box.getContentAreaX1();
        this.contentAreaX2 = box.getContentAreaX2();
        for (RenderBox lineBox = (RenderBox)box.getFirstChild(); lineBox != null; lineBox = (RenderBox)lineBox.getNext()) {
            this.processTextLine(lineBox, this.contentAreaX1, this.contentAreaX2);
        }
    }

    protected void processTextLine(RenderBox lineBox, long contentAreaX1, long contentAreaX2) {
        boolean overflowProperty = lineBox.getParent().getStaticBoxLayoutProperties().isOverflowX();
        this.textLineOverflow = lineBox.getX() + lineBox.getWidth() > contentAreaX2 && !overflowProperty;
        this.ellipseDrawn = false;
        if (this.textLineOverflow) {
            this.revalidateTextEllipseProcessStep.compute(lineBox, contentAreaX1, contentAreaX2);
        }
        this.startProcessing(lineBox);
    }

    public long getContentAreaX2() {
        return this.contentAreaX2;
    }

    public void setContentAreaX2(long contentAreaX2) {
        this.contentAreaX2 = contentAreaX2;
    }

    public long getContentAreaX1() {
        return this.contentAreaX1;
    }

    public void setContentAreaX1(long contentAreaX1) {
        this.contentAreaX1 = contentAreaX1;
    }

    public boolean isTextLineOverflow() {
        return this.textLineOverflow;
    }

    public void setTextLineOverflow(boolean textLineOverflow) {
        this.textLineOverflow = textLineOverflow;
    }
}

