/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper;

import java.io.IOException;
import java.text.NumberFormat;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DefaultImageReference;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.URLImageContainer;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.imagemap.parser.ImageMapWriter;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlContentGenerator;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.DefaultStyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlOutputProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlTagHelper;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.HtmlTextExtractorState;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilderFactory;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class HtmlTextExtractorHelper {
    private static final String DIV_TAG = "div";
    private static final String HREF_ATTR = "href";
    private static final String TARGET_ATTR = "target";
    private static final String TITLE_ATTR = "title";
    private static final String A_TAG = "a";
    private static final String BR_TAG = "br";
    private static final String SPAN_TAG = "span";
    private static final String IMG_TAG = "img";
    private static final String SRC_ATTR = "src";
    private static final String USEMAP_ATTR = "usemap";
    private static final String PT_UNIT = "pt";
    private static final String PX_UNIT = "px";
    private static final String ALT_ATTR = "alt";
    private HtmlTextExtractorState processStack;
    private InstanceID firstElement;
    private XmlWriter xmlWriter;
    private HtmlTagHelper tagHelper;
    private OutputProcessorMetaData metaData;
    private boolean enableInheritedLinkStyle;
    private HtmlContentGenerator contentGenerator;

    public HtmlTextExtractorHelper(HtmlTagHelper tagHelper, XmlWriter xmlWriter, OutputProcessorMetaData metaData, HtmlContentGenerator contentGenerator) {
        ArgumentNullException.validate((String)"tagHelper", (Object)tagHelper);
        ArgumentNullException.validate((String)"metaData", (Object)metaData);
        ArgumentNullException.validate((String)"contentGenerator", (Object)contentGenerator);
        ArgumentNullException.validate((String)"xmlWriter", (Object)xmlWriter);
        this.tagHelper = tagHelper;
        this.metaData = metaData;
        this.contentGenerator = contentGenerator;
        this.enableInheritedLinkStyle = "true".equals(ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.LinksInheritStyle"));
        this.xmlWriter = xmlWriter;
    }

    public boolean isEnableInheritedLinkStyle() {
        return this.enableInheritedLinkStyle;
    }

    public void setFirstElement(InstanceID firstElement, HtmlTextExtractorState processStack) {
        this.firstElement = firstElement;
        this.processStack = processStack;
    }

    public boolean startBox(InstanceID box, ReportAttributeMap attrs, StyleSheet styleSheet, BoxDefinition boxDefinition, boolean forceTag) {
        return this.startBox(box, attrs, styleSheet, boxDefinition, forceTag, DIV_TAG);
    }

    public boolean startInlineBox(InstanceID box, ReportAttributeMap attrs, StyleSheet styleSheet, BoxDefinition boxDefinition) {
        return this.startBox(box, attrs, styleSheet, boxDefinition, true, SPAN_TAG);
    }

    private boolean startBox(InstanceID box, ReportAttributeMap attrs, StyleSheet styleSheet, BoxDefinition boxDefinition, boolean forceTag, String tag) {
        try {
            if (this.firstElement != box) {
                AttributeList attrList = new AttributeList();
                HtmlTagHelper.applyHtmlAttributes(attrs, attrList);
                StyleBuilder styleBuilder = this.tagHelper.getStyleBuilder();
                StyleBuilder style = this.tagHelper.getStyleBuilderFactory().produceTextStyle(styleBuilder, styleSheet, boxDefinition, true, this.processStack.getStyle());
                this.tagHelper.getStyleManager().updateStyle(style, attrList);
                if (forceTag || !attrList.isEmpty()) {
                    this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", tag, attrList, false);
                    this.processStack = new HtmlTextExtractorState(this.processStack, true);
                } else {
                    this.processStack = new HtmlTextExtractorState(this.processStack, true);
                }
                this.writeLocalAnchor(styleSheet);
                Object rawContent = attrs.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-content");
                if (rawContent != null) {
                    this.xmlWriter.writeText(String.valueOf(rawContent));
                }
            } else {
                this.processStack = new HtmlTextExtractorState(this.processStack, false);
            }
            String target = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TARGET);
            if (target != null) {
                this.handleLinkOnElement(styleSheet, target);
                this.processStack = new HtmlTextExtractorState(this.processStack, true);
            } else {
                this.processStack = new HtmlTextExtractorState(this.processStack, false);
            }
            return !Boolean.TRUE.equals(attrs.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "surpress-content"));
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    public void finishBox(InstanceID box, ReportAttributeMap<Object> attributes) {
        try {
            Object rawFooterContent;
            if (this.processStack.isWrittenTag()) {
                this.xmlWriter.writeCloseTag();
            }
            this.processStack = this.processStack.getParent();
            if (this.firstElement != box && (rawFooterContent = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-footer-content")) != null) {
                this.xmlWriter.writeText(String.valueOf(rawFooterContent));
            }
            if (this.processStack.isWrittenTag()) {
                this.xmlWriter.writeCloseTag();
            }
            this.processStack = this.processStack.getParent();
        }
        catch (IOException e) {
            throw new HtmlOutputProcessingException("Failed to perform IO", e);
        }
    }

    public void writeLocalAnchor(StyleSheet styleSheet) throws IOException {
        String anchor = (String)styleSheet.getStyleProperty(ElementStyleKeys.ANCHOR_NAME);
        if (anchor != null) {
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", A_TAG, "name", anchor, true);
        }
    }

    public void handleLinkOnElement(StyleSheet styleSheet, String target) throws IOException {
        String title;
        String window = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_WINDOW);
        AttributeList linkAttr = new AttributeList();
        linkAttr.setAttribute("http://www.w3.org/1999/xhtml", HREF_ATTR, target);
        if (window != null && !StringUtils.startsWithIgnoreCase((String)target, (String)"javascript:")) {
            linkAttr.setAttribute("http://www.w3.org/1999/xhtml", TARGET_ATTR, this.normalizeWindow(window));
        }
        if ((title = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TITLE)) != null) {
            linkAttr.setAttribute("http://www.w3.org/1999/xhtml", TITLE_ATTR, title);
        }
        if (this.enableInheritedLinkStyle) {
            StyleBuilder styleBuilder = this.createLinkStyle(this.tagHelper.getStyleBuilder());
            this.tagHelper.getStyleManager().updateStyle(styleBuilder, linkAttr);
        }
        this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", A_TAG, linkAttr, false);
    }

    private String normalizeWindow(String window) {
        if ("_top".equalsIgnoreCase(window)) {
            return "_top";
        }
        if ("_self".equalsIgnoreCase(window)) {
            return "_self";
        }
        if ("_parent".equalsIgnoreCase(window)) {
            return "_parent";
        }
        if ("_blank".equalsIgnoreCase(window)) {
            return "_blank";
        }
        return window;
    }

    private StyleBuilder createLinkStyle(StyleBuilder b) {
        if (b == null) {
            b = new DefaultStyleBuilder(this.tagHelper.getStyleBuilderFactory());
        }
        b.append(StyleBuilder.CSSKeys.FONT_STYLE, "inherit");
        b.append(StyleBuilder.CSSKeys.FONT_FAMILY, "inherit");
        b.append(StyleBuilder.CSSKeys.FONT_WEIGHT, "inherit");
        b.append(StyleBuilder.CSSKeys.FONT_SIZE, "inherit");
        b.append(StyleBuilder.CSSKeys.TEXT_DECORATION, "inherit");
        b.append(StyleBuilder.CSSKeys.COLOR, "inherit");
        return b;
    }

    public StyleBuilder produceClipStyle(long nodeWidth, long nodeHeight) {
        StyleBuilder styleBuilder = this.tagHelper.getStyleBuilder();
        styleBuilder.clear();
        StyleBuilderFactory styleBuilderFactory = this.tagHelper.getStyleBuilderFactory();
        NumberFormat pointConverter = styleBuilder.getPointConverter();
        styleBuilder.append(StyleBuilder.CSSKeys.OVERFLOW, "hidden");
        styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, pointConverter.format(styleBuilderFactory.fixLengthForSafari(StrictGeomUtility.toExternalValue(nodeWidth))), PT_UNIT);
        styleBuilder.append(StyleBuilder.CSSKeys.HEIGHT, pointConverter.format(styleBuilderFactory.fixLengthForSafari(StrictGeomUtility.toExternalValue(nodeHeight))), PT_UNIT);
        return styleBuilder;
    }

    public StyleBuilder produceImageStyle(StyleSheet styleSheet, long nodeWidth, long nodeHeight, long contentWidth, long contentHeight) {
        StyleBuilder styleBuilder = this.tagHelper.getStyleBuilder();
        styleBuilder.clear();
        StyleBuilderFactory styleBuilderFactory = this.tagHelper.getStyleBuilderFactory();
        NumberFormat pointConverter = styleBuilder.getPointConverter();
        double scale = RenderUtility.getNormalizationScale(this.metaData);
        if (styleSheet.getBooleanStyleProperty(ElementStyleKeys.SCALE)) {
            if (styleSheet.getBooleanStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO) && contentWidth > 0L && contentHeight > 0L) {
                double scaleFactor = Math.min((double)nodeWidth / (double)contentWidth, (double)nodeHeight / (double)contentHeight);
                styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, pointConverter.format(styleBuilderFactory.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)contentWidth * scaleFactor * scale)))), PX_UNIT);
                styleBuilder.append(StyleBuilder.CSSKeys.HEIGHT, pointConverter.format(styleBuilderFactory.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)contentHeight * scaleFactor * scale)))), PX_UNIT);
            } else {
                styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, pointConverter.format(styleBuilderFactory.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)nodeWidth * scale)))), PX_UNIT);
                styleBuilder.append(StyleBuilder.CSSKeys.HEIGHT, pointConverter.format(styleBuilderFactory.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)nodeHeight * scale)))), PX_UNIT);
            }
        } else {
            if (contentWidth > nodeWidth || contentHeight > nodeHeight) {
                return null;
            }
            if (contentWidth == 0L && contentHeight == 0L) {
                styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, pointConverter.format(styleBuilderFactory.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)nodeWidth * scale)))), PX_UNIT);
                styleBuilder.append(StyleBuilder.CSSKeys.HEIGHT, pointConverter.format(styleBuilderFactory.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)nodeHeight * scale)))), PX_UNIT);
            } else {
                long width = Math.min(nodeWidth, contentWidth);
                long height = Math.min(nodeHeight, contentHeight);
                styleBuilder.append(StyleBuilder.CSSKeys.WIDTH, pointConverter.format(styleBuilderFactory.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)width * scale)))), PX_UNIT);
                styleBuilder.append(StyleBuilder.CSSKeys.HEIGHT, pointConverter.format(styleBuilderFactory.fixLengthForSafari(StrictGeomUtility.toExternalValue((long)((double)height * scale)))), PX_UNIT);
            }
        }
        return styleBuilder;
    }

    public boolean processRenderableReplacedContent(ReportAttributeMap attrs, StyleSheet styleSheet, long width, long height, long contentWidth, long contentHeight, Object rawObject) throws ContentIOException, IOException {
        if (rawObject instanceof ImageContainer) {
            if (rawObject instanceof URLImageContainer && this.tryHandleUrlImage(styleSheet, width, height, contentWidth, contentHeight, (URLImageContainer)rawObject)) {
                return true;
            }
            return this.tryHandleLocalImageContainer(styleSheet, attrs, width, height, contentWidth, contentHeight, (ImageContainer)rawObject);
        }
        if (rawObject instanceof DrawableWrapper) {
            return this.tryHandleDrawable(attrs, width, height, contentWidth, contentHeight, styleSheet, (DrawableWrapper)rawObject);
        }
        return false;
    }

    private boolean tryHandleDrawable(ReportAttributeMap attrs, long width, long height, long contentWidth, long contentHeight, StyleSheet styleSheet, DrawableWrapper drawable) throws ContentIOException, IOException {
        Object altText;
        float quality;
        StrictBounds cb = new StrictBounds(0L, 0L, width, height);
        DefaultImageReference image = RenderUtility.createImageFromDrawable(drawable, cb, styleSheet, this.metaData);
        if (image == null) {
            return false;
        }
        String type = RenderUtility.getEncoderType(attrs);
        String name = this.contentGenerator.writeImage(image, type, quality = RenderUtility.getEncoderQuality(attrs), true);
        if (name == null) {
            return false;
        }
        AttributeList attrList = new AttributeList();
        attrList.setAttribute("http://www.w3.org/1999/xhtml", SRC_ATTR, name);
        attrList.setAttribute("http://www.w3.org/1999/xhtml", "border", "0");
        Object titleText = attrs.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", TITLE_ATTR);
        if (titleText != null) {
            attrList.setAttribute("http://www.w3.org/1999/xhtml", TITLE_ATTR, String.valueOf(titleText));
        }
        if ((altText = attrs.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", ALT_ATTR)) != null) {
            attrList.setAttribute("http://www.w3.org/1999/xhtml", ALT_ATTR, String.valueOf(altText));
        }
        ImageMap imageMap = this.extractImageMap(attrs, drawable, width, height, name, attrList);
        this.writeImageTag(styleSheet, width, height, contentWidth, contentHeight, attrList);
        if (imageMap != null) {
            ImageMapWriter.writeImageMap(this.xmlWriter, imageMap, RenderUtility.getNormalizationScale(this.metaData));
        }
        return true;
    }

    private ImageMap extractImageMap(ReportAttributeMap attributes, Object rawObject, long width, long height, String name, AttributeList attrList) {
        ImageMap imageMap;
        Object imageMapNameOverride = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", USEMAP_ATTR);
        if (imageMapNameOverride != null) {
            attrList.setAttribute("http://www.w3.org/1999/xhtml", USEMAP_ATTR, String.valueOf(imageMapNameOverride));
            imageMap = null;
        } else {
            imageMap = RenderUtility.extractImageMap(attributes, rawObject, width, height);
            if (imageMap != null) {
                String mapName = imageMap.getAttribute("http://www.w3.org/1999/xhtml", "name");
                if (mapName != null) {
                    attrList.setAttribute("http://www.w3.org/1999/xhtml", USEMAP_ATTR, "#" + mapName);
                } else {
                    String generatedName = "generated_" + name + "_map";
                    imageMap.setAttribute("http://www.w3.org/1999/xhtml", "name", generatedName);
                    attrList.setAttribute("http://www.w3.org/1999/xhtml", USEMAP_ATTR, '#' + generatedName);
                }
            }
        }
        return imageMap;
    }

    private boolean tryHandleLocalImageContainer(StyleSheet styleSheet, ReportAttributeMap attributes, long width, long height, long contentWidth, long contentHeight, ImageContainer rawObject) throws ContentIOException, IOException {
        Object altText;
        float quality;
        String type = RenderUtility.getEncoderType(attributes);
        String name = this.contentGenerator.writeImage(rawObject, type, quality = RenderUtility.getEncoderQuality(attributes), true);
        if (name == null) {
            return false;
        }
        AttributeList attrList = new AttributeList();
        attrList.setAttribute("http://www.w3.org/1999/xhtml", SRC_ATTR, name);
        attrList.setAttribute("http://www.w3.org/1999/xhtml", "border", "0");
        Object titleText = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", TITLE_ATTR);
        if (titleText != null) {
            attrList.setAttribute("http://www.w3.org/1999/xhtml", TITLE_ATTR, String.valueOf(titleText));
        }
        if ((altText = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", ALT_ATTR)) != null) {
            attrList.setAttribute("http://www.w3.org/1999/xhtml", ALT_ATTR, String.valueOf(altText));
        }
        this.writeImageTag(styleSheet, width, height, contentWidth, contentHeight, attrList);
        ImageMap imageMap = this.extractImageMap(attributes, null, width, height, name, attrList);
        if (imageMap != null) {
            ImageMapWriter.writeImageMap(this.xmlWriter, imageMap, RenderUtility.getNormalizationScale(this.metaData));
        }
        return true;
    }

    private boolean tryHandleUrlImage(StyleSheet styleSheet, long width, long height, long contentWidth, long contentHeight, URLImageContainer urlImageContainer) throws ContentIOException, IOException {
        ResourceKey source = urlImageContainer.getResourceKey();
        if (source != null) {
            if (!this.contentGenerator.isRegistered(source)) {
                String name = this.contentGenerator.writeRaw(source);
                if (name != null) {
                    AttributeList attrList = new AttributeList();
                    attrList.setAttribute("http://www.w3.org/1999/xhtml", SRC_ATTR, name);
                    attrList.setAttribute("http://www.w3.org/1999/xhtml", "border", "0");
                    this.writeImageTag(styleSheet, width, height, contentWidth, contentHeight, attrList);
                    this.contentGenerator.registerContent(source, name);
                    return true;
                }
                this.contentGenerator.registerFailure(source);
            } else {
                String cachedName = this.contentGenerator.getRegisteredName(source);
                if (cachedName != null) {
                    AttributeList attrList = new AttributeList();
                    attrList.setAttribute("http://www.w3.org/1999/xhtml", SRC_ATTR, cachedName);
                    attrList.setAttribute("http://www.w3.org/1999/xhtml", "border", "0");
                    this.writeImageTag(styleSheet, width, height, contentWidth, contentHeight, attrList);
                    return true;
                }
            }
        }
        return false;
    }

    private void writeImageTag(StyleSheet styleSheet, long width, long height, long contentWidth, long contentHeight, AttributeList attrList) throws IOException {
        StyleBuilder imgStyle = this.produceImageStyle(styleSheet, width, height, contentWidth, contentHeight);
        if (imgStyle == null) {
            AttributeList clipAttrList = new AttributeList();
            StyleBuilder divStyle = this.produceClipStyle(width, height);
            this.tagHelper.getStyleManager().updateStyle(divStyle, clipAttrList);
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", DIV_TAG, clipAttrList, false);
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", IMG_TAG, attrList, true);
            this.xmlWriter.writeCloseTag();
        } else {
            this.tagHelper.getStyleManager().updateStyle(imgStyle, attrList);
            this.xmlWriter.writeTag("http://www.w3.org/1999/xhtml", IMG_TAG, attrList, true);
        }
    }
}

