/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html.util;

public final class HtmlEncoderUtil {
    private static final String[] HEX_CSS_ENCODING = new String[256];

    private HtmlEncoderUtil() {
    }

    public static String encodeCSS(String s) {
        StringBuffer sbuf = new StringBuffer(s.length() * 15 / 10);
        return HtmlEncoderUtil.encodeCSS(s, sbuf);
    }

    public static String encodeCSS(String s, StringBuffer sbuf) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '\"') {
                sbuf.append('\\');
                sbuf.append(ch);
                continue;
            }
            if (ch >= ' ' && ch <= '\u007f') {
                sbuf.append(ch);
                continue;
            }
            sbuf.append('\\');
            sbuf.append(HEX_CSS_ENCODING[ch >> 16 & 0xFF]);
            sbuf.append(HEX_CSS_ENCODING[ch >> 8 & 0xFF]);
            sbuf.append(HEX_CSS_ENCODING[ch & 0xFF]);
        }
        return sbuf.toString();
    }

    static {
        for (int i = 0; i < 256; ++i) {
            String s = Integer.toHexString(i);
            HtmlEncoderUtil.HEX_CSS_ENCODING[i] = s.length() == 1 ? '0' + s : s;
        }
    }
}

