/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.function.Expression;

class IndirectIndexIterator<T extends Expression>
implements Iterator<T> {
    private int[] indices;
    private Expression[] expressions;
    private int index;

    IndirectIndexIterator(int[] indices, Expression[] expressions) {
        if (indices == null) {
            throw new IllegalStateException();
        }
        if (expressions == null) {
            throw new IllegalStateException();
        }
        this.indices = indices;
        this.expressions = expressions;
        this.index = 0;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.indices.length;
    }

    @Override
    public T next() {
        int indexForExpression = this.indices[this.index];
        Expression value = this.expressions[indexForExpression];
        ++this.index;
        return (T)value;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

