/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginCrosstabColumnAxisHandler;
import org.pentaho.reporting.engine.classic.core.states.process.EndCrosstabColumnBodyHandler;
import org.pentaho.reporting.engine.classic.core.states.process.EndCrosstabRowBodyHandler;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class JoinEndCrosstabColumnAxisHandler
implements AdvanceHandler {
    public static final AdvanceHandler HANDLER = new JoinEndCrosstabColumnAxisHandler();

    @Override
    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        return state.deriveForAdvance();
    }

    private boolean isRootGroup(ProcessState state) {
        return state.getCurrentGroupIndex() == -1;
    }

    @Override
    public ProcessState commit(ProcessState next) throws ReportProcessingException {
        next.leaveGroup();
        DefaultFlowController fc = next.getFlowController();
        boolean advanceRequested = fc.isAdvanceRequested();
        boolean advanceable = fc.getMasterRow().isAdvanceable();
        if (this.isRootGroup(next)) {
            throw new ReportProcessingException("This report is invalid. A CR-Col-Group cannot be a root group.");
        }
        Group parentGroup = next.getReport().getGroup(next.getCurrentGroupIndex());
        if (!advanceRequested || !advanceable) {
            if (parentGroup instanceof CrosstabRowGroup) {
                next.setAdvanceHandler(EndCrosstabRowBodyHandler.HANDLER);
            } else if (parentGroup instanceof CrosstabColumnGroup) {
                next.setAdvanceHandler(EndCrosstabColumnBodyHandler.HANDLER);
            } else {
                throw new ReportProcessingException("This report is invalid.");
            }
            return next;
        }
        DefaultFlowController cfc = fc.performCommit();
        if (ProcessState.isLastItemInGroup(parentGroup, fc.getMasterRow(), cfc.getMasterRow())) {
            if (parentGroup instanceof CrosstabRowGroup) {
                next.setAdvanceHandler(EndCrosstabRowBodyHandler.HANDLER);
            } else if (parentGroup instanceof CrosstabColumnGroup) {
                next.setAdvanceHandler(EndCrosstabColumnBodyHandler.HANDLER);
            } else {
                throw new ReportProcessingException("This report is invalid.");
            }
            return next;
        }
        next.setFlowController(cfc);
        next.setAdvanceHandler(BeginCrosstabColumnAxisHandler.HANDLER);
        return next;
    }

    @Override
    public boolean isFinish() {
        return false;
    }

    @Override
    public int getEventCode() {
        return -2147417984;
    }

    @Override
    public boolean isRestoreHandler() {
        return false;
    }
}

