/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util.beans;

import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;

public class ByteValueConverter
implements ValueConverter {
    @Override
    public String toAttributeValue(Object o) throws BeanException {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o instanceof Byte) {
            return o.toString();
        }
        throw new BeanException("Failed to convert unknown object: " + o);
    }

    @Override
    public Object toPropertyValue(String s) throws BeanException {
        if (s == null) {
            throw new NullPointerException();
        }
        String val = s.trim();
        if (val.length() == 0) {
            throw BeanException.getInstance("Failed to convert empty string to number", null);
        }
        try {
            return new Byte(val);
        }
        catch (NumberFormatException be) {
            throw BeanException.getInstance("Failed to parse number", be);
        }
    }
}

