/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.io.WritableUtils;

public final class WriteBuffers
implements ByteStream.RandomAccessOutput {
    private final ArrayList<byte[]> writeBuffers = new ArrayList(1);
    private final int wbSize;
    private final long maxSize;
    private byte[] currentWriteBuffer;
    private int currentWriteBufferIndex;
    private int currentWriteOffset = 0;
    private byte[] currentReadBuffer = null;
    private int currentReadBufferIndex = 0;
    private int currentReadOffset = 0;

    public WriteBuffers(int wbSize, long maxSize) {
        this.wbSize = wbSize;
        this.maxSize = maxSize;
        this.currentWriteBufferIndex = -1;
        this.nextBufferToWrite();
    }

    public long readVLong() {
        this.ponderNextBufferToRead();
        byte firstByte = this.currentReadBuffer[this.currentReadOffset++];
        int length = (byte)WritableUtils.decodeVIntSize((byte)firstByte) - 1;
        if (length == 0) {
            return firstByte;
        }
        long i = 0L;
        if (this.isAllInOneReadBuffer(length)) {
            for (int idx = 0; idx < length; ++idx) {
                i = i << 8 | (long)(this.currentReadBuffer[this.currentReadOffset + idx] & 0xFF);
            }
            this.currentReadOffset += length;
        } else {
            for (int idx = 0; idx < length; ++idx) {
                i = i << 8 | (long)(this.readNextByte() & 0xFF);
            }
        }
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public void skipVLong() {
        this.ponderNextBufferToRead();
        byte firstByte = this.currentReadBuffer[this.currentReadOffset++];
        byte length = (byte)WritableUtils.decodeVIntSize((byte)firstByte);
        if (length > 1) {
            this.currentReadOffset += length - 1;
        }
        int diff = this.currentReadOffset - this.wbSize;
        while (diff >= 0) {
            ++this.currentReadBufferIndex;
            this.currentReadBuffer = this.writeBuffers.get(this.currentReadBufferIndex);
            this.currentReadOffset = diff;
            diff = this.currentReadOffset - this.wbSize;
        }
    }

    public void setReadPoint(long offset) {
        this.currentReadBufferIndex = this.getBufferIndex(offset);
        this.currentReadBuffer = this.writeBuffers.get(this.currentReadBufferIndex);
        this.currentReadOffset = this.getOffset(offset);
    }

    public int hashCode(long offset, int length) {
        int toRead;
        this.setReadPoint(offset);
        if (this.isAllInOneReadBuffer(length)) {
            int result = WriteBuffers.murmurHash(this.currentReadBuffer, this.currentReadOffset, length);
            this.currentReadOffset += length;
            return result;
        }
        byte[] bytes = new byte[length];
        for (int destOffset = 0; destOffset < length; destOffset += toRead) {
            this.ponderNextBufferToRead();
            toRead = Math.min(length - destOffset, this.wbSize - this.currentReadOffset);
            System.arraycopy(this.currentReadBuffer, this.currentReadOffset, bytes, destOffset, toRead);
            this.currentReadOffset += toRead;
        }
        return WriteBuffers.murmurHash(bytes, 0, bytes.length);
    }

    private byte readNextByte() {
        this.ponderNextBufferToRead();
        return this.currentReadBuffer[this.currentReadOffset++];
    }

    private void ponderNextBufferToRead() {
        if (this.currentReadOffset >= this.wbSize) {
            ++this.currentReadBufferIndex;
            this.currentReadBuffer = this.writeBuffers.get(this.currentReadBufferIndex);
            this.currentReadOffset = 0;
        }
    }

    public int hashCode(byte[] key, int offset, int length) {
        return WriteBuffers.murmurHash(key, offset, length);
    }

    private void setByte(long offset, byte value) {
        this.writeBuffers.get((int)this.getBufferIndex((long)offset))[this.getOffset((long)offset)] = value;
    }

    @Override
    public void reserve(int byteCount) {
        int currentWriteOffset;
        if (byteCount < 0) {
            throw new AssertionError((Object)"byteCount must be positive");
        }
        for (currentWriteOffset = this.currentWriteOffset + byteCount; currentWriteOffset > this.wbSize; currentWriteOffset -= this.wbSize) {
            this.nextBufferToWrite();
        }
        this.currentWriteOffset = currentWriteOffset;
    }

    public void setWritePoint(long offset) {
        this.currentWriteBufferIndex = this.getBufferIndex(offset);
        this.currentWriteBuffer = this.writeBuffers.get(this.currentWriteBufferIndex);
        this.currentWriteOffset = this.getOffset(offset);
    }

    @Override
    public void write(int b) {
        if (this.currentWriteOffset == this.wbSize) {
            this.nextBufferToWrite();
        }
        this.currentWriteBuffer[this.currentWriteOffset++] = (byte)b;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        int toWrite;
        for (int srcOffset = 0; srcOffset < len; srcOffset += toWrite) {
            toWrite = Math.min(len - srcOffset, this.wbSize - this.currentWriteOffset);
            System.arraycopy(b, srcOffset + off, this.currentWriteBuffer, this.currentWriteOffset, toWrite);
            this.currentWriteOffset += toWrite;
            if (this.currentWriteOffset != this.wbSize) continue;
            this.nextBufferToWrite();
        }
    }

    @Override
    public int getLength() {
        return (int)this.getWritePoint();
    }

    private int getOffset(long offset) {
        return (int)(offset % (long)this.wbSize);
    }

    private int getBufferIndex(long offset) {
        return (int)(offset / (long)this.wbSize);
    }

    private void nextBufferToWrite() {
        if (this.currentWriteBufferIndex == this.writeBuffers.size() - 1) {
            if ((long)((1 + this.writeBuffers.size()) * this.wbSize) > this.maxSize) {
                throw new RuntimeException("Too much memory used by write buffers");
            }
            this.writeBuffers.add(new byte[this.wbSize]);
        }
        ++this.currentWriteBufferIndex;
        this.currentWriteBuffer = this.writeBuffers.get(this.currentWriteBufferIndex);
        this.currentWriteOffset = 0;
    }

    public boolean isEqual(long leftOffset, int leftLength, long rightOffset, int rightLength) {
        if (rightLength != leftLength) {
            return false;
        }
        int leftIndex = this.getBufferIndex(leftOffset);
        int rightIndex = this.getBufferIndex(rightOffset);
        int leftFrom = this.getOffset(leftOffset);
        int rightFrom = this.getOffset(rightOffset);
        byte[] leftBuffer = this.writeBuffers.get(leftIndex);
        byte[] rightBuffer = this.writeBuffers.get(rightIndex);
        if (leftFrom + leftLength <= this.wbSize && rightFrom + rightLength <= this.wbSize) {
            for (int i = 0; i < leftLength; ++i) {
                if (leftBuffer[leftFrom + i] == rightBuffer[rightFrom + i]) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < leftLength; ++i) {
            if (leftFrom == this.wbSize) {
                leftBuffer = this.writeBuffers.get(++leftIndex);
                leftFrom = 0;
            }
            if (rightFrom == this.wbSize) {
                rightBuffer = this.writeBuffers.get(++rightIndex);
                rightFrom = 0;
            }
            if (leftBuffer[leftFrom++] == rightBuffer[rightFrom++]) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(byte[] left, int leftLength, long rightOffset, int rightLength) {
        if (rightLength != leftLength) {
            return false;
        }
        int rightIndex = this.getBufferIndex(rightOffset);
        int rightFrom = this.getOffset(rightOffset);
        byte[] rightBuffer = this.writeBuffers.get(rightIndex);
        if (rightFrom + rightLength <= this.wbSize) {
            for (int i = 0; i < leftLength; ++i) {
                if (left[i] == rightBuffer[rightFrom + i]) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < rightLength; ++i) {
            if (rightFrom == this.wbSize) {
                rightBuffer = this.writeBuffers.get(++rightIndex);
                rightFrom = 0;
            }
            if (left[i] == rightBuffer[rightFrom++]) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.writeBuffers.clear();
        this.currentReadBuffer = null;
        this.currentWriteBuffer = null;
        this.currentReadBufferIndex = 0;
        this.currentWriteBufferIndex = 0;
        this.currentReadOffset = 0;
        this.currentWriteOffset = 0;
    }

    public long getWritePoint() {
        return this.currentWriteBufferIndex * this.wbSize + this.currentWriteOffset;
    }

    public long getReadPoint() {
        return this.currentReadBufferIndex * this.wbSize + this.currentReadOffset;
    }

    public void writeVLong(long value) {
        LazyBinaryUtils.writeVLong(this, value);
    }

    public void writeBytes(long offset, int length) {
        int readBufIndex = this.getBufferIndex(offset);
        byte[] readBuffer = this.writeBuffers.get(readBufIndex);
        int readBufOffset = this.getOffset(offset);
        int srcOffset = 0;
        while (srcOffset < length) {
            if (readBufOffset == this.wbSize) {
                readBuffer = this.writeBuffers.get(++readBufIndex);
                readBufOffset = 0;
            }
            if (this.currentWriteOffset == this.wbSize) {
                this.nextBufferToWrite();
            }
            int toRead = Math.min(length - srcOffset, this.wbSize - readBufOffset);
            int toWrite = Math.min(toRead, this.wbSize - this.currentWriteOffset);
            System.arraycopy(readBuffer, readBufOffset, this.currentWriteBuffer, this.currentWriteOffset, toWrite);
            this.currentWriteOffset += toWrite;
            readBufOffset += toWrite;
            srcOffset += toWrite;
            if (toRead <= toWrite) continue;
            this.nextBufferToWrite();
            System.arraycopy(readBuffer, readBufOffset, this.currentWriteBuffer, this.currentWriteOffset, toRead -= toWrite);
            this.currentWriteOffset += toRead;
            readBufOffset += toRead;
            srcOffset += toRead;
        }
    }

    public void populateValue(ByteSegmentRef value) {
        int length;
        int index = this.getBufferIndex(value.getOffset());
        byte[] buffer = this.writeBuffers.get(index);
        int bufferOffset = this.getOffset(value.getOffset());
        if (bufferOffset + (length = value.getLength()) <= this.wbSize) {
            ByteSegmentRef.access$002(value, buffer);
            value.offset = bufferOffset;
        } else {
            int toCopy;
            ByteSegmentRef.access$002(value, new byte[length]);
            value.offset = 0L;
            for (int destOffset = 0; destOffset < length; destOffset += toCopy) {
                if (destOffset > 0) {
                    buffer = this.writeBuffers.get(++index);
                    bufferOffset = 0;
                }
                toCopy = Math.min(length - destOffset, this.wbSize - bufferOffset);
                System.arraycopy(buffer, bufferOffset, value.bytes, destOffset, toCopy);
            }
        }
    }

    private boolean isAllInOneReadBuffer(int length) {
        return this.currentReadOffset + length <= this.wbSize;
    }

    private boolean isAllInOneWriteBuffer(int length) {
        return this.currentWriteOffset + length <= this.wbSize;
    }

    public void seal() {
        if ((double)this.currentWriteOffset < (double)this.wbSize * 0.8) {
            byte[] smallerBuffer = new byte[this.currentWriteOffset];
            System.arraycopy(this.currentWriteBuffer, 0, smallerBuffer, 0, this.currentWriteOffset);
            this.writeBuffers.set(this.currentWriteBufferIndex, smallerBuffer);
        }
        if (this.currentWriteBufferIndex + 1 < this.writeBuffers.size()) {
            this.writeBuffers.subList(this.currentWriteBufferIndex + 1, this.writeBuffers.size()).clear();
        }
        this.currentReadBuffer = null;
        this.currentWriteBuffer = null;
        this.currentReadBufferIndex = -1;
        this.currentWriteBufferIndex = -1;
        this.currentWriteOffset = -1;
        this.currentReadOffset = -1;
    }

    public long readFiveByteULong(long offset) {
        return this.readNByteLong(offset, 5);
    }

    private long readNByteLong(long offset, int bytes) {
        this.setReadPoint(offset);
        long v = 0L;
        if (this.isAllInOneReadBuffer(bytes)) {
            for (int i = 0; i < bytes; ++i) {
                v = (v << 8) + (long)(this.currentReadBuffer[this.currentReadOffset + i] & 0xFF);
            }
            this.currentReadOffset += bytes;
        } else {
            for (int i = 0; i < bytes; ++i) {
                v = (v << 8) + (long)(this.readNextByte() & 0xFF);
            }
        }
        return v;
    }

    public void writeFiveByteULong(long offset, long v) {
        int prevIndex = this.currentWriteBufferIndex;
        int prevOffset = this.currentWriteOffset;
        this.setWritePoint(offset);
        if (this.isAllInOneWriteBuffer(5)) {
            this.currentWriteBuffer[this.currentWriteOffset++] = (byte)(v >>> 32);
            this.currentWriteBuffer[this.currentWriteOffset++] = (byte)(v >>> 24);
            this.currentWriteBuffer[this.currentWriteOffset++] = (byte)(v >>> 16);
            this.currentWriteBuffer[this.currentWriteOffset++] = (byte)(v >>> 8);
            this.currentWriteBuffer[this.currentWriteOffset] = (byte)v;
        } else {
            this.setByte(offset++, (byte)(v >>> 32));
            this.setByte(offset++, (byte)(v >>> 24));
            this.setByte(offset++, (byte)(v >>> 16));
            this.setByte(offset++, (byte)(v >>> 8));
            this.setByte(offset, (byte)v);
        }
        this.currentWriteBufferIndex = prevIndex;
        this.currentWriteBuffer = this.writeBuffers.get(this.currentWriteBufferIndex);
        this.currentWriteOffset = prevOffset;
    }

    public int readInt(long offset) {
        return (int)this.readNByteLong(offset, 4);
    }

    @Override
    public void writeInt(long offset, int v) {
        int prevIndex = this.currentWriteBufferIndex;
        int prevOffset = this.currentWriteOffset;
        this.setWritePoint(offset);
        if (this.isAllInOneWriteBuffer(4)) {
            this.currentWriteBuffer[this.currentWriteOffset++] = (byte)(v >> 24);
            this.currentWriteBuffer[this.currentWriteOffset++] = (byte)(v >> 16);
            this.currentWriteBuffer[this.currentWriteOffset++] = (byte)(v >> 8);
            this.currentWriteBuffer[this.currentWriteOffset] = (byte)v;
        } else {
            this.setByte(offset++, (byte)(v >>> 24));
            this.setByte(offset++, (byte)(v >>> 16));
            this.setByte(offset++, (byte)(v >>> 8));
            this.setByte(offset, (byte)v);
        }
        this.currentWriteBufferIndex = prevIndex;
        this.currentWriteBuffer = this.writeBuffers.get(this.currentWriteBufferIndex);
        this.currentWriteOffset = prevOffset;
    }

    private static int murmurHash(byte[] data, int offset, int length) {
        int m = 1540483477;
        int r = 24;
        int h = length;
        int len_4 = length >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = offset + (i << 2);
            int k = data[i_4 + 3];
            k <<= 8;
            k |= data[i_4 + 2] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 1] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 0] & 0xFF;
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
        }
        int len_m = len_4 << 2;
        int left = length - len_m;
        if (left != 0) {
            length += offset;
            if (left >= 3) {
                h ^= data[length - 3] << 16;
            }
            if (left >= 2) {
                h ^= data[length - 2] << 8;
            }
            if (left >= 1) {
                h ^= data[length - 1];
            }
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    public static class ByteSegmentRef {
        private byte[] bytes = null;
        private long offset;
        private int length;

        public ByteSegmentRef(long offset, int length) {
            if (length < 0) {
                throw new AssertionError((Object)("Length is negative: " + length));
            }
            this.offset = offset;
            this.length = length;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public long getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public ByteBuffer copy() {
            byte[] copy = new byte[this.length];
            System.arraycopy(this.bytes, (int)this.offset, copy, 0, this.length);
            return ByteBuffer.wrap(copy);
        }

        static /* synthetic */ byte[] access$002(ByteSegmentRef x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }
    }
}

