/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeDimensions
extends EvalFunc<DataBag> {
    private static BagFactory bf = BagFactory.getInstance();
    private static TupleFactory tf = TupleFactory.getInstance();
    private final String allMarker;
    private static final String unknown = "unknown";

    public CubeDimensions() {
        this(null);
    }

    public CubeDimensions(String allMarker) {
        this.allMarker = allMarker;
    }

    @Override
    public DataBag exec(Tuple tuple) throws IOException {
        ArrayList result = Lists.newArrayListWithCapacity((int)((int)Math.pow(2.0, tuple.size())));
        CubeDimensions.convertNullToUnknown(tuple);
        Tuple newt = tf.newTuple(tuple.size());
        this.recursivelyCube(result, tuple, 0, newt);
        return bf.newDefaultBag(result);
    }

    public static void convertNullToUnknown(Tuple tuple) throws ExecException {
        int idx = 0;
        for (Object obj : tuple.getAll()) {
            if (obj == null) {
                tuple.set(idx, unknown);
            }
            ++idx;
        }
    }

    private void recursivelyCube(List<Tuple> result, Tuple input, int index, Tuple newt) throws ExecException {
        newt.set(index, input.get(index));
        if (index == input.size() - 1) {
            result.add(newt);
        } else {
            this.recursivelyCube(result, input, index + 1, newt);
        }
        Tuple newnewt = tf.newTuple(newt.getAll());
        newnewt.set(index, this.allMarker);
        if (index == input.size() - 1) {
            result.add(newnewt);
        } else {
            this.recursivelyCube(result, input, index + 1, newnewt);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        try {
            return new Schema(new Schema.FieldSchema("dimensions", input, 120));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }
}

