/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.apache.pig.ExceptionalFunction;
import org.apache.pig.Function;
import org.apache.pig.PrimitiveEvalFunc;
import org.apache.pig.impl.PigContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionWrapperEvalFunc
extends PrimitiveEvalFunc<Object, Object> {
    private static HashMap<Class, Type[]> resolvedTypes = new HashMap();
    private ExceptionalFunction function;
    private String counterGroup;

    public FunctionWrapperEvalFunc(String functionClassName) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, IOException {
        this(FunctionWrapperEvalFunc.initializeFunction(functionClassName));
    }

    protected FunctionWrapperEvalFunc(com.google.common.base.Function function) throws IOException, ClassNotFoundException, NoSuchMethodException {
        this(new GoogleFunctionBridge(function));
    }

    protected FunctionWrapperEvalFunc(ExceptionalFunction function) throws IOException, ClassNotFoundException, NoSuchMethodException {
        super(FunctionWrapperEvalFunc.getFunctionInClass(function), FunctionWrapperEvalFunc.getFunctionOutClass(function));
        this.function = function;
        String functionName = function instanceof GoogleFunctionBridge ? ((GoogleFunctionBridge)function).getWrappedFunction().getClass().getSimpleName() : function.getClass().getSimpleName();
        this.counterGroup = this.getClass().getName() + ":" + functionName;
    }

    @Override
    public Object exec(Object input) throws IOException {
        try {
            return this.function.apply(input);
        }
        catch (Exception e) {
            FunctionWrapperEvalFunc.safeIncrCounter(this.getCounterGroup(), e.getClass().getCanonicalName(), 1L);
            throw new IOException(e);
        }
    }

    @Override
    protected String getCounterGroup() {
        return this.counterGroup;
    }

    private static Class getFunctionInClass(ExceptionalFunction functionClassName) throws ClassNotFoundException, NoSuchMethodException, IOException {
        return FunctionWrapperEvalFunc.getFunctionTypeClass(functionClassName, 0);
    }

    private static Class getFunctionOutClass(ExceptionalFunction functionClassName) throws ClassNotFoundException, NoSuchMethodException, IOException {
        return FunctionWrapperEvalFunc.getFunctionTypeClass(functionClassName, 1);
    }

    private static Class getFunctionTypeClass(ExceptionalFunction function, int index) throws ClassNotFoundException, NoSuchMethodException, IOException {
        Type[] interfaceTypes;
        Class<ExceptionalFunction> expectedInterface;
        Class<?> clazz;
        if (function instanceof GoogleFunctionBridge) {
            clazz = ((GoogleFunctionBridge)function).getWrappedFunction().getClass();
            expectedInterface = com.google.common.base.Function.class;
        } else {
            clazz = function.getClass();
            expectedInterface = ExceptionalFunction.class;
        }
        if (resolvedTypes.containsKey(clazz)) {
            return (Class)resolvedTypes.get(clazz)[index];
        }
        for (Type interfaceType : interfaceTypes = clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType = (ParameterizedType)interfaceType;
            if (!expectedInterface.isAssignableFrom((Class)parameterizedType.getRawType())) continue;
            Type[] types = parameterizedType.getActualTypeArguments();
            resolvedTypes.put(clazz, types);
            return (Class)types[index];
        }
        throw new NoSuchMethodException("Unrecognized function class passed: " + clazz.getClass() + ". Function must implement either " + com.google.common.base.Function.class.getName() + " or " + ExceptionalFunction.class.getName());
    }

    private static ExceptionalFunction initializeFunction(String functionClassName) throws IOException, IllegalAccessException, InstantiationException {
        Object functionObject = PigContext.resolveClassName(functionClassName).newInstance();
        if (functionObject instanceof ExceptionalFunction) {
            return (ExceptionalFunction)functionObject;
        }
        if (functionObject instanceof com.google.common.base.Function) {
            return new GoogleFunctionBridge((com.google.common.base.Function)functionObject);
        }
        throw new InstantiationException("Unrecognized function class passed: " + functionObject.getClass() + ". Function must implement either " + com.google.common.base.Function.class.getName() + " or " + ExceptionalFunction.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GoogleFunctionBridge<S, T>
    implements Function {
        private com.google.common.base.Function<S, T> function;

        private GoogleFunctionBridge(com.google.common.base.Function<S, T> function) {
            this.function = function;
        }

        public com.google.common.base.Function getWrappedFunction() {
            return this.function;
        }

        @Override
        public T apply(Object item) {
            return (T)this.function.apply(item);
        }
    }
}

