/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.groovy;

import groovy.lang.Tuple;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigServer;
import org.apache.pig.builtin.OutputSchema;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.scripting.ScriptEngine;
import org.apache.pig.scripting.groovy.AccumulatorAccumulate;
import org.apache.pig.scripting.groovy.AccumulatorCleanup;
import org.apache.pig.scripting.groovy.AccumulatorGetValue;
import org.apache.pig.scripting.groovy.AlgebraicFinal;
import org.apache.pig.scripting.groovy.AlgebraicInitial;
import org.apache.pig.scripting.groovy.AlgebraicIntermed;
import org.apache.pig.scripting.groovy.GroovyAccumulatorEvalFunc;
import org.apache.pig.scripting.groovy.GroovyAlgebraicEvalFunc;
import org.apache.pig.scripting.groovy.GroovyEvalFuncObject;
import org.apache.pig.scripting.groovy.OutputSchemaFunction;
import org.apache.pig.tools.pigstats.PigStats;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyScriptEngine
extends ScriptEngine {
    private static final Log LOG = LogFactory.getLog(GroovyScriptEngine.class);
    private static groovy.util.GroovyScriptEngine gse;
    private static boolean isInitialized;

    @Override
    protected Map<String, List<PigStats>> main(PigContext context, String scriptFile) throws IOException {
        PigServer pigServer = new PigServer(context, false);
        String groovyJar = GroovyScriptEngine.getJarPath(groovy.util.GroovyScriptEngine.class);
        if (null != groovyJar) {
            pigServer.registerJar(groovyJar);
        }
        this.registerFunctions(scriptFile, null, context);
        try {
            Class c = gse.loadScriptByName(new File(scriptFile).toURI().toString());
            Method main = c.getMethod("main", String[].class);
            if (!(null != main && Modifier.isStatic(main.getModifiers()) && Modifier.isPublic(main.getModifiers()) && Void.TYPE.equals(main.getReturnType()))) {
                throw new IOException("No method 'public static void main(String[] args)' was found.");
            }
            String[] argv = (String[])ObjectSerializer.deserialize(context.getProperties().getProperty("pig.cmd.args.remainders"));
            Object[] args = new Object[]{argv};
            main.invoke(null, args);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return this.getPigStatsMap();
    }

    @Override
    public void registerFunctions(String path, String namespace, PigContext pigContext) throws IOException {
        if (!isInitialized) {
            pigContext.scriptJars.add(GroovyScriptEngine.getJarPath(groovy.util.GroovyScriptEngine.class));
            isInitialized = true;
        }
        try {
            Method[] methods;
            Class c = gse.loadScriptByName(new File(path).toURI().toString());
            HashMap<String, Method[]> algebraicMethods = new HashMap<String, Method[]>();
            HashMap<String, Method[]> accumulatorMethods = new HashMap<String, Method[]>();
            for (Method method : methods = c.getMethods()) {
                Annotation[] annotations = method.getAnnotations();
                boolean isAccumulator = false;
                if (annotations.length <= 0) continue;
                Schema schema = null;
                String schemaFunction = null;
                for (Annotation annotation : annotations) {
                    Class<?>[] params;
                    int idx;
                    if (annotation.annotationType().equals(OutputSchema.class)) {
                        schema = Utils.getSchemaFromString(((OutputSchema)annotation).value());
                        continue;
                    }
                    if (annotation.annotationType().equals(OutputSchemaFunction.class)) {
                        schemaFunction = ((OutputSchemaFunction)annotation).value();
                        continue;
                    }
                    if (GroovyScriptEngine.isAlgebraic(annotation)) {
                        String algebraic = null;
                        idx = 0;
                        if (annotation.annotationType().equals(AlgebraicInitial.class)) {
                            params = method.getParameterTypes();
                            if (1 != params.length || !Tuple.class.equals(params[0])) {
                                throw new IOException(path + ": methods annotated with @AlgebraicInitial MUST take a single groovy.lang.Tuple as parameter.");
                            }
                            if (!method.getReturnType().equals(Tuple.class) && !method.getReturnType().equals(Object[].class)) {
                                throw new IOException(path + ":" + method.getName() + " Algebraic UDF Initial method MUST return type groovy.lang.Tuple or Object[].");
                            }
                            algebraic = ((AlgebraicInitial)annotation).value();
                            idx = 0;
                        } else if (annotation.annotationType().equals(AlgebraicIntermed.class)) {
                            params = method.getParameterTypes();
                            if (1 != params.length || !Tuple.class.equals(params[0])) {
                                throw new IOException(path + ": methods annotated with @AlgebraicIntermed MUST take a single groovy.lang.Tuple as parameter.");
                            }
                            if (!method.getReturnType().equals(Tuple.class) && !method.getReturnType().equals(Object[].class)) {
                                throw new IOException(path + ":" + method.getName() + " Algebraic UDF Intermed method MUST return type groovy.lang.Tuple or Object[].");
                            }
                            algebraic = ((AlgebraicIntermed)annotation).value();
                            idx = 1;
                        } else {
                            params = method.getParameterTypes();
                            if (1 != params.length || !Tuple.class.equals(params[0])) {
                                throw new IOException(path + ": methods annotated with @AlgebraicFinal MUST take a single groovy.lang.Tuple as parameter.");
                            }
                            algebraic = ((AlgebraicFinal)annotation).value();
                            idx = 2;
                        }
                        Method[] algmethods = (Method[])algebraicMethods.get(algebraic);
                        if (null == algmethods) {
                            algmethods = new Method[3];
                            algebraicMethods.put(algebraic, algmethods);
                        }
                        if (null != algmethods[idx]) {
                            throw new IOException(path + ": Algebraic UDF '" + algebraic + "' already has an " + annotation.annotationType().getSimpleName() + " method defined ('" + algmethods[idx] + "')");
                        }
                        algmethods[idx] = method;
                        continue;
                    }
                    if (!GroovyScriptEngine.isAccumulator(annotation)) continue;
                    String accumulator = null;
                    idx = 0;
                    if (annotation.annotationType().equals(AccumulatorAccumulate.class)) {
                        params = method.getParameterTypes();
                        if (1 != params.length || !Tuple.class.equals(params[0])) {
                            throw new IOException(path + ": methods annotated with @AccumulatorAccumulate MUST take a single groovy.lang.Tuple as parameter.");
                        }
                        accumulator = ((AccumulatorAccumulate)annotation).value();
                        idx = 0;
                    } else if (annotation.annotationType().equals(AccumulatorGetValue.class)) {
                        params = method.getParameterTypes();
                        if (0 != params.length) {
                            throw new IOException(path + ": methods annotated with @AccumulatorGetValue take no parameters.");
                        }
                        accumulator = ((AccumulatorGetValue)annotation).value();
                        isAccumulator = true;
                        idx = 1;
                    } else if (annotation.annotationType().equals(AccumulatorCleanup.class)) {
                        params = method.getParameterTypes();
                        if (0 != params.length) {
                            throw new IOException(path + ": methods annotated with @AccumulatorCleanup take no parameters and return void.");
                        }
                        accumulator = ((AccumulatorCleanup)annotation).value();
                        idx = 2;
                    }
                    Method[] accumethods = (Method[])accumulatorMethods.get(accumulator);
                    if (null == accumethods) {
                        accumethods = new Method[3];
                        accumulatorMethods.put(accumulator, accumethods);
                    }
                    if (null != accumethods[idx]) {
                        throw new IOException(path + ": Accumulator UDF '" + accumulator + "' already has an " + annotation.annotationType().getSimpleName() + " method defined ('" + accumethods[idx] + "')");
                    }
                    accumethods[idx] = method;
                }
                if (null == schema && null == schemaFunction) {
                    LOG.info((Object)(path + ": Only methods annotated with @OutputSchema or @OutputSchemaFunction (but not with @AccumulatorGetValue are exposed to Pig, skipping method '" + method.getName() + "'"));
                    continue;
                }
                if (null != schema && null != schemaFunction) {
                    LOG.info((Object)("Annotation @OutputSchemaFunction has precedence over @OutputSchema for method '" + method.getName() + "'"));
                }
                if (isAccumulator) continue;
                namespace = namespace == null ? "" : namespace;
                FuncSpec spec = new FuncSpec(GroovyEvalFuncObject.class.getCanonicalName() + "('" + path + "','" + namespace + "','" + method.getName() + "')");
                pigContext.registerFunction(("".equals(namespace) ? "" : namespace + ".") + method.getName(), spec);
                LOG.info((Object)(path + ": Register Groovy UDF: " + ("".equals(namespace) ? "" : namespace + ".") + method.getName()));
            }
            for (String algebraic : algebraicMethods.keySet()) {
                Method[] algmethods = (Method[])algebraicMethods.get(algebraic);
                if (null == algmethods[0]) {
                    throw new IOException(path + ": Algebratic UDF '" + algebraic + "' does not have an Initial method defined.");
                }
                if (null == algmethods[1]) {
                    throw new IOException(path + ": Algebratic UDF '" + algebraic + "' does not have an Intermed method defined.");
                }
                if (null == algmethods[2]) {
                    throw new IOException(path + ": Algebratic UDF '" + algebraic + "' does not have a Final method defined.");
                }
                String className = null;
                Class<?> returnType = algmethods[2].getReturnType();
                if (returnType.equals(Tuple.class) || returnType.equals(Object[].class) || returnType.equals(org.apache.pig.data.Tuple.class)) {
                    className = GroovyAlgebraicEvalFunc.TupleGroovyAlgebraicEvalFunc.class.getName();
                } else if (returnType.equals(List.class) || returnType.equals(DataBag.class)) {
                    className = GroovyAlgebraicEvalFunc.DataBagGroovyAlgebraicEvalFunc.class.getName();
                } else if (returnType.equals(DateTime.class)) {
                    className = GroovyAlgebraicEvalFunc.DateTimeGroovyAlgebraicEvalFunc.class.getName();
                } else if (returnType.equals(Boolean.class) || returnType.equals(Boolean.TYPE)) {
                    className = GroovyAlgebraicEvalFunc.BooleanGroovyAlgebraicEvalFunc.class.getName();
                } else if (returnType.equals(byte[].class) || returnType.equals(DataByteArray.class)) {
                    className = GroovyAlgebraicEvalFunc.DataByteArrayGroovyAlgebraicEvalFunc.class.getName();
                } else if (returnType.equals(String.class)) {
                    className = GroovyAlgebraicEvalFunc.ChararrayGroovyAlgebraicEvalFunc.class.getName();
                } else if (returnType.equals(Double.class) || returnType.equals(Double.TYPE) || returnType.equals(BigDecimal.class)) {
                    className = GroovyAlgebraicEvalFunc.DoubleGroovyAlgebraicEvalFunc.class.getName();
                } else if (returnType.equals(Float.class) || returnType.equals(Float.TYPE)) {
                    className = GroovyAlgebraicEvalFunc.FloatGroovyAlgebraicEvalFunc.class.getName();
                } else if (returnType.equals(Byte.class) || returnType.equals(Byte.TYPE) || returnType.equals(Short.class) || returnType.equals(Short.TYPE) || returnType.equals(Integer.class) || returnType.equals(Integer.TYPE)) {
                    className = GroovyAlgebraicEvalFunc.IntegerGroovyAlgebraicEvalFunc.class.getName();
                } else if (returnType.equals(Long.class) || returnType.equals(Long.TYPE) || returnType.equals(BigInteger.class)) {
                    className = GroovyAlgebraicEvalFunc.LongGroovyAlgebraicEvalFunc.class.getName();
                } else if (returnType.equals(Map.class)) {
                    className = GroovyAlgebraicEvalFunc.MapGroovyAlgebraicEvalFunc.class.getName();
                } else if (returnType.equals(BigDecimal.class)) {
                    className = GroovyAlgebraicEvalFunc.BigDecimalGroovyAlgebraicEvalFunc.class.getName();
                } else if (returnType.equals(BigInteger.class)) {
                    className = GroovyAlgebraicEvalFunc.BigIntegerGroovyAlgebraicEvalFunc.class.getName();
                } else {
                    throw new RuntimeException(path + ": Unknown return type for Algebraic UDF '" + algebraic + "'");
                }
                FuncSpec spec = new FuncSpec(className + "('" + path + "','" + namespace + "','" + algebraic + "','" + algmethods[0].getName() + "','" + algmethods[1].getName() + "','" + algmethods[2].getName() + "')");
                pigContext.registerFunction(("".equals(namespace) ? "" : namespace + ".") + algebraic, spec);
                LOG.info((Object)("Register Groovy Algebraic UDF: " + ("".equals(namespace) ? "" : namespace + ".") + algebraic));
            }
            for (String accumulator : accumulatorMethods.keySet()) {
                Method[] accumethods = (Method[])accumulatorMethods.get(accumulator);
                if (null == accumethods[0]) {
                    throw new IOException(path + ": Accumulator UDF '" + accumulator + "' does not have an Accumulate method defined.");
                }
                if (null == accumethods[1]) {
                    throw new IOException(path + ": Accumulator UDF '" + accumulator + "' does not have a GetValue method defined.");
                }
                if (null == accumethods[2]) {
                    throw new IOException(path + ": Accumulator UDF '" + accumulator + "' does not have a Cleanup method defined.");
                }
                FuncSpec spec = new FuncSpec(GroovyAccumulatorEvalFunc.class.getName() + "('" + path + "','" + namespace + "','" + accumulator + "','" + accumethods[0].getName() + "','" + accumethods[1].getName() + "','" + accumethods[2].getName() + "')");
                pigContext.registerFunction(("".equals(namespace) ? "" : namespace + ".") + accumulator, spec);
                LOG.info((Object)("Register Groovy Accumulator UDF: " + ("".equals(namespace) ? "" : namespace + ".") + accumulator));
            }
        }
        catch (ResourceException re) {
            throw new IOException(re);
        }
        catch (ScriptException se) {
            throw new IOException(se);
        }
    }

    @Override
    protected Map<String, Object> getParamsFromVariables() throws IOException {
        return null;
    }

    @Override
    protected String getScriptingLang() {
        return "groovy";
    }

    protected static groovy.util.GroovyScriptEngine getEngine() {
        return gse;
    }

    private static boolean isAlgebraic(Annotation annotation) {
        return annotation.annotationType().equals(AlgebraicInitial.class) || annotation.annotationType().equals(AlgebraicIntermed.class) || annotation.annotationType().equals(AlgebraicFinal.class);
    }

    private static boolean isAccumulator(Annotation annotation) {
        return annotation.annotationType().equals(AccumulatorAccumulate.class) || annotation.annotationType().equals(AccumulatorGetValue.class) || annotation.annotationType().equals(AccumulatorCleanup.class);
    }

    static {
        isInitialized = false;
        try {
            gse = new groovy.util.GroovyScriptEngine("");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

