/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.ListSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ListSinkDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.mapred.JobConf;

@Explain(displayName="Fetch Operator")
public class FetchWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String tblDir;
    private TableDesc tblDesc;
    private ArrayList<String> partDir;
    private ArrayList<PartitionDesc> partDesc;
    private Operator<?> source;
    private ListSinkOperator sink;
    private int limit;
    private int leastNumRows;
    private SplitSample splitSample;
    private String serializationNullFormat = "NULL";

    public FetchWork() {
    }

    public FetchWork(String tblDir, TableDesc tblDesc) {
        this(tblDir, tblDesc, -1);
    }

    public FetchWork(String tblDir, TableDesc tblDesc, int limit) {
        this.tblDir = tblDir;
        this.tblDesc = tblDesc;
        this.limit = limit;
    }

    public FetchWork(List<String> partDir, List<PartitionDesc> partDesc, TableDesc tblDesc) {
        this(partDir, partDesc, tblDesc, -1);
    }

    public FetchWork(List<String> partDir, List<PartitionDesc> partDesc, TableDesc tblDesc, int limit) {
        this.tblDesc = tblDesc;
        this.partDir = new ArrayList<String>(partDir);
        this.partDesc = new ArrayList<PartitionDesc>(partDesc);
        this.limit = limit;
    }

    public void initializeForFetch() {
        if (this.source == null) {
            this.sink = new ListSinkOperator();
            this.sink.setConf(new ListSinkDesc(this.serializationNullFormat));
            this.source = this.sink;
        }
    }

    public String getSerializationNullFormat() {
        return this.serializationNullFormat;
    }

    public void setSerializationNullFormat(String format) {
        this.serializationNullFormat = format;
    }

    public boolean isNotPartitioned() {
        return this.tblDir != null;
    }

    public boolean isPartitioned() {
        return this.tblDir == null;
    }

    public String getTblDir() {
        return this.tblDir;
    }

    public Path getTblDirPath() {
        return new Path(this.tblDir);
    }

    public void setTblDir(String tblDir) {
        this.tblDir = tblDir;
    }

    public TableDesc getTblDesc() {
        return this.tblDesc;
    }

    public void setTblDesc(TableDesc tblDesc) {
        this.tblDesc = tblDesc;
    }

    public ArrayList<String> getPartDir() {
        return this.partDir;
    }

    public List<Path> getPartDirPath() {
        return FetchWork.convertStringToPathArray(this.partDir);
    }

    public static List<String> convertPathToStringArray(List<Path> paths) {
        if (paths == null) {
            return null;
        }
        ArrayList<String> pathsStr = new ArrayList<String>();
        for (Path path : paths) {
            pathsStr.add(path.toString());
        }
        return pathsStr;
    }

    public static List<Path> convertStringToPathArray(List<String> paths) {
        if (paths == null) {
            return null;
        }
        ArrayList<Path> pathsStr = new ArrayList<Path>();
        for (String path : paths) {
            pathsStr.add(new Path(path));
        }
        return pathsStr;
    }

    public void setPartDir(ArrayList<String> partDir) {
        this.partDir = partDir;
    }

    public ArrayList<PartitionDesc> getPartDesc() {
        return this.partDesc;
    }

    @Explain(displayName="Partition Description", normalExplain=false)
    public ArrayList<PartitionDesc> getPartDescOrderedByPartDir() {
        ArrayList<PartitionDesc> partDescOrdered = this.partDesc;
        if (this.partDir != null && this.partDir.size() > 1) {
            if (this.partDesc == null || this.partDir.size() != this.partDesc.size()) {
                throw new RuntimeException("Partiton Directory list size doesn't match Partition Descriptor list size");
            }
            TreeMap<String, PartitionDesc> partDirToPartSpecMap = new TreeMap<String, PartitionDesc>();
            for (int i = 0; i < this.partDir.size(); ++i) {
                partDirToPartSpecMap.put(this.partDir.get(i), this.partDesc.get(i));
            }
            partDescOrdered = new ArrayList(partDirToPartSpecMap.values());
        }
        return partDescOrdered;
    }

    public List<PartitionDesc> getPartDescs(List<Path> paths) {
        ArrayList<PartitionDesc> parts = new ArrayList<PartitionDesc>(paths.size());
        for (Path path : paths) {
            parts.add(this.partDesc.get(this.partDir.indexOf(path.getParent().toString())));
        }
        return parts;
    }

    public void setPartDesc(ArrayList<PartitionDesc> partDesc) {
        this.partDesc = partDesc;
    }

    @Explain(displayName="limit")
    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLeastNumRows() {
        return this.leastNumRows;
    }

    public void setLeastNumRows(int leastNumRows) {
        this.leastNumRows = leastNumRows;
    }

    @Explain(displayName="Processor Tree")
    public Operator<?> getSource() {
        return this.source;
    }

    public void setSource(Operator<?> source) {
        this.source = source;
    }

    public ListSinkOperator getSink() {
        return this.sink;
    }

    public void setSink(ListSinkOperator sink) {
        this.sink = sink;
    }

    public void setSplitSample(SplitSample splitSample) {
        this.splitSample = splitSample;
    }

    public SplitSample getSplitSample() {
        return this.splitSample;
    }

    public String toString() {
        if (this.tblDir != null) {
            return new String("table = " + this.tblDir);
        }
        if (this.partDir == null) {
            return "null fetchwork";
        }
        String ret = "partition = ";
        for (String part : this.partDir) {
            ret = ret.concat(part);
        }
        return ret;
    }

    public void configureJobConf(JobConf jobConf) {
        if (this.tblDesc != null) {
            PlanUtils.configureJobConf(this.tblDesc, jobConf);
        }
        if (this.partDesc != null) {
            for (PartitionDesc part : this.partDesc) {
                PlanUtils.configureJobConf(part.getTableDesc(), jobConf);
            }
        }
    }
}

