/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.pentaho.hadoop.shim.api.fs.FileSystem;
import org.pentaho.hadoop.shim.api.fs.Path;
import org.pentaho.hadoop.shim.common.ShimUtils;
import org.pentaho.hadoop.shim.common.fs.PathProxy;

public class FileSystemProxy
extends org.apache.hadoop.fs.FileSystem
implements FileSystem {
    private org.apache.hadoop.fs.FileSystem delegate;

    public FileSystemProxy(org.apache.hadoop.fs.FileSystem delegate) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    protected org.apache.hadoop.fs.FileSystem getDelegate(org.apache.hadoop.fs.Path hadoopPath) {
        return (org.apache.hadoop.fs.FileSystem)this.getDelegate();
    }

    protected org.apache.hadoop.fs.FileSystem getDelegate(Path pentahoPath) {
        return this.getDelegate(ShimUtils.asPath(pentahoPath));
    }

    public Path asPath(String path) {
        return new PathProxy(path);
    }

    public Path asPath(Path parent, String child) {
        return new PathProxy(parent, child);
    }

    public Path asPath(String parent, String child) {
        return new PathProxy(parent, child);
    }

    public boolean exists(Path path) throws IOException {
        return this.getDelegate(path).exists(ShimUtils.asPath(path));
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        return this.delete(ShimUtils.asPath(path), recursive);
    }

    public FSDataOutputStream append(org.apache.hadoop.fs.Path f, int bufferSize, Progressable progress) throws IOException {
        return this.getDelegate(f).append(f, bufferSize, progress);
    }

    public FSDataOutputStream create(org.apache.hadoop.fs.Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.getDelegate(f).create(f, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Deprecated
    public boolean delete(org.apache.hadoop.fs.Path f) throws IOException {
        return this.getDelegate(f).delete(f);
    }

    public boolean delete(org.apache.hadoop.fs.Path f, boolean recursive) throws IOException {
        return this.getDelegate(f).delete(f, recursive);
    }

    public FileStatus getFileStatus(org.apache.hadoop.fs.Path f) throws IOException {
        return this.getDelegate(f).getFileStatus(f);
    }

    public URI getUri() {
        return this.delegate.getUri();
    }

    public org.apache.hadoop.fs.Path getWorkingDirectory() {
        return this.delegate.getWorkingDirectory();
    }

    public FileStatus[] listStatus(org.apache.hadoop.fs.Path f) throws IOException {
        return this.getDelegate(f).listStatus(f);
    }

    public boolean mkdirs(org.apache.hadoop.fs.Path f, FsPermission permission) throws IOException {
        return this.getDelegate(f).mkdirs(f, permission);
    }

    public FSDataInputStream open(org.apache.hadoop.fs.Path f, int bufferSize) throws IOException {
        return this.getDelegate(f).open(f, bufferSize);
    }

    public boolean rename(org.apache.hadoop.fs.Path src, org.apache.hadoop.fs.Path dst) throws IOException {
        return this.getDelegate(src).rename(src, dst);
    }

    public void setWorkingDirectory(org.apache.hadoop.fs.Path f) {
        this.getDelegate(f).setWorkingDirectory(f);
    }
}

