/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.emr34;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hive.jdbc.HiveDriver;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.HadoopConfigurationFileSystemManager;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.api.fs.FileSystem;
import org.pentaho.hadoop.shim.api.mapred.RunningJob;
import org.pentaho.hadoop.shim.common.CommonHadoopShim;
import org.pentaho.hadoop.shim.common.DistributedCacheUtilImpl;
import org.pentaho.hadoop.shim.common.ShimUtils;
import org.pentaho.hadoop.shim.emr34.ConfigurationProxyV2;
import org.pentaho.hadoop.shim.emr34.FileSystemProxyV2;
import org.pentaho.hadoop.shim.emr34.RunningJobProxyV2;
import org.pentaho.hdfs.vfs.HDFSFileProvider;

public class HadoopShim
extends CommonHadoopShim {
    @Override
    protected String getDefaultNamenodePort() {
        return "8020";
    }

    @Override
    protected String getDefaultJobtrackerPort() {
        return "8021";
    }

    @Override
    public void onLoad(HadoopConfiguration config, HadoopConfigurationFileSystemManager fsm) throws Exception {
        fsm.addProvider(config, "hdfs", config.getIdentifier(), (FileProvider)new HDFSFileProvider());
        this.setDistributedCacheUtil(new DistributedCacheUtilImpl(config){

            @Override
            public void addFileToClassPath(Path file, org.apache.hadoop.conf.Configuration conf) throws IOException {
                String classpath = conf.get("mapred.job.classpath.files");
                conf.set("mapred.job.classpath.files", classpath == null ? file.toString() : classpath + this.getClusterPathSeparator() + file.toString());
                org.apache.hadoop.fs.FileSystem fs = org.apache.hadoop.fs.FileSystem.get((org.apache.hadoop.conf.Configuration)conf);
                URI uri = fs.makeQualified(file).toUri();
                DistributedCache.addCacheFile((URI)uri, (org.apache.hadoop.conf.Configuration)conf);
            }

            @Override
            public String getClusterPathSeparator() {
                return System.getProperty("hadoop.cluster.path.separator", ",");
            }
        });
        if (!fsm.hasProvider("s3n")) {
            fsm.addProvider(config, "s3n", config.getIdentifier(), (FileProvider)new HDFSFileProvider());
        }
    }

    @Override
    public RunningJob submitJob(Configuration c) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            Job job = ((ConfigurationProxyV2)c).getJob();
            job.submit();
            RunningJobProxyV2 runningJobProxyV2 = new RunningJobProxyV2(job);
            return runningJobProxyV2;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public Configuration createConfiguration() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            ConfigurationProxyV2 configurationProxyV2 = new ConfigurationProxyV2();
            return configurationProxyV2;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create configuration for new mapreduce api: ", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem getFileSystem(Configuration conf) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            FileSystemProxyV2 fileSystemProxyV2 = new FileSystemProxyV2(ShimUtils.asConfiguration(conf));
            return fileSystemProxyV2;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    static {
        JDBC_DRIVER_MAP.put("hive2", HiveDriver.class);
    }
}

